<?php if ( !defined( 'ABSPATH' ) ) exit();
	global $post;

	$id 		= get_the_ID();
	$gallery 	= get_post_meta( $id, 'ova_por_met_gallery', true );
	$date 		= get_post_meta( $id, 'ova_por_met_date', true );
	$location 	= get_post_meta( $id, 'ova_por_met_location', true );
	$department = get_post_meta( $id, 'ova_por_met_department', true );
?>

<div class="wrap-portfolio">
	<div class="single-por type2">

		<?php if ( $show_category == 'yes' || $show_date == 'yes' || $show_location == 'yes' || $show_department == 'yes' ) { ?>
			<div class="info-por">
				<?php if ( $show_category == 'yes' ) { ?>
					<div class="category">
						<label class="second_font"><?php esc_html_e( 'Category', 'ova-por' ); ?></label>
						<?php get_category_por_by_id_por( $id ); ?>
					</div>
				<?php } ?>

				<?php if ( $show_date == 'yes' ) { ?>
					<div class="date">
						<label class="second_font"><?php esc_html_e( 'Date', 'ova-por' ); ?></label>
						<span><?php echo esc_html( $date ); ?></span>
					</div>
				<?php } ?>

				<?php if ( $show_location == 'yes' ) { ?>
					<div class="location">
						<label class="second_font"><?php esc_html_e( 'Location', 'ova-por' ); ?></label>
						<span><?php echo esc_html( $location ); ?></span>
					</div>
				<?php } ?>

				<?php if ( $show_department == 'yes' ) { ?>
					<div class="department">
						<label class="second_font"><?php esc_html_e( 'Department', 'ova-por' ); ?></label>
						<span><?php echo esc_html( $department ); ?></span>
					</div>
				<?php } ?>
			</div>
		<?php } ?>

		<?php if ( ! empty( $gallery ) && $show_gallery == 'yes' ) { 
			$i = 0; $data_gallery = []; 
		?>
			<div class="por-gallery">
				<?php foreach ( $gallery as $img_id => $val ) { 
					$img_alt 	= "";
					$mime_type 	= get_post_mime_type( $img_id );
					$img_url 	= wp_get_attachment_image_url( $img_id, 'ova_por_thumbnail');
					if ( ! empty( $img_id ) ) {
						$img_alt = get_post_meta( $img_id, '_wp_attachment_image_alt', true );

						if ( empty( $img_alt ) ) {
							$img_alt = get_the_title( $img_id );
						}
					}

					$data_image = array(
	                    'src'       => $val,
	                    'caption'   => $img_alt,
	                    'thumb'     => $val,
	                );

	                if ( $mime_type == 'video/mp4' ) {
						$video_thumb = get_the_post_thumbnail_url( $id, 'ova_por_thumbnail' );
						$data_image['thumb'] = $video_thumb;
						$img_url = $video_thumb;
					};

					array_push( $data_gallery , $data_image);
				?>
					<div class="item-gallery">
						<div class="por-gallery-fancybox" data-index="<?php echo esc_attr( $i ); ?>">
							<img src="<?php echo esc_url( $img_url ); ?>" alt="<?php echo esc_attr( $img_alt ); ?>">
							<span class="icon">
								<?php ova_por_show_icon( $mime_type ); ?>
							</span>
						</div>
					</div>
				<?php $i++; } ?>
				<input type="hidden" class="ova-data-gallery" data-gallery="<?php echo esc_attr( json_encode( $data_gallery ) ); ?>">
			</div>
		<?php } ?>

		<div class="wrap-content-por">
			<div class="content">
				<?php if ( $show_content == 'yes' ) { ?>
					<?php if( have_posts() ) : while( have_posts() ) : the_post();
						the_content();
					endwhile; endif; wp_reset_postdata(); ?>
				<?php } ?>

		        <?php if ( $show_comments == 'yes' ) {
		        	if( comments_open( get_the_ID() ) ) {
			        	comments_template(); 
			        }
		        } ?>
			</div>
		</div>

		<div class="single-foot-por">
			<?php if ( has_filter( 'ova_share_social' ) && $show_share == 'yes' ) { ?>
		        <div class="share_social">
		        	<?php echo apply_filters('ova_share_social', get_the_permalink(), get_the_title() ); ?>
		        </div>
	        <?php } ?>

			<?php if ($show_next_prev == 'yes') :
				$prev_post = get_previous_post();
				$next_post = get_next_post();

				if ( $next_post || $prev_post ) { 
			?>
				<div class="ova-next-pre-post">
					<?php if ( $prev_post ) { ?>
						<a class="pre" href="<?php echo esc_attr( get_permalink( $prev_post->ID ) ); ?>" title="<?php esc_html_e('Previous', 'ova-por'); ?>">
							<span class="num-1">
								<span class="icon"><i class="ovaicon-back"></i></span>
							</span>
							<span class="num-2">
								<span class="second_font text-label"><?php esc_html_e('Previous', 'ova-por'); ?></span>
								<span class="second_font title" ><?php echo esc_html( get_the_title( $prev_post->ID ) ); ?></span>
							</span>
						</a>
					<?php } ?>
						<a class="ova-slash" href="<?php echo get_post_type_archive_link('ova_por'); ?>" title="<?php esc_html_e('Slash', 'ova-por'); ?>">
							<?php if ( $prev_post && $next_post ) { ?>
								<span></span>
								<span></span>
								<span></span>
							<?php } ?>
						</a>
					<?php if( $next_post ) { ?>
						<a class="next" href="<?php echo esc_attr(get_permalink($next_post->ID)); ?> " title="<?php esc_html_e('Next', 'ova-por'); ?>">
							<span class="num-1">
								<span class="icon">
									<i class="ovaicon-next"></i>
								</span>
							</span>
							<span class="num-2">
								<span class="second_font text-label"><?php esc_html_e('Next', 'ova-por'); ?></span>
								<span class="second_font title"><?php echo esc_html(get_the_title($next_post->ID)); ?></span>
							</span>
						</a>
					<?php } ?>
				</div>
			<?php } endif; ?>
		</div>

	</div>
</div>

<?php if($show_related == 'yes') {
	get_portfolio_related_by_id( $id );
} ?>