<?php
namespace ova_sev_elementor\Widgets;

use Elementor\Widget_Base;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class ova_service_ajax extends Widget_Base {

	public function get_name() {
		return 'ova_service_ajax';
	}

	public function get_title() {
		return esc_html__( 'Service Ajax', 'ova-sev' );
	}

	public function get_icon() {
		return 'eicon-post-list';
	}

	public function get_categories() {
		return [ 'ovatheme_service' ];
	}

	public function get_script_depends() {
		wp_enqueue_script('ova-sev-ajax', OVASEV_PLUGIN_URI.'assets/js/elementor/sev-ajax.js', array('jquery'), false, true);
		wp_localize_script( 'ova-sev-ajax', 'ova_sev_ajax_object', array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );
		return [ '' ];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'ova-sev-ajax', OVASEV_PLUGIN_URI.'/assets/css/elementor/sev-ajax.css', array(), null);
		return [];
	}

	protected function register_controls() {

		/* Content */
		$this->start_controls_section(
				'content_section',
				[
					'label' => esc_html__( 'Content', 'ova-sev' ),
					'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				]
			);

			$this->add_control(
				'posts_per_page',
				[
					'label'   		=> esc_html__( 'Posts Per Page', 'ova-sev' ),
					'type'    		=> \Elementor\Controls_Manager::NUMBER,
					'default'       => 9
				]
			);

			$this->add_control(
				'order',
				[
					'label' => esc_html__( 'Order', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'ASC',
					'options' => [
						'ASC' => esc_html__( 'Ascending', 'ova-sev' ),
						'DESC' => esc_html__( 'Descending', 'ova-sev' ),
					],
				]
			);

			$this->add_control(
				'orderby',
				[
					'label' => esc_html__( 'Order By', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'title',
					'options' => [
						'ID'  	=> esc_html__( 'ID', 'ova-sev' ),
						'date'  => esc_html__( 'Date', 'ova-sev' ),
						'title' => esc_html__( 'Title', 'ova-sev' ),
						'rand'  => esc_html__( 'Random', 'ova-sev' ),
						'ova_sev_met_order_sev' => esc_html__( 'Sort Order', 'ova-sev' ),
					],
				]
			);
		
			$this->add_control(
				'category_not_in',
				[
					'label'   		=> esc_html__( 'Category Not In', 'ova-sev' ),
					'type'    		=> \Elementor\Controls_Manager::TEXT,
					'description' 	=> esc_html__( 'Enter the service category IDs. IDs are separated by "|". Ex: 1|2|3.', 'ova-sev' ),
				]
			);

			$this->add_control(
				'show_desc',
				[
					'label' => esc_html__( 'Show Short Description', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-sev' ),
					'label_off' => esc_html__( 'Hide', 'ova-sev' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);
			
		$this->end_controls_section();

	}


	protected function render() {
		$settings = $this->get_settings_for_display();
		$template = apply_filters( 'el_elementor_ova_service_ajax', 'elementor/ova_service_ajax.php' );

		ob_start();
		ovasev_get_template( $template, $settings );
		echo ob_get_clean();
	}
}
