<?php if ( !defined( 'ABSPATH' ) ) exit();

global $post;

$id = get_the_ID();

$category_not_in = isset($args['category_not_in']) ? $args['category_not_in'] : '';

$args_query = array(
	'taxonomy' 	 => 'cat_sev',
	'orderby' 	 => 'name',
	'order'   	 => 'ASC',
	'hide_empty' => false,
	'parent' 	 => 0,
	'exclude'    => explode( '|', $category_not_in )
);

$sev_title = $args['sev_title'];

$terms     = get_the_terms( $post, 'cat_sev' );
$term_ids  = [];

if ( $terms ) {
	foreach ($terms as $key => $term) {
		array_push( $term_ids, $term->term_id );
	}
}

$categories = get_categories($args_query);
$term_id 	= get_queried_object_id();

?>

<div class="ova-sev-category">
	<h2 class="title"><?php echo esc_html( $sev_title ); ?></h2>
	<div class="service-cat-list">
		<?php if ( $categories ): foreach ($categories as $category):
			$active_class = $category->term_id == $term_id ? 'active' : '';
			if ( $id ) {
				$active_class = in_array( $category->term_id, $term_ids) ? 'active' : '';
			}
		?>
			<div class="item">
				<a href="<?php echo esc_url( get_term_link( $category ) ); ?>"
					class="item-link <?php echo esc_attr( $active_class ); ?>"
					data-slug="<?php echo esc_attr( $category->slug ); ?>"
					title="<?php echo esc_attr( $category->name ); ?>"
				>
					<span class="cate_name"><?php echo esc_html( $category->name ); ?></span>
					<?php if (get_term_children( $category->term_id, 'cat_sev' ) ): ?>
						<i class="fas fa-plus" role="button" aria-label="<?php esc_attr_e('Category Dropdown','ova-sev'); ?>"></i>
					<?php endif; ?>	
				</a>
				<?php ova_sev_get_child_cate( $category->term_id, $term_ids ); ?>
			</div>	
		<?php endforeach; endif;  ?>
	</div>
</div>