<?php if ( !defined( 'ABSPATH' ) ) exit();

	$cate_slug  = 'all';

	// Services
	$args_query = array(
		'order_by' 			=> $order_by,
		'order' 			=> $order,
		'posts_per_page' 	=> $posts_per_page,
		'cate' 				=> $cate_slug,
	);

	$list_sevs = ova_sev_query( $args_query );

	$all_ids   = ova_sev_get_all_id();
	$all_names = [];

	foreach ($all_ids as $id ) {
		$all_names[$id] = get_the_title($id);
	}

	// show fields
	$args_show = array(
		'show_icon' 		 => $show_icon,
		'show_title' 		 => $show_title,
		'show_link_of_title' => $show_link_of_title,
		'show_desc' 		 => $show_desc,
		'show_button' 		 => $show_button,
		'show_total_results' => $show_total_results,
		'show_sort_by' 		 => $show_sort_by,
	);

	// search sort	
	if( ($order_by == 'ID' || $order_by == 'date') && $order == 'DESC' ) {
		$search_sort_default = 'date-desc';
	} elseif( ($order_by == 'ID' || $order_by == 'date') && $order == 'ASC' ) {
		$search_sort_default = 'date-asc';
	} elseif( $order_by == 'title' && $order == 'DESC' ) {
		$search_sort_default = 'z-a';
	} elseif( $order_by == 'title' && $order == 'ASC' ) {
		$search_sort_default = 'a-z';
	} elseif( $order_by == 'ova_sev_met_order_sev' && $order == 'ASC' ) {
		$search_sort_default = 'sort-order-asc';
	} elseif( $order_by == 'ova_sev_met_order_sev' && $order == 'DESC' ) {
		$search_sort_default = 'sort-order-desc';
	} elseif( $order_by == 'rand' ) {
		$search_sort_default = 'rand';
	} else {
		$search_sort_default = 'date-desc';
	}

?>

<div class="ova-sev-archive has-sev-filter ova-sev-search-ajax <?php echo esc_attr( $number_column ); ?>" 
	data-names="<?php echo esc_attr(json_encode($all_names)); ?>" 
	data-post_per_page="<?php echo esc_attr($posts_per_page );?>"
	data-order="<?php echo esc_attr($order );?>"
	data-order_by="<?php echo esc_attr($order_by );?>"
	data-sort_default="<?php echo esc_attr( $search_sort_default ); ?>"
	data-args_show="<?php echo esc_attr( json_encode($args_show) );?>"
>

	<?php if($show_search_name == 'yes' || $show_search_category == 'yes' ) : ?>
		<form id="ova-sev-filter" class="ova-sev-filter" method="POST" autocomplete="off">
			<div class="wrapper">
				<?php if($show_search_name == 'yes') : ?>
					<div class="sev-name">
						<input type="text" name="ovasev_name" aria-label="<?php esc_attr_e( 'Service Name', 'ova-sev' ); ?>" id="ovasev_name" class="ovasev_name" placeholder="Name">
					</div>
				<?php endif;?>

				<?php if($show_search_category == 'yes') : ?>
					<div class="ovasev_cat_search">
						<label for="ovasev_category" class="visuallyhidden"><?php esc_html_e( 'Categories', 'ova-sev' ); ?></label>
						<?php $ovadoc_cat_dropdown = apply_filters( 'ovasev_cat_dropdown', $cate_slug ); ?>
						<i class="arrow_carrot-down" aria-hidden="true"></i>
					</div>
				<?php endif;?>

				<div class="wrap-ovasev_submit">
					<button type="submit" class="ovasev_submit" aria-label="<?php esc_attr_e( 'Search Service', 'ova-sev' ); ?>"><?php esc_html_e( 'Search', 'ova-sev' ); ?></button>
				</div>
			</div>
		</form>
	<?php endif;?>

	<div class="ova-sev-loader">
		<div class="loader" aria-hidden="true"></div>
	</div>

	<div class="content_inner">
		<div class="wrap_search_filter">
			<?php if ( $show_total_results == 'yes' ): ?>
				<div class="results_found">
					<?php if ( $list_sevs->found_posts == 1 ): ?>
					<span>
						<?php echo sprintf( esc_html__( '%s Result Found', 'ova-sev' ), esc_html( $list_sevs->found_posts ) ); ?>
					</span>
					<?php else: ?>
					<span>
						<?php echo sprintf( esc_html__( '%s Results Found', 'ova-sev' ), esc_html( $list_sevs->found_posts ) ); ?>
					</span>
					<?php endif; ?>

					<?php if ( 1 == ceil( $list_sevs->found_posts/ $list_sevs->query_vars['posts_per_page']) && $list_sevs->have_posts() ): ?>
						<span>
							<?php echo sprintf( esc_html__( '(Showing 1-%s)', 'ova-sev' ), esc_html( $list_sevs->found_posts ) ); ?>
						</span>
					<?php elseif ( !$list_sevs->have_posts() ): ?>
						<span></span>
					<?php else: ?>
						<span>
							<?php echo sprintf( esc_html__( '(Showing 1-%s)', 'ova-sev' ), esc_html( $list_sevs->query_vars['posts_per_page'] ) ); ?>
						</span>
					<?php endif; ?>
				</div>
			<?php endif; ?>

			<?php if ( $show_sort_by == 'yes' ): ?>
				<div id="search_sort">
					<select name="sort">
						<option value=""><?php esc_html_e( 'Sort By', 'ova-sev' ); ?></option>
						<option value="date-desc" <?php if( $search_sort_default == 'date-desc' ) echo 'selected'; ?>>
							<?php esc_html_e( 'Newest First', 'ova-sev' ); ?>
						</option>
						<option value="date-asc" <?php if( $search_sort_default == 'date-asc' ) echo 'selected'; ?>>
							<?php esc_html_e( 'Oldest First', 'ova-sev' ); ?>
						</option>
						<option value="a-z" <?php if( $search_sort_default == 'a-z' ) echo 'selected'; ?>>
							<?php esc_html_e( 'A-Z', 'ova-sev' ); ?>
						</option>
						<option value="z-a" <?php if( $search_sort_default == 'z-a' ) echo 'selected'; ?>>
							<?php esc_html_e( 'Z-A', 'ova-sev' ); ?>
						</option>
						<option value="sort-order-desc" <?php if( $search_sort_default == 'sort-order-desc' ) echo 'selected'; ?>>
							<?php esc_html_e( 'Sort Order Desc', 'ova-sev' ); ?>
						</option>
						<option value="sort-order-asc" <?php if( $search_sort_default == 'sort-order-asc' ) echo 'selected'; ?>>
							<?php esc_html_e( 'Sort Order Asc', 'ova-sev' ); ?>
						</option>
						<option value="rand" <?php if( $search_sort_default == 'rand' ) echo 'selected'; ?>>
							<?php esc_html_e( 'Random', 'ova-sev' ); ?>
						</option>
					</select>
				</div>
			<?php endif; ?>
		</div>

		<?php if ( $list_sevs->have_posts() ) : ?>
			<div class="wrapper">
				<?php while ( $list_sevs->have_posts() ) : $list_sevs->the_post();
					ovasev_get_template( 'parts/item-service.php', $args_show );
				endwhile; ?>
			</div>

			<?php else: ?>
			<p><?php esc_attr_e( 'Not found !', 'ova-sev' ); ?></p>
		<?php endif; wp_reset_postdata();
			$total_pages 	= $list_sevs->max_num_pages;
			$curent_page 	= 1;
			ob_start();
			ova_sev_pagination_ajax($total_pages,$curent_page,$posts_per_page,$args_query,$search_sort_default);
			echo ob_get_clean();
		?>
	</div>

</div>