(function($){
	"use strict";

	function gimont_menu(){

		var $btn = $('.main-navigation .menu-toggle'),
		$menu = $('.main-navigation');
		$btn.on('click', function () {
			$menu.toggleClass('toggled');
		});

		if ($menu.length > 0) {
			$menu.find('.menu-item-has-children > a, .page_item_has_children > a').each((index, element) => {
				var $dropdown = $('<button class="dropdown-toggle" aria-label="dropdown toggle"></button>');
				$dropdown.insertAfter(element);

			});
			$(document).on('click', '.main-navigation .dropdown-toggle', function (e) {
				e.preventDefault();
				$(e.target).toggleClass('toggled-on');
				$(e.target).siblings('ul').stop().toggleClass('show');
			});
		}

		var menuItems = $('.main-navigation .menu > li');
		var subMenuItems = $('.main-navigation .menu > li li');
		var menuItemsHasChild = $('.main-navigation .menu .menu-item-has-children');
		menuItemsHasChild.attr('aria-expanded','false');
		var menuMegaItems = $('.ova-mega-menu li a');
		$('.main-navigation').prepend('<div id="ova-bebore-nav" aria-hidden="true"></div>');
		$('.main-navigation').append('<div id="ova-after-nav" aria-hidden="true"></div>');
		var beforeMenu = $('#ova-bebore-nav');
		var afterMenu = $('#ova-after-nav');
		var keys = {
			tab:    9,
			enter:  13,
			esc:    27,
			space:  32,
			left:   37,
			up:     38,
			right:  39,
			down:   40
		};

		var currentIndex, subIndex, megaIndex;

		var gotoIndex = function(idx) {
			if (idx == menuItems.length) {
				afterMenu.attr('tabindex',-1);
				afterMenu.focus();
				return;
			} else if (idx < 0) {
				beforeMenu.attr('tabindex',-1);
				beforeMenu.focus();
				return;
			}
			menuItems[idx].focus();
			currentIndex = idx;
		};

		var gotoSubIndex = function (menu, idx) {
			var items = menu.children('li');
			if (items.length == idx) {
				idx = 0;
			} else if (idx < 0) {
				idx = items.length - 1;
			}
			items[idx].focus();
			subIndex = idx;
		}

		var gotoMegaIndex = function (menu, idx) {
			var items = menu.find('li a');
			if (items.length == idx) {
				idx = 0;
			} else if (idx < 0) {
				idx = items.length - 1;
			}
			items[idx].focus();
			megaIndex = idx;
		}

		menuItems.each(function(i,el){
			if (i == 0) {
				$(el).attr('tabindex', 0);
				$(el).on('focus',function(e){
					currentIndex = 0;
				});
			} else {
				$(el).attr('tabindex', -1);
			}

			$(el).on('focus',function(e){
				$(el).attr('tabindex', -1);
				menuItemsHasChild.attr('aria-expanded','false');
				menuItems.each(function(i,el){
					$(el).removeClass('focus');
				});
				var hasChild = $(this).hasClass('menu-item-has-children');
				if (hasChild) {
					$(this).addClass('focus');
				}
			});

			$(el).on('keydown',function(e){
				var prevdef = false;
				switch (e.keyCode) {
				case keys.right:
					gotoIndex(currentIndex + 1);
					prevdef = true;
					break;
				case keys.left:
					gotoIndex(currentIndex - 1);
					prevdef = true;
					break;
				case keys.tab:
					if (e.shiftKey) {
						gotoIndex(currentIndex - 1);
					} else {
						gotoIndex(currentIndex + 1);
					}
					prevdef = true;
					break;
				case keys.enter:
					window.location.href = $(this).find('a').attr('href');
					break;
				case keys.space:
					window.location.href = $(this).find('a').attr('href');
					break;
				case keys.down:
					var hasChild = $(this).hasClass('menu-item-has-children');
					if (hasChild) {
						$(this).addClass('focus');
						$(this).attr('aria-expanded', "true");
					}
					subIndex = 0;
					if ( $(this).find('ul').length ) {
						gotoSubIndex($(this).find('ul'), 0);
					}
					prevdef = true;
					break;
				case keys.up:
					var subMenu = $(this).find('ul');
					if ( subMenu.length ) {
						subIndex = subMenu.find('li').length - 1;
						gotoSubIndex(subMenu, subIndex);
					}
					prevdef = true;
					break;
				case keys.esc:
					beforeMenu.attr('tabindex',-1);
					beforeMenu.focus();
					prevdef = true;
					break;
				}
				if (prevdef) {
					e.preventDefault();
				}
			});
		});

		subMenuItems.each(function(i,el){
			$(el).attr('tabindex', -1);
			$(el).on('keydown',function(e){
				var prevdef = false;
				switch (e.keyCode) {
				case keys.tab:
					if (e.shiftKey) {
						gotoIndex(currentIndex - 1);
					} else {
						gotoIndex(currentIndex + 1);
					}
					prevdef = true;
					break;
				case keys.right:
					var hasChild = $(this).hasClass('menu-item-has-children');
					if (hasChild) {
						$(this).addClass('focus');
						$(this).attr('aria-expanded', "true");
						subIndex = 0;
						if ( $(this).find('ul').length ) {
							gotoSubIndex($(this).find('ul'), 0);
						}
					} else {
						gotoIndex(currentIndex + 1);
					}
					prevdef = true;
					break;
				case keys.left:
					var parent = $(this).parent().parent('li');
					if (parent) {
						parent.removeClass('focus');
						parent.attr('aria-expanded', "false");
						parent.focus();
					} else {
						gotoIndex(currentIndex - 1);
					}
					prevdef = true;
					break;
				case keys.enter:
					window.location.href = $(this).find('a').attr('href');
					break;
				case keys.space:
					window.location.href = $(this).find('a').attr('href');
					break;
				case keys.esc:
					gotoIndex(currentIndex);
					prevdef = true;
					break;
				case keys.up:
					gotoSubIndex($(this).parent('ul'), subIndex - 1);
					prevdef = true;
					break;
				case keys.down:
					if ($(this).parent('.ova-mega-menu').length) {
						gotoMegaIndex($(this).parent('.ova-mega-menu'),0);
					} else {
						gotoSubIndex($(this).parent('ul'), subIndex + 1);
					}
					prevdef = true;
					break;
				}
				if (prevdef) {
					e.preventDefault();
					e.stopPropagation();
				}
				return false;
			});
		});


		menuMegaItems.each(function(i,el){
			$(el).attr('tabindex', -1);
			$(el).on('keydown',function(e){
				var prevdef = false;
				switch (e.keyCode) {
					case keys.down:
						gotoMegaIndex($(this).parents('.ova-mega-menu'), megaIndex + 1);
						prevdef = true;
						break;
					case keys.up:
						gotoMegaIndex($(this).parents('.ova-mega-menu'), megaIndex - 1);
						prevdef = true;
						break;
					case keys.enter:
						window.location.href = $(this).attr('href');
						break;
					case keys.space:
						window.location.href = $(this).attr('href');
						break;
					case keys.esc:
						gotoIndex(currentIndex);
						prevdef = true;
						break;
					case keys.right:
						gotoIndex(currentIndex + 1);
						prevdef = true;
						break;
					case keys.left:
						gotoIndex(currentIndex - 1);
						prevdef = true;
						break;
					case keys.tab:
						if (e.shiftKey) {
							gotoIndex(currentIndex - 1);
						} else {
							gotoIndex(currentIndex + 1);
						}
						prevdef = true;
						break;
				}
				if (prevdef) {
					e.preventDefault();
					e.stopPropagation();
				}
				return false;
			});
		});
	}


	function gimont_set_menu_direction($item) {
		var sub = $item.children('.sub-menu').filter(':not(.ova-mega-menu)'),
		offset = $item.offset(),
		width = $item.outerWidth(),
		screen_width = $(window).width(),
		sub_width = sub.outerWidth();
		var align_delta = offset.left + width + sub_width - screen_width;
		if (align_delta > 0) {
			if ($item.parents('.menu-item-has-children').length) {
				sub.css({ left: 'auto', right: '100%' });
			}else {
				sub.css({ left: 'auto', right: '0' });
			}
		} else {
			sub.css({ left: '', right: '' });
		}
	}

	function gimont_hover_submenu() {
		$('.primary-navigation .menu-item-has-children').hover(function (event) {
			var $item = $(event.currentTarget);
			gimont_set_menu_direction($item);
		});
	}

	


	/* Click scroll button at bottom */	
	function gimont_scrollUp(options) {

		var defaults = {
			scrollName: 'scrollUp', 
			topDistance: 600, 
			topSpeed: 800, 
			animation: 'fade', 
			animationInSpeed: 200, 
			animationOutSpeed: 200, 
			scrollText: '<i class="ovaicon-up-arrow"></i>', 
			scrollImg: false, 
			activeOverlay: false 
		};

		var o = $.extend({}, defaults, options),
		scrollId = '#' + o.scrollName;


		$('<a/>', {
			id: o.scrollName,
			href: '#top',
			title: ScrollUpText.value
		}).appendTo('body');


		if (!o.scrollImg) {

			$(scrollId).html(o.scrollText);
		}


		$(scrollId).css({'display': 'none', 'position': 'fixed', 'z-index': '2147483647'});


		if (o.activeOverlay) {
			$("body").append("<div id='" + o.scrollName + "-active'></div>");
			$(scrollId + "-active").css({'position': 'absolute', 'top': o.topDistance + 'px', 'width': '100%', 'border-top': '1px dotted ' + o.activeOverlay, 'z-index': '2147483647'});
		}


		$(window).scroll(function () {
			switch (o.animation) {
			case "fade":
				$(($(window).scrollTop() > o.topDistance) ? $(scrollId).fadeIn(o.animationInSpeed) : $(scrollId).fadeOut(o.animationOutSpeed));
				break;
			case "slide":
				$(($(window).scrollTop() > o.topDistance) ? $(scrollId).slideDown(o.animationInSpeed) : $(scrollId).slideUp(o.animationOutSpeed));
				break;
			default:
				$(($(window).scrollTop() > o.topDistance) ? $(scrollId).show(0) : $(scrollId).hide(0));
			}
		});


		$(scrollId).on( "click", function (event) {
			$('html, body').animate({scrollTop: 0}, o.topSpeed);
			event.preventDefault();
		});

	}

	
	// Post Format - Gallery
	$('.slide_gallery').each(function(){
		
		var autoplay = $(this).data('autoplay');
		var autoplayTimeout = $(this).data('autoplaytimeout');
		var autoplaySpeed = $(this).data('autoplayspeed');
		var stopOnHover = $(this).data('stoponhover');
		var loop = $(this).data('loop');
		var dots = $(this).data('dots');
		var nav = $(this).data('nav');
		var items = $(this).data('items');
		

		$(this).owlCarousel({
			autoplayTimeout: parseInt( autoplayTimeout ),
			autoplay: autoplay,
			autoplaySpeed: parseInt( autoplaySpeed ),
			stopOnHover : stopOnHover,
			loop:loop,
			dots:dots,
			nav: nav,
			items: parseInt( items ),
		});
	});
	

	if( $('.header_sticky').length ){

		function sticky_menu(menu, sticky) {
			if (typeof sticky === 'undefined' || !jQuery.isNumeric(sticky)) sticky = 0;
			if ($(window).scrollTop() >= sticky) {
				if ($('#just-for-height').length === 0) {

					if( $('.above_menu').length > 0 && $(window).width() > 767 ){
						var menuoutheight = menu.outerHeight() + $('.above_menu').outerHeight(); 
					}else{
						var menuoutheight = menu.outerHeight();	
					}

					menu.after('<div id="just-for-height" style="height:' + menuoutheight + 'px"></div>')
				}
				menu.addClass("active_sticky");
			} else {
				menu.removeClass("active_sticky");
				$('#just-for-height').remove();
			}
		}

		$(document).ready(function () {
			var menu = $(".header_sticky");
			if (menu.length) {
				var sticky = menu.offset().top + 100;
				if( $(".header_sticky").hasClass('mobile_sticky') ){

					sticky_menu(menu, sticky);
					$(window).on('scroll', function () {
						sticky_menu(menu, sticky);
					});    

				}else{
					if ($(window).width() > 767) {
						sticky_menu(menu, sticky);
						$(window).on('scroll', function () {
							sticky_menu(menu, sticky);
						});
					}
				}


			}
		});

	}


	// Check link has Hash (#about) in landing page
	if( $( 'ul.menu' ).length ){

		var url = $( 'ul.menu li a' ).attr('href');
		var hash = url.substring(url.indexOf("#")+1);
		if( hash ){
			$( 'ul.menu li a' ).on( 'click', function(){
				$( 'ul.menu li' ).removeClass( 'current-menu-item' );
				$(this).parent().addClass( 'current-menu-item' );
				$(this).closest( '.menu-canvas' ).toggleClass('toggled');

			});	
		}

	}
	

	// Aria label for give amount input
	if( $( 'input.give-amount-top' ).length ){
		$( 'input.give-amount-top' ).attr( 'aria-label', 'give amount' );
	}
	

	// Mansory Blog
	$('.blog_masonry').each( function() {

		var grid = $(this);
		var run  = grid.masonry({
			itemSelector: '.post-wrap',
			gutter: 0,
			percentPosition: true,
			transitionDuration: 0,
		});

		run.imagesLoaded().progress( function() {
			run.masonry();
		});

	});

	$('.gimont_stretch_column_left').each( function() {
		var that = $(this);
		if ( that.length != null ) {
			gimont_calculate_width( that );
		}
	});

	$('.gimont_stretch_column_right').each( function() {
		var that = $(this);
		if ( that.length != null ) {
			gimont_calculate_width( that );
		}
	});

	/* Calculate width with special class */
	function gimont_calculate_width( directly ){

		if( $(directly).length ){

			var col_offset = $(directly).offset();

			if( directly.hasClass('gimont_stretch_column_left') ){

				var ending_left = col_offset.left;
				var width_left 	= $(directly).outerWidth() + ending_left;
				
				$('.gimont_stretch_column_left .elementor-widget-wrap').css('width', width_left);
				$('.gimont_stretch_column_left .elementor-widget-wrap').css('margin-left', -ending_left);

				if ( $('body').hasClass('rtl') ) {
					$('.gimont_stretch_column_left .elementor-widget-wrap').css('margin-right', -ending_left);
				} else {
					$('.gimont_stretch_column_left .elementor-widget-wrap').css('margin-left', -ending_left);
				}
			}

			if( directly.hasClass('gimont_stretch_column_right') ){

				var ending_right 	= ($(window).width() - (col_offset.left + $(directly).outerWidth()));
				var width_right 	= $(directly).outerWidth() + ending_right;

				directly.find('.elementor-widget-wrap').css('width', width_right);
				directly.find('.elementor-widget-wrap').css('margin-right', -ending_right);
				
				if ( $('body').hasClass('rtl') ) {
					directly.find('.elementor-widget-wrap').css('margin-left', -ending_right);
				} else {
					directly.find('.elementor-widget-wrap').css('margin-right', -ending_right);
				}
			}
		}
	}

	$(window).resize(function () {
		$('.gimont_stretch_column_left').each( function() {
			var that = $(this);
			if ( that.length != null ) {
				gimont_calculate_width( that );
			}
		});

		$('.gimont_stretch_column_right').each( function() {
			var that = $(this);
			if ( that.length != null ) {
				gimont_calculate_width( that );
			}
		});
	});

	/* For Give Donation */

	function gimont_give_gallery(that){
      	var gallery_data = that.data('gallery');
        Fancybox.show(gallery_data, {
        	Image: {
			    Panzoom: {
			      	zoomFriction: 0.7,
			      	maxScale: function () {
			        	return 3;
			      	},
			    },
		  	},
		});
    }

	// Archive Give Gallery
	if( $(".archive_give_donation .media .gallery").length > 0 ){
	 	$(".archive_give_donation .media .gallery").on('click', function(){
        	gimont_give_gallery($(this))
        });
	}

	// Single Give Gallery
	if( $(".ova_single_give_form .entry-summary .media .gallery").length > 0 ){
        $(".ova_single_give_form .entry-summary .media .gallery").on('click', function(){
        	gimont_give_gallery($(this))
        });
	}

	// Give progress
	$('.give-progress .project-percent').appear(function(){

    	var that 	= $(this);
    	var percent = that.data('percent');

    	that.css("width",percent+'%');

    	$({animatedValue: 0}).animate({animatedValue: percent},{
    		duration: 100,
    		step: function(){
    			that.attr('percent', Math.floor(this.animatedValue) + '%');
    		},
    		complete: function(){
    			that.attr('percent', Math.floor(this.animatedValue) + '%');
    		}
    	});

    });
    
    // Tab Single Donation
	function gimont_give_activeTab(obj){
      	$('.ova_single_give_form .tab-Location ul li').removeClass('give_active');
      	$(obj).addClass('give_active');

      	var id = $(obj).find('a').data('href');
      	$('.ova_single_give_form .give_tab-pane').hide();
      	$(id).show();
    }

    $('.ova_single_give_form .give_nav-tabs li').on( 'click', function(){
      	gimont_give_activeTab(this);
      	return false;
    });

    gimont_give_activeTab( $('.ova_single_give_form .give_nav-tabs li:first-child' ) );

    // Single Donate button
    function gimont_custom_give(){

		if( $('.ova_info_donation').length ){
			var btn_text = $('.ova_info_donation').data('donate_now_btn');

			var new_btn = $('<div class="custom_give">'+btn_text+'</div>');

			$(".give-display-onpage .give-list-inline").append(new_btn);

			$(".custom_give").click(function(){
				$("#give-payment-mode-select").show('slow');
				$("#give_purchase_form_wrap").show('slow');
				$(".custom_give").hide('fast');
				$(".give-display-onpage").css('margin-bottom','75px');
			});
		}

	}
    
    gimont_custom_give();

	gimont_hover_submenu();
	gimont_menu();
	
	/* Scroll to top */
	gimont_scrollUp();

})(jQuery);