<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class Gimont_Elementor_Gallery extends Widget_Base {

	
	public function get_name() {
		return 'gimont_elementor_gallery';
	}

	
	public function get_title() {
		return esc_html__( 'Ova Gallery', 'gimont' );
	}

	
	public function get_icon() {
		return 'eicon-gallery-grid';
	}

	
	public function get_categories() {
		return [ 'gimont' ];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'gimont-elementor-gallery', GIMONT_URI.'/assets/scss/elementor/galleries/gallery.css' );
		return [];
	}

	// Add Your Controll In This Function
	protected function register_controls() {

		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Content', 'gimont' ),
			]
		);	

			$this->add_control(
				'number_column',
				[
					'label' => esc_html__( 'Layout', 'gimont' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'three_column',
					'options' => [
						'two_column' => esc_html__( '2 Columns', 'gimont' ),
						'three_column' => esc_html__( '3 Columns', 'gimont' ),
						'four_column'  => esc_html__( '4 Columns', 'gimont' ),
					],
				]
			);

			$repeater = new \Elementor\Repeater();

			$repeater->add_control(
				'link',
				[
					'label' => esc_html__( 'Link', 'gimont' ),
					'type' => Controls_Manager::URL,
					'dynamic' => [
						'active' => true,
					],
					'placeholder' => esc_html__( 'https://your-link.com', 'gimont' ),
					'show_label' => true,
					'default' => [
						'url' => '#',
					],
				]
			);

			$repeater->add_control(
				'image',
				[
					'label'   => esc_html__( 'Choose Image', 'gimont' ),
					'type'    => Controls_Manager::MEDIA,
					'default' => [
						'url' => Utils::get_placeholder_image_src(),
					],
				]
			);

			$repeater->add_control(
				'title',
				[
					'label' => esc_html__( 'Title', 'gimont' ),
					'type' => Controls_Manager::TEXT,
					'default' => esc_html__( 'Children Park', 'gimont' ),
				]
			);

			$repeater->add_control(
				'category',
				[
					'label' => esc_html__( 'Category/Text', 'gimont' ),
					'type' => Controls_Manager::TEXTAREA,
					'default' => esc_html__( 'Favorite place', 'gimont' ),
				]
			);

			$this->add_control(
				'tab_item',
				[
					'label'		=> esc_html__( 'Tabs', 'gimont' ),
					'type'		=> Controls_Manager::REPEATER,
					'fields'  	=> $repeater->get_controls(),
					'default' 	=> [
						[
							'title' => esc_html__('Agricultures & Food', 'gimont'),
						],
						[
							'title' => esc_html__('Roads & Transport', 'gimont'),
						],
						[
							'title' => esc_html__('Entertainment', 'gimont'),
						],
						[
							'title' => esc_html__('Parks Nature & Wildlife', 'gimont'),
						],
						[
							'title' => esc_html__('Health & Securities', 'gimont'),
						],
						[
							'title' => esc_html__('Laws & Justice', 'gimont'),
						],
					],
				]
			);

		$this->end_controls_section();
        
        $this->start_controls_section(
			'section_gallery',
			[
				'label' => esc_html__( 'Image', 'gimont' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
            
            $this->add_responsive_control(
				'image_border_radius',
				[
					'label'      => esc_html__( 'Border Radius', 'gimont' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .ova-gallery .gallery-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'image_height',
				[
					'label' 	=> esc_html__( 'Height', 'gimont' ),
					'type' 		=> Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => 380,
							'max' => 600,
						],
					],
					'size_units' 	=> [ 'px', '%' ],
					'selectors' 	=> [
						'{{WRAPPER}} .ova-gallery .gallery-content img' => 'height: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_control(
				'image_overlay_color',
				[
					'label'     => esc_html__( 'Overlay Color', 'gimont' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-gallery .gallery-content .overlay' => 'background-color : {{VALUE}};',
					],
				]
			);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Title', 'gimont' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'title_typography',
					'selector' => '{{WRAPPER}} .ova-gallery .gallery-content .info .title',
				]
			);

			$this->add_control(
				'title_color',
				[
					'label'     => esc_html__( 'Color', 'gimont' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-gallery .gallery-content .info .title' => 'color : {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'title_bgcolor',
				[
					'label'     => esc_html__( 'Background Color', 'gimont' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-gallery .gallery-content .info .title' => 'background-color : {{VALUE}};',
					],
				]
			);

			$this->add_responsive_control(
				'title_padding',
				[
					'label'      => esc_html__( 'Padding', 'gimont' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .ova-gallery .gallery-content .info .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_category',
			[
				'label' => esc_html__( 'Category', 'gimont' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'category_typography',
					'selector' => '{{WRAPPER}} .ova-gallery .gallery-content .info .category',
				]
			);

			$this->add_control(
				'category_color',
				[
					'label'     => esc_html__( 'Color', 'gimont' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-gallery .gallery-content .info .category' => 'color : {{VALUE}};',
						'{{WRAPPER}} .ova-gallery .gallery-content .info .category:before, {{WRAPPER}} .ova-gallery .gallery-content .info .category:after' => 'background-color : {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'category_bgcolor',
				[
					'label'     => esc_html__( 'Background Color', 'gimont' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-gallery .gallery-content .info .category' => 'background-color : {{VALUE}};',
					],
				]
			);

			$this->add_responsive_control(
				'category_padding',
				[
					'label'      => esc_html__( 'Padding', 'gimont' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .ova-gallery .gallery-content .info .category' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

		$this->end_controls_section();

		// Icon
		$this->start_controls_section(
			'section_icon_style',
			[
				'label' => esc_html__( 'Icon', 'gimont' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'icon_normal_color',
				[
					'label' 	=> esc_html__( 'Color', 'gimont' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-gallery .gallery-content .view-detail' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'icon_hover_color',
				[
					'label' 	=> esc_html__( 'Color Hover', 'gimont' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-gallery .gallery-content .view-detail:hover' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'icon_normal_bgcolor',
				[
					'label' 	=> esc_html__( 'Background Color', 'gimont' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-gallery .gallery-content .view-detail' => 'background-color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'icon_hover_bgcolor',
				[
					'label' 	=> esc_html__( 'Background Color Hover', 'gimont' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-gallery .gallery-content .view-detail:hover' => 'background-color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();
		
	}

	// Render Template Here
	protected function render() {

		$settings 	= $this->get_settings();

		$tab_item 	= $settings['tab_item'];

		$number_column = $settings['number_column'];

		?>

		 	<div class="ova-gallery">

				<div class="gallery-wrapper <?php echo esc_attr( $number_column ); ?>">
					<?php if(!empty($tab_item)) : foreach ($tab_item as $items) : 
					
						$title       = $items['title'];
						$category    = $items['category'];

						// replace % to %% avoid printf error
						if(strpos($category, '%') !== false){
						    $category = str_replace('%', '%%', $category);
						}

						$img_url 	 = $items['image']['url'];
						$img_alt 	 = isset( $items['image']['alt'] ) ? $items['image']['alt'] : $title;

						$link        = $items['link'];
						$nofollow    = ( isset( $link['nofollow'] ) && $link['nofollow'] ) ? ' rel="nofollow"' : '';
						$target      = ( isset( $link['is_external'] ) && $link['is_external'] !== '' ) ? ' target="_blank"' : '';

					?>

						<div class="gallery-content">

							<div class="gallery-img">
								<img src="<?php echo esc_url( $img_url ); ?>" alt="<?php echo esc_attr( $img_alt ); ?>">
							</div>

							<div class="overlay" data-fancybox="accommodation-gallery-slide" data-src="<?php echo esc_url( $img_url ); ?>"
							data-caption="<?php echo esc_attr( $title ); ?>"></div>
                            
                            <div class="info-wrapper">

                            	<?php if ( !empty($link['url'])) : ?>	
									<a class="view-detail" href="<?php echo esc_url( $link['url'] ); ?>" aria-label="<?php esc_attr_e('View Detail','gimont'); ?>" <?php echo esc_attr( $target ); ?> <?php echo esc_attr( $nofollow ); ?>>
								    <?php endif; ?>
										<i aria-hidden="true" class="flaticonnew- flaticon-new-right"></i>
									<?php if ( !empty($link['url']) ) : ?>
								    </a>
							    <?php endif; ?>

                            	<div class="info">
                            		
									<?php if ( !empty ($category)) : ?>
										<span class="category">
											<?php printf($category); ?>
										</span>
									<?php endif; ?>
									
									<?php if ( !empty ($title)) : ?>
										<?php if ( !empty($link['url'])) : ?>	
										<a href="<?php echo esc_url( $link['url'] ); ?>" <?php echo esc_attr( $target ); ?> <?php echo esc_attr( $nofollow ); ?>>
									    <?php endif; ?>
										<h3 class="title">
											<?php echo esc_html($title); ?>
										</h3>
										<?php if ( !empty($link['url']) ) : ?>
									    </a>
								        <?php endif; ?>
									<?php endif; ?>

								</div>

                            </div>			

						</div>

					<?php endforeach; endif; ?>

				</div>

			</div>

		<?php
	}

	
}
$widgets_manager->register( new Gimont_Elementor_Gallery() );