<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Gimont_Elementor_Give_Donations_Slide extends Widget_Base {

	public function get_name() {
		return 'gimont_elementor_give_donations_slide';
	}

	public function get_title() {
		return esc_html__( 'Give Donations Slide', 'gimont' );
	}

	public function get_icon() {
		return 'eicon-post-slider';
	}

	public function get_categories() {
		return [ 'gimont' ];
	}

	public function get_script_depends() {
		return [ 'gimont-elementor-give-donations-slide' ];
	}

	protected function register_controls() {

		/***** Layout Section *****/
		$this->start_controls_section(
			'section_layout',
			[
				'label' => esc_html__( 'Layout', 'gimont' ),
			]
		);

		$this->add_control(
			'visibility',
			[
				'label' 	=> esc_html__( 'Visibility', 'gimont' ),
				'type' 		=> Controls_Manager::SELECT,
				'default' 	=> 'public',
				'options' 	=> [
					'public' 	=> esc_html__( 'Public', 'gimont' ),
					'featured' => esc_html__( 'Featured Give Form', 'gimont' ),
				],
			]
		);

		$args = array(
			'taxonomy' => 'give_forms_category',
		  	'orderby' 	=> 'name',
		  	'order' 	=> 'ASC'
		);

		$categories  	= get_categories($args);
		$cate_array 	= array();
		$arrayCateAll 	= array( 'all' => esc_html__( 'All categories', 'gimont' ) );
		
		if ($categories) {
			foreach ( $categories as $cate ) {
				$cate_array[$cate->slug] = $cate->cat_name;
			}
		} else {
			$cate_array[ esc_html__( 'No content Category found', 'gimont' ) ] = 0;
		}

		$this->add_control(
			'category',
			[
				'label' 	=> esc_html__( 'Category', 'gimont' ),
				'type' 		=> Controls_Manager::SELECT,
				'default' 	=> 'all',
				'options' 	=> array_merge($arrayCateAll,$cate_array),
			]
		);


		$this->add_control(
			'number_items',
			[
				'label' => esc_html__( 'Number Items', 'gimont' ),
				'type' => Controls_Manager::NUMBER,
				'default' => 5,
			]
		);

		$this->add_control(
			'order',
			[
				'label' => esc_html__('Order', 'gimont'),
				'type' 	=> Controls_Manager::SELECT,
				'default' => 'desc',
				'options' => [
					'asc' 	=> esc_html__('Ascending', 'gimont'),
					'desc' 	=> esc_html__('Descending', 'gimont'),
				]
			]
		);

		$this->add_control(
			'orderby',
			[
				'label' 	=> esc_html__('Order By', 'gimont'),
				'type' 		=> \Elementor\Controls_Manager::SELECT,
				'default' 	=> 'ID',
				'options' 	=> [
					'ID' 		=> esc_html__('ID', 'gimont'),
					'title' 	=> esc_html__('Title', 'gimont'),
					'date' 		=> esc_html__('Date', 'gimont'),
					'modified' 	=> esc_html__('Modified', 'gimont'),
					'rand' 		=> esc_html__('Rand', 'gimont'),
				]
			]
		);

		$this->add_control(
			'limit_text',
			[
				'label' 	=> esc_html__( 'Description Words Limit', 'gimont' ),
				'type' 		=> Controls_Manager::NUMBER,
				'default' 	=> 12,
			]
		);


		$this->end_controls_section();
		/***** End Layout Section *****/
        

        // SECTION ADDITIONAL OPTIONS
		$this->start_controls_section(
			'section_additional_options',
			[
				'label' => __( 'Additional Options', 'gimont' ),
			]
		);

			$this->add_control(
				'margin_items',
				[
					'label'   => __( 'Margin Right Items', 'gimont' ),
					'type'    => Controls_Manager::NUMBER,
					'default' => 30,
				]
			);

			$this->add_control(
				'item_number',
				[
					'label'       => __( 'Item Number', 'gimont' ),
					'type'        => Controls_Manager::NUMBER,
					'description' => __( 'Number Item', 'gimont' ),
					'default'     => 3,
				]
			);

			$this->add_control(
				'slides_to_scroll',
				[
					'label'       => __( 'Slides to Scroll', 'gimont' ),
					'type'        => Controls_Manager::NUMBER,
					'description' => __( 'Set how many slides are scrolled per swipe.', 'gimont' ),
					'default'     => 1,
				]
			);

			$this->add_control(
				'pause_on_hover',
				[
					'label'   => __( 'Pause on Hover', 'gimont' ),
					'type'    => Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => __( 'Yes', 'gimont' ),
						'no'  => __( 'No', 'gimont' ),
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'infinite',
				[
					'label'   => __( 'Infinite Loop', 'gimont' ),
					'type'    => Controls_Manager::SWITCHER,
					'default' => 'no',
					'options' => [
						'yes' => __( 'Yes', 'gimont' ),
						'no'  => __( 'No', 'gimont' ),
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'autoplay',
				[
					'label'   => __( 'Autoplay', 'gimont' ),
					'type'    => Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => __( 'Yes', 'gimont' ),
						'no'  => __( 'No', 'gimont' ),
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'autoplay_speed',
				[
					'label'     => __( 'Autoplay Speed', 'gimont' ),
					'type'      => Controls_Manager::NUMBER,
					'default'   => 3000,
					'step'      => 500,
					'condition' => [
						'autoplay' => 'yes',
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'smartspeed',
				[
					'label'   => __( 'Smart Speed', 'gimont' ),
					'type'    => Controls_Manager::NUMBER,
					'default' => 500,
				]
			);	

			$this->add_control(
				'center',
				[
					'label'   => __( 'Center', 'gimont' ),
					'type'    => Controls_Manager::SWITCHER,
					'default' => 'no',
					'options' => [
						'yes' => __( 'Yes', 'gimont' ),
						'no'  => __( 'No', 'gimont' ),
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'dot_control',
				[
					'label'   => __( 'Show Dots', 'gimont' ),
					'type'    => Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => __( 'Yes', 'gimont' ),
						'no'  => __( 'No', 'gimont' ),
					],
					'frontend_available' => true,
				]
			);	

		$this->end_controls_section();

		//SECTION TAB STYLE TITLE
		$this->start_controls_section(
			'section_title_style',
			[
				'label' => esc_html__( 'Title', 'gimont' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' 		=> 'content_typography_title',
					'label' 	=> esc_html__( 'Typography', 'gimont' ),
					'selector' 	=> '{{WRAPPER}} .ova_give_detail .detail_body .title',
				]
			);

			$this->add_control(
				'color_title',
				[
					'label' 	=> esc_html__( 'Color', 'gimont' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova_give_detail .detail_body  .title' => 'color : {{VALUE}};',
						'{{WRAPPER}} .ova_give_detail .detail_body  .title a' => 'color : {{VALUE}};',	
					],
				]
			);

			$this->add_control(
				'color_title_hover',
				[
					'label' 	=> esc_html__( 'Color hover', 'gimont' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova_give_detail .detail_body .title a:hover' => 'color : {{VALUE}};'
					],
					
				]
			);

			$this->add_responsive_control(
				'padding_title',
				[
					'label' 	 => esc_html__( 'Padding', 'gimont' ),
					'type' 		 => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .ova_give_detail .detail_body .title ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'margin_title',
				[
					'label' 	 => esc_html__( 'Margin', 'gimont' ),
					'type' 		 => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .ova_give_detail .detail_body .title ' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

		$this->end_controls_section();
		//END SECTION TAB STYLE TITLE


		$this->start_controls_section(
			'section_progress_style',
			[
				'label' => esc_html__( 'Progress', 'gimont' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'color_progress_main',
				[
					'label' => esc_html__( 'Main Color', 'gimont' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .give-progress .project-percent' => 'background-color : {{VALUE}} !important;',
					],
				]
			);

			$this->add_control(
				'color_progress',
				[
					'label' => esc_html__( 'Sub Color', 'gimont' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .give-progress' => 'background-color : {{VALUE}} !important;',
					],
				]
			);

		$this->end_controls_section();

		//SECTION TAB STYLE DOTS
		$this->start_controls_section(
			'section_dots',
			[
				'label' => esc_html__( 'Dots', 'gimont' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'dot_control' => 'yes',
				],
			]
		);

			$this->start_controls_tabs(
				'style_tabs_dots'
			);

				$this->start_controls_tab(
					'style_dots_tab',
					[
						'label' => esc_html__( 'Normal', 'gimont' ),
					]
				);

				$this->add_control(
					'dot_color',
					[
						'label'     => esc_html__( 'Color', 'gimont' ),
						'type'      => Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-give-donations-slide .owl-dots .owl-dot span ' => 'background-color : {{VALUE}};',	
						]	
					]
				);

				$this->add_responsive_control(
					'dot_width',
					[
						'label' 		=> esc_html__( 'Dots Width', 'gimont' ),
						'type' 			=> Controls_Manager::SLIDER,
						'size_units' 	=> [ 'px' ],
						'range' => [
							'px' => [
								'min' 	=> 0,
								'max' 	=> 50,
								'step' 	=> 1,
							]
						],
						'selectors' 	=> [
							'{{WRAPPER}} .ova-give-donations-slide .owl-dots .owl-dot span' => 'width: {{SIZE}}{{UNIT}};',
						],
					]
				);

				$this->add_responsive_control(
					'dot_height',
					[
						'label' 		=> esc_html__( 'Dots Height', 'gimont' ),
						'type' 			=> Controls_Manager::SLIDER,
						'size_units' 	=> [ 'px' ],
						'range' => [
							'px' => [
								'min' 	=> 0,
								'max' 	=> 10,
								'step' 	=> 1,
							]
						],
						'selectors' 	=> [
							'{{WRAPPER}} .ova-give-donations-slide .owl-dots .owl-dot span' => 'height: {{SIZE}}{{UNIT}};',
						],
					]
				);

				$this->add_responsive_control(
					'border_radius_dot',
					array(
						'label'      => esc_html__( 'Border Radius', 'gimont' ),
						'type'       => Controls_Manager::DIMENSIONS,
						'size_units' => array( 'px', '%' ),
						'selectors'  => array(
							'{{WRAPPER}} .ova-give-donations-slide .owl-dots .owl-dot span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						),
					)
				);

			$this->end_controls_tab();

			$this->start_controls_tab(
				'style_dots_active_tab',
				[
					'label' => esc_html__( 'Active', 'gimont' ),
				]
			);

			$this->add_control(
				'dot_color_active',
				[
					'label'     => esc_html__( 'Color Active', 'gimont' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-give-donations-slide .owl-dots .owl-dot.active span' => 'background-color : {{VALUE}};',
						
					],
					
				]
			);

			$this->add_responsive_control(
				'dot_width_active',
				[
					'label' 		=> esc_html__( 'Dots Width Active', 'gimont' ),
					'type' 			=> Controls_Manager::SLIDER,
					'size_units' 	=> [ 'px' ],
					'range' => [
						'px' => [
							'min' 	=> 0,
							'max' 	=> 50,
							'step' 	=> 1,
						]
					],
					'selectors' 	=> [
						'{{WRAPPER}} .ova-give-donations-slide .owl-dots .owl-dot.active span' => 'width: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'dot_height_active',
				[
					'label' 		=> esc_html__( 'Dots Height Active', 'gimont' ),
					'type' 			=> Controls_Manager::SLIDER,
					'size_units' 	=> [ 'px' ],
					'range' => [
						'px' => [
							'min' 	=> 0,
							'max' 	=> 6,
							'step' 	=> 1,
						]
					],
					'selectors' 	=> [
						'{{WRAPPER}} .ova-give-donations-slide .owl-dots .owl-dot.active span' => 'height: {{SIZE}}{{UNIT}};',
					],
				]
			);

		$this->end_controls_tab();

	$this->end_controls_tabs();


	$this->end_controls_section();
	//END SECTION TAB STYLE DOTS

	}
	

	protected function render() {

		$settings = $this->get_settings();
	    
		$category 		= $settings['category'];
		$number_items  	= $settings['number_items'];
		$order  		= $settings['order'];
		$orderby  		= $settings['orderby'];

		$data_options['items']              = $settings['item_number'];
		$data_options['slideBy']            = $settings['slides_to_scroll'];
		$data_options['margin']             = $settings['margin_items'];
		$data_options['autoplayHoverPause'] = $settings['pause_on_hover'] === 'yes' ? true : false;
		$data_options['loop']               = $settings['infinite'] === 'yes' ? true : false;
		$data_options['autoplay']           = $settings['autoplay'] === 'yes' ? true : false;
		$data_options['autoplayTimeout']    = $settings['autoplay_speed'];
		$data_options['smartSpeed']         = $settings['smartspeed'];
		$data_options['dots']               = $settings['dot_control'] === 'yes' ? true : false;
		$data_options['center']             = $settings['center'] === 'yes' ? true : false;
		$data_options['rtl']				= is_rtl() ? true : false;


		if ($settings['visibility'] != 'public') {
			$layout_show_post = array(
				array(
					'key' => 'ova_met_feature_give',
					'value' => 'on',
					'compare' => '=',
				)
			);
		} else {
			$layout_show_post = '';
		};

		$paged   = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;

		if ($category == 'all') {
		    $args_base = array(
				'post_type' 	 => 'give_forms',
				'posts_per_page' => $number_items,
				'orderby'		 => $orderby,
				'order'   		 => $order,
				'meta_query' 	 => $layout_show_post,
			);

		} else {
			$args_base = array(
				'post_type' 	 => 'give_forms',
				'posts_per_page' => $number_items,
				'orderby'		 => $orderby,
				'order'   		 => $order,
				'meta_query' 	 => $layout_show_post,
				'tax_query'      => array(
                    array(
                        'taxonomy' => 'give_forms_category',
                        'field'    => 'slug',
                        'terms'    => $category,
                    )
                ),
			);
		}

		$give_donation = new WP_Query( $args_base );

		if( in_array('give/give.php', apply_filters('active_plugins', get_option('active_plugins') ) ) ) {

		?>
            
            <div class="ova-give-donations-slide">

				<div class="ova-item-give give-slide owl-carousel owl-theme" data-options="<?php echo esc_attr(json_encode($data_options)) ?>">

					 <?php if( $give_donation->have_posts() ) : while ( $give_donation->have_posts() ) : $give_donation->the_post();

						ob_start(); 

						    get_template_part( 'give/template-parts/item-give', null, $settings );

						echo ob_get_clean(); ?>

					<?php endwhile; else: ?>

						<div class="search_not_found">
							<?php esc_html_e( 'Not Found Give Form', 'gimont' ); ?>
						</div>

					<?php endif; wp_reset_postdata(); ?>

				</div>

			</div>

		<?php } else {
			esc_html_e( 'Please active plugins Give Donations', 'gimont' );;
		}
	}
}

$widgets_manager->register( new Gimont_Elementor_Give_Donations_Slide() );