<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Utils;
use Elementor\Group_Control_Border;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Gimont_Elementor_Heading extends Widget_Base {

	public function get_name() {
		return 'gimont_elementor_heading';
	}

	public function get_title() {
		return esc_html__( 'Ova Heading', 'gimont' );
	}

	public function get_icon() {
		return 'eicon-heading';
	}

	public function get_categories() {
		return [ 'gimont' ];
	}

	public function get_script_depends() {
		return [ '' ];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'gimont-elementor-heading', GIMONT_URI.'/assets/scss/elementor/heading/heading.css' );
		return [];
	}
	
	// Add Your Controll In This Function
	protected function register_controls() {

		$this->start_controls_section(
				'section_content',
				[
					'label' => esc_html__( 'Content', 'gimont' ),
				]
			);

			$this->add_control(
				'template',
				[
					'label' => esc_html__( 'Template', 'gimont' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'template_1',
					'options' => [
						'template_1' => esc_html__( 'Template 1', 'gimont' ),
						'template_2' => esc_html__( 'Template 2', 'gimont' ),
					],
				]
			);

			$this->add_control(
				'subtitle',
				[
					'label' => esc_html__( 'Subtitle', 'gimont' ),
					'type' => \Elementor\Controls_Manager::TEXT,
					'default' => esc_html__( 'Subtitle', 'gimont' ),
				]
			);

			$this->add_control(
				'title',
				[
					'label' => esc_html__( 'Title', 'gimont' ),
					'type' => \Elementor\Controls_Manager::TEXTAREA,
					'default' => esc_html__( 'Title', 'gimont' ),
					'placeholder' => esc_html__( 'Type your title here', 'gimont' ),
				]
			);

			$this->add_control(
				'desc',
				[
					'label' => esc_html__( 'Description', 'gimont' ),
					'type' => \Elementor\Controls_Manager::TEXTAREA,
					'placeholder' => esc_html__( 'Type your description here', 'gimont' ),
				]
			);

			$this->add_control(
				'title_link',
				[
					'label' => esc_html__( 'Link', 'gimont' ),
					'type' => \Elementor\Controls_Manager::URL,
					'placeholder' => esc_html__( 'https://your-link.com', 'gimont' ),
					'options' => [ 'url', 'is_external', 'nofollow' ],
					'default' => [
						'url' => '',
						'is_external' => true,
						'nofollow' => false,
					],
					'label_block' => true,
				]
			);

			$this->add_control(
				'html_tag',
				[
					'label' => esc_html__( 'HTML Tag', 'gimont' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'h2',
					'options' => [
						'h1' => 'H1',
						'h2' => 'H2',
						'h3' => 'H3',
						'h4' => 'H4',
						'h5' => 'H5',
						'h6' => 'H6',
					],
				]
			);

			$this->add_responsive_control(
				'heading_align',
				[
					'label' => esc_html__( 'Alignment', 'gimont' ),
					'type' => \Elementor\Controls_Manager::CHOOSE,
					'options' => [
						'left' => [
							'title' => esc_html__( 'Left', 'gimont' ),
							'icon' => 'eicon-text-align-left',
						],
						'center' => [
							'title' => esc_html__( 'Center', 'gimont' ),
							'icon' => 'eicon-text-align-center',
						],
						'right' => [
							'title' => esc_html__( 'Right', 'gimont' ),
							'icon' => 'eicon-text-align-right',
						],
					],
					'default' => 'center',
					'toggle' => true,
					'selectors' => [
						'{{WRAPPER}} .ova-heading' => 'text-align: {{VALUE}};',
					],
				]
			);

		$this->end_controls_section();

		/* Line */
		$this->start_controls_section(
				'line_style_section',
				[
					'label' => esc_html__( 'Line', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'line_margin',
				[
					'label' => esc_html__( 'Margin', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-heading .line' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'line_width',
				[
					'label' => esc_html__( 'Width', 'gimont' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 200,
							'step' => 5,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .ova-heading .line' => 'width: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'line_height',
				[
					'label' => esc_html__( 'Height', 'gimont' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 20,
							'step' => 5,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .ova-heading .line' => 'height: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_control(
				'line_color',
				[
					'label' => esc_html__( 'Color', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-heading .line' => 'background: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		/* Subtitle */
		$this->start_controls_section(
				'subtitle_style_section',
				[
					'label' => esc_html__( 'Subtitle', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
                'subtitle_display',
                [
                    'label' => esc_html__( 'Display', 'gimont' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'inline-block' => [
                            'title' => esc_html__( 'Inline Block', 'gimont' ),
                            'icon' => 'eicon-h-align-stretch',
                        ],
                        'block' => [
                            'title' => esc_html__( 'Block', 'gimont' ),
                            'icon' => 'eicon-v-align-middle',
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .ova-heading .subtitle' => 'display: {{VALUE}};',
                    ],
                ]
            );

			$this->add_responsive_control(
				'subtitle_margin',
				[
					'label' => esc_html__( 'Margin', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-heading .subtitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'subtitle_typography',
					'selector' => '{{WRAPPER}} .ova-heading .subtitle',
				]
			);

			$this->add_control(
				'subtitle_color',
				[
					'label' => esc_html__( 'Color', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-heading .subtitle' => 'color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		/* Title */
		$this->start_controls_section(
				'title_style_section',
				[
					'label' => esc_html__( 'Title', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'title_margin',
				[
					'label' => esc_html__( 'Margin', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-heading .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'title_typography',
					'selector' => '{{WRAPPER}} .ova-heading .title',
				]
			);

			$this->add_control(
				'title_color',
				[
					'label' => esc_html__( 'Color', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-heading .title' => 'color: {{VALUE}}',
						'{{WRAPPER}} .ova-heading .title a' => 'color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		/* Description */
		$this->start_controls_section(
				'desc_style_section',
				[
					'label' => esc_html__( 'Description', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'desc_margin',
				[
					'label' => esc_html__( 'Margin', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-heading .desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'desc_typography',
					'selector' => '{{WRAPPER}} .ova-heading .desc',
				]
			);

			$this->add_control(
				'desc_color',
				[
					'label' => esc_html__( 'Color', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-heading .desc' => 'color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();
	}

	// Render Template Here
	protected function render() {
		$settings 		= $this->get_settings();

		$template 		= $settings['template'];

		$subtitle 		= $settings['subtitle'];
		$title_link 	= $settings['title_link'];
		$title 			= $settings['title'];
		$desc 			= $settings['desc'];
		$html_tag 		= $settings['html_tag'];
		
		$target 		= '';
		$nofollow 		= '';
		if ( $title_link && $title_link['url'] ) {
			$target 	= $title_link['is_external'] ? 'target="_blank"' : '';
			$nofollow 	= $title_link['nofollow'] ? 'rel="nofollow"' : '';
		}

		?>

			<div class="ova-heading <?php echo esc_attr( $template ); ?>">
				<?php if ( $subtitle ): ?>
					<?php if ( $template == 'template_1' ): ?>
						<span class="line"></span>
					<?php endif; ?>
					<span class="subtitle"><?php echo esc_html( $subtitle ); ?></span>
					<?php if ( $template == 'template_2' ): ?>
						<span class="line"></span>
					<?php endif; ?>
				<?php endif; ?>
				
				<?php if ( $title ): ?>
					<?php if ( $title_link && $title_link['url'] ): ?>
						<<?php echo esc_attr( $html_tag ); ?> class="title"><a href="<?php echo esc_url( $title_link['url'] ); ?>"<?php printf( '%1$s %2$s', $target, $nofollow ); ?>
								title="<?php echo esc_attr( $title ); ?>"><?php echo esc_html( $title ); ?></a>
						</<?php echo esc_attr( $html_tag ); ?>>
					<?php else: ?>
						<<?php echo esc_attr( $html_tag ); ?> class="title"><?php echo esc_html( $title ); ?></<?php echo esc_attr( $html_tag ); ?>>
					<?php endif; ?>
					
				<?php endif; ?>
				
				<?php if ( $desc ): ?>
					<p class="desc"><?php echo esc_html( $desc ); ?></p>
				<?php endif; ?>

			</div>

		<?php
	}

	
}
$widgets_manager->register( new Gimont_Elementor_Heading() );