<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Utils;
use Elementor\Group_Control_Border;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Gimont_Elementor_Icon_List extends Widget_Base {

	public function get_name() {
		return 'gimont_elementor_icon_list';
	}

	public function get_title() {
		return esc_html__( 'Ova Icon List', 'gimont' );
	}

	public function get_icon() {
		return 'eicon-bullet-list';
	}

	public function get_categories() {
		return [ 'gimont' ];
	}

	public function get_script_depends() {
		return [ '' ];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'gimont-elementor-icon-list', GIMONT_URI.'/assets/scss/elementor/icons/icon-list.css' );
		return [];
	}
	
	// Add Your Controll In This Function
	protected function register_controls() {

		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Content', 'gimont' ),
			]
		);	
			
			// Add Class control

			$repeater = new \Elementor\Repeater();

			$repeater->add_control(
				'icon',
				[
					'label' 	=> esc_html__( 'Class Icon', 'gimont' ),
					'type' 		=> Controls_Manager::TEXT,
					'default' 	=> esc_html__( 'fas fa-check', 'gimont' ),
				]
			);

			$repeater->add_control(
				'title',
				[
					'label' 	=> esc_html__( 'Title', 'gimont' ),
					'type' 		=> Controls_Manager::TEXT,
					'default' 	=> esc_html__('Business Guides', 'gimont' ),
				]
			);

            $repeater->add_control(
				'desc',
				[
					'label' 		=> esc_html__( 'Description', 'gimont' ),
					'type' 			=> Controls_Manager::TEXTAREA,
					'default' 		=> esc_html__('Available, but the majority have suffered simply', 'gimont' ),
				]
			);

			$repeater->add_control(
				'active_mode',
				[
					'label' 	=> esc_html__( 'Active', 'gimont' ),
					'type' 		=> Controls_Manager::SWITCHER,
					'label_on' 	=> esc_html__( 'Yes', 'gimont' ),
					'label_off' => esc_html__( 'No', 'gimont' ),
					'default' 	=> 'no',
				]
			);

			$this->add_control(
				'ico_items',
				[
					'label' 	=> esc_html__( 'Items', 'gimont' ),
					'type' 		=> Controls_Manager::REPEATER,
					'fields' 	=> $repeater->get_controls(),
					'default' 	=> [
						[
							'title' 	=> esc_html__( 'Business Guides', 'gimont' ),
							'active_mode' => 'no',
						],
						[
							'title' 	=> esc_html__( 'City Hitghlights', 'gimont' ),
							'active_mode' => 'yes',
						],
						[
							'title' 	=> esc_html__( 'History Of City', 'gimont' ),
							'active_mode' => 'no',
						],
					
					],
					'title_field' => '{{{ title }}}',
				]
			);

			$this->add_control(
				'show_line_before',
				[
					'label' 	=> esc_html__( 'Line Before', 'gimont' ),
					'type' 		=> Controls_Manager::SWITCHER,
					'label_on' 	=> esc_html__( 'Show', 'gimont' ),
					'label_off' => esc_html__( 'Hide', 'gimont' ),
					'default' 	=> 'yes',
				]
			);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_icon_style',
			[
				'label' => esc_html__( 'Icon', 'gimont' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'color_icon',
				[
					'label' => esc_html__( 'Color', 'gimont' ),
					'type' 	=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-icon-list .item i' => 'color : {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'bg_color_icon',
				[
					'label' 	=> esc_html__( 'Background Color', 'gimont' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-icon-list .item i' => 'background-color : {{VALUE}};',
						'{{WRAPPER}} .ova-icon-list .item:before' => 'border-left-color : {{VALUE}};',
					],
				]
			);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_title_style',
			[
				'label' => esc_html__( 'Title', 'gimont' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'title_typography',
					'selector' 	=> '{{WRAPPER}} .ova-icon-list .item .title',
				]
			);

			$this->add_control(
				'color_title',
				[
					'label' 	=> esc_html__( 'Color', 'gimont' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-icon-list .item .title' => 'color : {{VALUE}};',
					],
				]
			);

			$this->add_responsive_control(
				'padding_title',
				[
					'label' 		=> esc_html__( 'Padding', 'gimont' ),
					'type' 			=> Controls_Manager::DIMENSIONS,
					'size_units' 	=> [ 'px', 'em', '%' ],
					'selectors' 	=> [
						'{{WRAPPER}} .ova-icon-list .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'margin_title',
				[
					'label' 		=> esc_html__( 'Margin', 'gimont' ),
					'type' 			=> Controls_Manager::DIMENSIONS,
					'size_units' 	=> [ 'px', 'em', '%' ],
					'selectors' 	=> [
						'{{WRAPPER}} .ova-icon-list .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

        $this->end_controls_section();

		$this->start_controls_section(
			'section_desc_style',
			[
				'label' => esc_html__( 'Description', 'gimont' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'desc_typography',
					'selector' 	=> '{{WRAPPER}} .ova-icon-list .item .desc',
				]
			);

			$this->add_control(
				'color_desc',
				[
					'label' 	=> esc_html__( 'Color', 'gimont' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-icon-list .item .desc' => 'color : {{VALUE}};',
					],
				]
			);

        $this->end_controls_section();
	}

	// Render Template Here
	protected function render() {
		$settings = $this->get_settings();

        $items 				= $settings['ico_items'];
		$show_line_before 	= $settings['show_line_before'];

		?>

			 <div class="ova-icon-list">
				<?php if( !empty( $items ) ) : ?>
					<?php foreach( $items as $item ): ?>
						<div class="item <?php if ('yes' == $show_line_before) echo 'item-line'; ?> <?php if ('yes' == $item['active_mode']) echo 'active'; ?>">
							<?php if(!empty($item['icon']) ) { ?>
								<i class="<?php echo esc_html( $item['icon'] ); ?>"></i>
							<?php } ?>
							<div class="info">
								<h3 class="title">
									<?php echo esc_html( $item['title'] );?>
								</h3>
								<?php if(!empty($item['desc'])) { ?>
									<p class="desc">
										<?php echo esc_html( $item['desc'] );?>
									</p>
								<?php } ?>
							</div>
						</div>
					<?php endforeach; 
				endif; ?>
			</div>

		<?php
	}

	
}
$widgets_manager->register( new Gimont_Elementor_Icon_List() );