<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Utils;
use Elementor\Group_Control_Border;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Gimont_Elementor_Item_List extends Widget_Base {

	public function get_name() {
		return 'gimont_elementor_item_list';
	}

	public function get_title() {
		return esc_html__( 'Item List', 'gimont' );
	}

	public function get_icon() {
		return 'eicon-editor-list-ul';
	}

	public function get_categories() {
		return [ 'gimont' ];
	}

	public function get_script_depends() {
		return [ '' ];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'gimont-elementor-item-list', GIMONT_URI.'/assets/scss/elementor/boxes/item-list.css' );
		return [];
	}
	
	// Add Your Controll In This Function
	protected function register_controls() {

		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Content', 'gimont' ),
			]
		);	
			
			// Add Class control
			$this->add_control(
				'main_icon',
				[
					'label' => esc_html__( 'Icon', 'gimont' ),
					'type' => \Elementor\Controls_Manager::ICONS,
				]
			);

			$this->add_control(
				'title_category',
				[
					'label' 	=> esc_html__( 'Title', 'gimont' ),
					'type' 		=> Controls_Manager::TEXT,
					'default' 	=> esc_html__('Agriculture & Food', 'gimont' ),
				]
			);

			$repeater = new \Elementor\Repeater();

			$repeater->add_control(
				'link',
				[
					'label' => esc_html__( 'Link', 'gimont' ),
					'type' => \Elementor\Controls_Manager::URL,
					'placeholder' => esc_html__( 'https://your-link.com', 'gimont' ),
					'options' => [ 'url', 'is_external', 'nofollow' ],
					'default' => [
						'url' => '#',
						'is_external' => false,
						'nofollow' => false,
					],
					'label_block' => true,
				]
			);

			$repeater->add_control(
				'icon',
				[
					'label' 	=> esc_html__( 'Class Icon', 'gimont' ),
					'type' 		=> Controls_Manager::TEXT,
					'default' 	=> esc_html__( 'fas fa-angle-double-right', 'gimont' ),
				]
			);

			$repeater->add_control(
				'title',
				[
					'label' 	=> esc_html__( 'Title', 'gimont' ),
					'type' 		=> Controls_Manager::TEXT,
					'default' 	=> esc_html__('Farming Sector', 'gimont' ),
				]
			);

			$this->add_control(
				'items',
				[
					'label' 	=> esc_html__( 'Items', 'gimont' ),
					'type' 		=> Controls_Manager::REPEATER,
					'fields' 	=> $repeater->get_controls(),
					'default' 	=> [
						[
							'title' 	=> esc_html__( 'Farming Sector', 'gimont' ),
						],
						[
							'title' 	=> esc_html__( 'Agri Industry Development', 'gimont' ),
						],
						[
							'title' 	=> esc_html__( 'Forestry', 'gimont' ),
						],
						[
							'title' 	=> esc_html__( 'Rural Environment', 'gimont' ),
						],
						[
							'title' 	=> esc_html__( 'Food Safety', 'gimont' ),
						],
					],
					'title_field' => '{{{ title }}}',
				]
			);

		$this->end_controls_section();

		/* General */
		$this->start_controls_section(
				'sev_style_section',
				[
					'label' => esc_html__( 'General', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_control(
	            'general_alignment',
	            [
	                'label' 	=> esc_html__( 'Alignment', 'gimont' ),
	                'type' 		=> \Elementor\Controls_Manager::CHOOSE,
	                'options' 	=> [
	                    'left' 	=> [
	                        'title' => esc_html__( 'Left', 'gimont' ),
	                        'icon' 	=> 'eicon-text-align-left',
	                    ],
	                    'center' 	=> [
	                        'title' => esc_html__( 'Center', 'gimont' ),
	                        'icon' 	=> 'eicon-text-align-center',
	                    ],
	                    'right' 	=> [
	                        'title' => esc_html__( 'Right', 'gimont' ),
	                        'icon' 	=> 'eicon-text-align-right',
	                    ],
	                ],
	                'selectors' => [
	                    '{{WRAPPER}} .ova-item-list' => 'text-align: {{VALUE}}',
	                ],
	            ]
	        );

			$this->add_responsive_control(
				'sev_padding',
				[
					'label' => esc_html__( 'Padding', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-item-list' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'sev_border_radius',
				[
					'label' => esc_html__( 'Border Radius', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-item-list' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_control(
				'sev_bg',
				[
					'label' => esc_html__( 'Background', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-item-list' => 'background: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		/* Icon */
		$this->start_controls_section(
			'section_icon_style',
			[
				'label' => esc_html__( 'Icon', 'gimont' ),
				'tab' 	=> \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'color_icon',
				[
					'label' => esc_html__( 'Color', 'gimont' ),
					'type' 	=> \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-item-list .main-icon i' => 'color : {{VALUE}};',
						'{{WRAPPER}} .ova-item-list .main-icon svg' => 'fill : {{VALUE}};',
						'{{WRAPPER}} .ova-item-list .main-icon svg path' => 'fill : {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'bg_color_icon',
				[
					'label' 	=> esc_html__( 'Background Color', 'gimont' ),
					'type' 		=> \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-item-list .main-icon' => 'background-color : {{VALUE}};',
					],
				]
			);

		$this->end_controls_section();

		/* Category Title */
		$this->start_controls_section(
				'title_style_section',
				[
					'label' => esc_html__( 'Category Title', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'title_margin',
				[
					'label' => esc_html__( 'Margin', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-item-list .title-category' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'title_typography',
					'selector' => '{{WRAPPER}} .ova-item-list .title-category',
				]
			);

			$this->add_control(
				'title_color',
				[
					'label' => esc_html__( 'Color', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-item-list .title-category' => 'color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		/* Item */
		$this->start_controls_section(
				'item_style_section',
				[
					'label' => esc_html__( 'Item', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'item_padding',
				[
					'label' => esc_html__( 'Padding', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-item-list .item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'item_margin',
				[
					'label' => esc_html__( 'Margin', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-item-list .item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->start_controls_tabs(
					'item_style_tabs'
				);

				$this->start_controls_tab(
					'item_style_normal_tab',
					[
						'label' => esc_html__( 'Normal', 'gimont' ),
					]
				);

					$this->add_control(
						'item_color',
						[
							'label' => esc_html__( 'Color', 'gimont' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-item-list .title' => 'color: {{VALUE}}',
							],
						]
					);

				$this->end_controls_tab();

				$this->start_controls_tab(
						'item_style_hover_tab',
						[
							'label' => esc_html__( 'Hover', 'gimont' ),
						]
					);

					$this->add_control(
						'item_hover_color',
						[
							'label' => esc_html__( 'Color', 'gimont' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-item-list .title:hover' => 'color: {{VALUE}}',
							],
						]
					);

				$this->end_controls_tab();

			$this->end_controls_tabs();

		$this->end_controls_section();

	}

	// Render Template Here
	protected function render() {
		$settings = $this->get_settings();

		$main_icon = $settings['main_icon'];
		$title     = $settings['title_category'];

        $items 	   = $settings['items'];

		?>

			 <div class="ova-item-list">

			 	<div class="top">

			 		<?php if ( $main_icon['value'] ): ?>
				    	<div class="main-icon">
							<?php \Elementor\Icons_Manager::render_icon( $main_icon, [ 'aria-hidden' => 'true' ] ); ?>
						</div>
					<?php endif;?>

					<?php if($title) { ?>
						<h3 class="title-category"><?php echo esc_html( $title ); ?></h3>
					<?php } ?>

			 	</div>

			 	<div class="wrapper">
			 		  
					<?php if( !empty( $items ) ) : foreach( $items as $item ): 
						$link 		= $item['link'];
						$link_url 	= $link['url'];
						$target 	= '';
						$nofollow 	= '';
						if ( $link && $link_url) {
							$target 	= $link['is_external'] 	? 'target="_blank"' : '';
							$nofollow 	= $link['nofollow'] 	? 'rel="nofollow"' 	: '';
						}
					?>
						
						<?php if(!empty($link_url)) { ?>
							<a class="item" href="<?php echo esc_url( $link_url ); ?>" <?php printf('%1$s %2$s', $target, $nofollow); ?>>
								<?php if(!empty($item['icon']) ) { ?>
									<i class="<?php echo esc_html( $item['icon'] ); ?>"></i>
								<?php } ?>
								<h3 class="title">
									<?php echo esc_html( $item['title'] );?>
								</h3>
							</a>
						<?php } else { ?>
							<div class="item">
								<?php if(!empty($item['icon']) ) { ?>
									<i class="<?php echo esc_html( $item['icon'] ); ?>"></i>
								<?php } ?>
								<h3 class="title">
									<?php echo esc_html( $item['title'] );?>
								</h3>
							</div>
						<?php } ?>
						
					<?php endforeach; endif; ?>

			 	</div>

			</div>

		<?php
	}

	
}
$widgets_manager->register( new Gimont_Elementor_Item_List() );