<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Utils;
use Elementor\Group_Control_Border;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Gimont_Elementor_Ova_Search_All extends Widget_Base {

	public function get_name() {
		return 'gimont_elementor_ova_search_all';
	}

	public function get_title() {
		return esc_html__( 'Search All', 'gimont' );
	}

	public function get_icon() {
		return 'eicon-search';
	}

	public function get_categories() {
		return [ 'gimont' ];
	}

	public function get_script_depends() {
		return [ '' ];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'gimont-elementor-search-all', GIMONT_URI.'/assets/scss/elementor/searchs/ova-search-all.css' );
		return [];
	}
	
	// Add Your Controll In This Function
	protected function register_controls() {

		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Content', 'gimont' ),
			]
		);	
			
			// Add Class control

			$this->add_control(
				'placeholder',
				[
					'label' => esc_html__( 'Placeholder', 'gimont' ),
					'type' => \Elementor\Controls_Manager::TEXT,
					'default' => esc_html__( 'What you needs', 'gimont' ),
				]
			);

			$this->add_control(
				'text_search',
				[
					'label' => esc_html__( 'Text Search Button', 'gimont' ),
					'type' => \Elementor\Controls_Manager::TEXT,
					'default' => esc_html__( 'Search Now', 'gimont' ),
				]
			);

			$this->add_control(
				'button_color',
				[
					'label' => esc_html__( 'Button Color', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova_wrap_search_all button' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'button_bg_color',
				[
					'label' => esc_html__( 'Button Background Color', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova_wrap_search_all button' => 'background-color: {{VALUE}}',
						
					],
				]
			);

			$this->add_control(
				'button_bg_color_hover',
				[
					'label' => esc_html__( 'Button Background Color Hover', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova_wrap_search_all button:hover' => 'background-color: {{VALUE}}',

					],
				]
			);

		$this->end_controls_section();
	}

	// Render Template Here
	protected function render() {
		$settings = $this->get_settings();

		$placeholder = $settings['placeholder'];
		$text_search = $settings['text_search'];

		?>

			<div class="ova_wrap_search_all">

				<form role="search" method="get" class="search-form" action="<?php echo home_url( '/' ); ?>">
					
					<div class="wrap_input">
						<i class="gimonticon gimonticon-search-interface-symbol"></i>
						<input type="text" class="search-field" placeholder="<?php echo esc_attr($placeholder); ?>" value="<?php echo get_search_query() ?>" aria-label="<?php echo esc_attr($placeholder); ?>" name="s"/>
					</div>
			
				    <button class="search-submit second_font" type="submit" title="<?php echo esc_attr($text_search); ?>">
				    	<?php echo esc_attr($text_search); ?>	
				    </button>
		   			 	
				</form>		

			</div>

		<?php
	}

	
}
$widgets_manager->register( new Gimont_Elementor_Ova_Search_All() );