<?php if (!defined( 'ABSPATH' )) exit;

if( !class_exists('Gimont_Hooks') ){
	
	class Gimont_Hooks {

		public function __construct() {
			
			// Return HTML for Header
			add_filter( 'gimont_render_header', array( $this, 'gimont_render_header' ) );

			// Return HTML for Footer
			add_filter( 'gimont_render_footer', array( $this, 'gimont_render_footer' ) );


			/* Get All Header */
			add_filter( 'gimont_list_header', array( $this, 'gimont_list_header' ) );

			/* Get All Footer */
			add_filter( 'gimont_list_footer', array( $this,  'gimont_list_footer' ) );

			/* Define Layout */
			add_filter( 'gimont_define_layout', array( $this,  'gimont_define_layout' ) );

			/* Define Wide */
			add_filter( 'gimont_define_wide_boxed', array( $this,  'gimont_define_wide_boxed' ) );

			/* Get layout */
			add_filter( 'gimont_get_layout', array( $this, 'gimont_get_layout' ) );

			/* Get sidebar */
			add_filter( 'gimont_theme_sidebar', array( $this, 'gimont_theme_sidebar' )  );
			

			/* Wide or Boxed */
			add_filter( 'gimont_wide_site', array( $this, 'gimont_wide_site' ) );

			/* Get Blog Template */
			add_filter( 'gimont_blog_template', array( $this, 'gimont_blog_template' ) );
			
			// Comment Form Default Field
			add_filter( 'comment_form_default_fields', array( $this, 'gimont_comment_form_default_fields') );
			add_filter( 'comment_form_defaults', array( $this, 'gimont_comment_form_defaults' ) );

			/* Search CPT */
			add_action( 'pre_get_posts', array( $this, 'gimont_search_all' ) );
			add_filter( 'template_include', array( $this, 'gimont_search_all_template' ) ); 

			// Change archive title
			add_filter( 'get_the_archive_title', array( $this, 'gimont_archive_title' ) );

			/* Give Donation */
			add_filter( 'template_include', array( $this, 'gimont_give_template_loader' ) );
			add_filter( 'gimont_progress_stats', array( $this, 'gimont_progress_stats' ), 10, 1 );
       		add_filter( 'gimont_count_donor', array( $this, 'gimont_count_donor' ) );
       		add_filter( 'give_forms_supports', array( $this, 'gimont_give_forms_supports' ), 10, 1 );
       		add_action( 'pre_get_posts', array( $this, 'gimont_give_post_per_page_archive' ) );

       		// add_filter show Wysiwyg Editor
			add_filter( 'ova_the_content', 'do_blocks', 9 );
			add_filter( 'ova_the_content', 'wptexturize' );
			add_filter( 'ova_the_content', 'convert_smilies', 20 );
			add_filter( 'ova_the_content', 'wpautop' );
			add_filter( 'ova_the_content', 'shortcode_unautop' );
			add_filter( 'ova_the_content', 'prepend_attachment' );
			add_filter( 'ova_the_content', 'wp_filter_content_tags' );
			add_filter( 'ova_the_content', 'wp_replace_insecure_home_url' );
			add_filter( 'ova_the_content', 'do_shortcode', 11 );
	    }

		
		public function gimont_render_header(){

			$current_id = gimont_get_current_id();

			// Get header default from customizer
			$global_header = get_theme_mod('global_header','default');

			// Header in Metabox of Post, Page
		    $meta_header = get_post_meta($current_id, 'ova_met_header_version', 'true');
		  	
		    // Header use in post,page
		    if( $current_id != '' && $meta_header != 'global'  && $meta_header != '' ){

		    	$header = $meta_header;

		  	}else if( gimont_is_blog_archive() && !gimont_is_woo_archive() ){ // Header use in blog

		  		$header = get_theme_mod('blog_header', 'default');

		  	}else if( gimont_is_woo_archive() ){ // Header use in Product pages

		  		$header = get_theme_mod('woo_archive_header', 'default');

		  	}else if( is_singular('post') ){ // Header use in single post

		  		$header = get_theme_mod('single_header', 'default');

		  	}else if( is_singular('product') ){ // Header use in single product

		  		$header = get_theme_mod('woo_single_header', 'default');

		  	}else if( is_singular('give_forms') ){

		  		$header = get_theme_mod('single_donation_header', 'default'); // Header use in single donation

		  	}else{ // Header use in global

		  		$header = $global_header;
		  	}

		  	if( gimont_is_give_archive() ){

		  		$header = get_theme_mod('archive_donation_header', 'default');

		  	}
			

			$header_split = explode(',', apply_filters( 'gimont_header_customize', $header, $header ));

			if ( gimont_is_elementor_active() && isset( $header_split[1] ) ) {

				$post_id_header = gimont_get_id_by_slug( $header_split[1] );

				// Check WPML 
				if( function_exists( 'icl_object_id' ) ){
					$post_id_header = icl_object_id($post_id_header, 'ova_framework_hf_el', false);

					if ( ! $post_id_header ) {
						$post_id_header = gimont_get_id_by_slug( $header_split[1] );
					}
				}
				
				return Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $post_id_header );

			}else if ( gimont_is_elementor_active() && !isset( $header_split[1] ) ) {

				return get_template_part( 'template-parts/header', $header_split[0] );

			}else if ( !gimont_is_elementor_active()  ) {

				return get_template_part( 'template-parts/header', 'default' );

			}

		}


		
		public function gimont_render_footer(){

			$current_id = gimont_get_current_id();

			// Get Footer default from customizer
			$global_footer = get_theme_mod('global_footer', 'default' );

			// Footer in Metabox of Post, Page
		    $meta_footer =  get_post_meta( $current_id, 'ova_met_footer_version', 'true' );
			

		  	if( $current_id != '' && $meta_footer != 'global'  && $meta_footer != '' ){

		  		$footer = $meta_footer;

		  	}else if( gimont_is_blog_archive() && !gimont_is_woo_archive() ){

		  		$footer = get_theme_mod('blog_footer', 'default');

		  	}else if( gimont_is_woo_archive()  ){ // Footer use in Product pages

		  		$footer = get_theme_mod('woo_archive_footer', 'default');

		  	}else if( is_singular('post') ){

		  		$footer = get_theme_mod('single_footer', 'default');

		  	}else if( is_singular('product') ){ // Footer use in single product

		  		$footer = get_theme_mod('woo_single_footer', 'default');

		  	}else if( is_singular('give_forms') ){

		  		$footer = get_theme_mod('single_donation_footer', 'default'); // Footer use in single donation

		  	}else{

		  		$footer = $global_footer;
		  		
		  	}

		  	if( gimont_is_give_archive() ){

		  		$footer = get_theme_mod('archive_donation_footer', 'default');

		  	}

		  	
		  	$footer_split = explode(',', apply_filters( 'gimont_footer_customize', $footer, $footer ));

			if ( gimont_is_elementor_active() && isset( $footer_split[1] ) ) {

				$post_id_footer = gimont_get_id_by_slug( $footer_split[1] );

				// Check WPML 
				if( function_exists( 'icl_object_id' ) ){
					$post_id_footer = icl_object_id($post_id_footer, 'ova_framework_hf_el', false);

					if ( ! $post_id_footer ) {
						$post_id_footer = gimont_get_id_by_slug( $footer_split[1] );
					}
				}

				return Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $post_id_footer );
				
			}else if ( gimont_is_elementor_active() && !isset( $footer_split[1] ) ) {

				get_template_part( 'template-parts/footer', $footer_split[0] );

			}else if( !gimont_is_elementor_active() ){

				get_template_part( 'template-parts/footer', 'default' );			
			}
		}

		function gimont_list_header(){
		    $hf_header_array['default'] = esc_html__( 'Default', 'gimont' );

		    if ( ! gimont_is_elementor_active() ) return $hf_header_array;

		    $args_hf = array(
		        'post_type' 		=> 'ova_framework_hf_el',
		        'post_status'   	=> 'publish',
		        'posts_per_page' 	=> '-1',
		        'meta_query' 		=> array(
		            array(
		                'key'     	=> 'hf_options',
		                'value'   	=> 'header',
		                'compare' 	=> '=',
		            ),
		        )
		    );

		    $hf = get_posts( $args_hf );

		    foreach ( $hf as $post ) {
		    	setup_postdata( $post );
		    	$hf_header_array[ 'ova,'.$post->post_name ] = get_the_title( $post->ID );
		    }

		    wp_reset_postdata();

		    return $hf_header_array;
		}

		function gimont_list_footer() {
		    $hf_footer_array['default'] = esc_html__( 'Default', 'gimont' );

		    if ( ! gimont_is_elementor_active() ) return $hf_footer_array;

		    $args_hf = array(
		        'post_type' 		=> 'ova_framework_hf_el',
		        'post_status'   	=> 'publish',
		        'posts_per_page' 	=> '-1',
		        'meta_query' 		=> array(
		            array(
		                'key'     	=> 'hf_options',
		                'value'   	=> 'footer',
		                'compare' 	=> '=',
		            ),
		        )
		    );

		    $hf = get_posts( $args_hf );

		    foreach ( $hf as $post ) {
		    	setup_postdata( $post );
		    	$hf_footer_array[ 'ova,'.$post->post_name ] = get_the_title( $post->ID );
		    }

		    wp_reset_postdata();

		    return $hf_footer_array;
		}


		function gimont_define_layout(){
			return array(
				'layout_1c' => esc_html__('No Sidebar', 'gimont'),
				'layout_2r' => esc_html__('Right Sidebar', 'gimont'),
				'layout_2l' => esc_html__('Left Sidebar', 'gimont'),
			);
		}
		

		function gimont_get_layout(){
			
			$layout = '';
			
			$width_sidebar = get_theme_mod( 'global_sidebar_width', '320' );

			if( is_singular( 'post' ) ){

			    $layout = get_theme_mod( 'single_layout', 'layout_2r' );

			}else if( gimont_is_blog_archive() ){

			    $layout = get_theme_mod( 'blog_layout', 'layout_2r' );

			}else if( gimont_is_woo_active() && is_product() ){

				$layout = get_theme_mod( 'woo_product_layout', 'woo_layout_1c' );
				$width_sidebar = get_theme_mod( 'woo_sidebar_width', '320' );

			} else if( gimont_is_woo_active() && ( is_product_category() || is_product_tag() || is_shop() ) ){
				
				$layout = get_theme_mod( 'woo_archive_layout', 'woo_layout_1c' );
				$width_sidebar = get_theme_mod( 'woo_sidebar_width', '320' );

			}


			$current_id = gimont_get_current_id();

			if( $current_id ){

			    $layout_in_post = get_post_meta( $current_id, 'ova_met_main_layout', true );

			    if( $layout_in_post != 'global' && $layout_in_post != '' ){
			    	$layout = $layout_in_post;
			    }

			}

			// Check if page is posts (settings >> reading >> posts page)
			if( get_option( 'page_for_posts' ) == $current_id ){
				
				$layout_in_post = get_post_meta( $current_id, 'ova_met_main_layout', true );

				if( $layout_in_post == 'global' ){
					$layout = get_theme_mod( 'blog_layout', 'layout_2r' );
				}
					

			}


			if( isset( $_GET['layout_sidebar'] ) ){
				$layout = $_GET['layout_sidebar'];
			}

			if( !$layout ){
				$layout = get_theme_mod( 'global_layout', 'layout_2r' );
			    $width_sidebar = get_theme_mod( 'global_sidebar_width', '320' );
			}

			// Check if Woo Sidebar is inactive
			if( gimont_is_woo_active() && ( is_product_category() || is_product_tag() || is_shop() ) ){
				if( !is_active_sidebar('woo-sidebar') ){
					$layout = 'woo_layout_1c';
					$width_sidebar = 0;
				}
			}else if( gimont_is_woo_active() && is_product() ){
				if( !is_active_sidebar('woo-sidebar') ){
					$layout = 'woo_layout_1c';
					$width_sidebar = 0;
				}
			}else if( !is_active_sidebar('main-sidebar') ){
					$layout = 'layout_1c';
					$width_sidebar = 0;
			}
			

			return array( $layout, $width_sidebar );
		}

		


		function gimont_wide_site(){
			$current_id = gimont_get_current_id();
			$width_site = get_post_meta( $current_id, 'ova_met_wide_site', true );

			if( $current_id && $width_site != 'global' ){
			    $width = $width_site;
			}else{
				$width = get_theme_mod( 'global_wide_site', 'wide' );
			}

			return $width;
		}

		function gimont_theme_sidebar(){
			$layout_sidebar = apply_filters( 'gimont_get_layout', '' );
			return $layout_sidebar[0];
		}

		function gimont_define_wide_boxed(){
			return array(
				'wide' => esc_html__('Wide', 'gimont'),
				'boxed' => esc_html__('Boxed', 'gimont'),
			);
		}

		function gimont_blog_template(){
			$blog_template = get_theme_mod( 'blog_template', 'default' );
			if( isset( $_GET['blog_template'] ) ){
				$blog_template = $_GET['blog_template'];
			}
			return $blog_template;
		}

		public function gimont_search_all( $query ) {

			// Blog, Page, Department, Event, Team, Documentation, Career, Portfolio, Service, Directory
			$post_types = array('post','page','event','team','career','give_forms','collection','artist','exhibition','ova_dep','ova_doc','ova_por','ova_sev','ova_dir');

			if ( $query->is_main_query() && $query->is_search() && ! is_admin() ) {
        		$query->set( 'post_type', apply_filters( 'gimont_search_custom_post_type', $post_types ) );
    		}
		}

		function gimont_search_all_template( $template ) {
			global $wp_query;

			if ( $wp_query->is_main_query() && $wp_query->is_search() && ! is_admin() ) {
	        	return locate_template('template-parts/search.php');
	    	} 

		    return $template;
		} 

		function gimont_archive_title( $title ) {
		    if ( is_category() ) {
		        $title = single_cat_title( '', false );
		    } elseif ( is_tag() ) {
		        $title = single_tag_title( '', false );
		    } elseif ( is_author() ) {
		        $title = '<span class="vcard">' . get_the_author() . '</span>';
		    } elseif ( is_post_type_archive() ) {
		        $title = post_type_archive_title( '', false );
		    } elseif ( is_tax() ) {
		        $title = single_term_title( '', false );
		    }
		  
		    return $title;
		}
		

		function gimont_comment_form_defaults( $defaults ){

			$defaults['comment_field'] = sprintf(
											'<p class="comment-form-comment"> %s</p>',
											'<textarea id="comment" name="comment" cols="45" rows="8" maxlength="65525" required="required" placeholder="'.esc_attr__( 'Comment', 'gimont' ).'"></textarea>'
										);

			return $defaults;
		
		}

		function gimont_comment_form_default_fields( $fields ){

			$commenter     = wp_get_current_commenter();

			$req      = get_option( 'require_name_email' );
			$html_req = ( $req ? " required='required'" : '' );
			$html5 = true;


			$fields['author'] = sprintf( '<p class="comment-form-author">%s</p>',
								sprintf(
									'<input id="author" name="author" type="text" value="%s" placeholder="'.esc_attr__( 'Name', 'gimont' ).'" size="30" maxlength="245"%s />',
									esc_attr( $commenter['comment_author'] ),
									$html_req
								) );

			$fields['email'] = sprintf(
								'<p class="comment-form-email"> %s</p>',
								
								sprintf(
									'<input id="email" name="email" %s value="%s" size="30" maxlength="100" placeholder="'.esc_attr__( 'Email', 'gimont' ).'" aria-describedby="email-notes"%s />',
									( $html5 ? 'type="email"' : 'type="text"' ),
									esc_attr( $commenter['comment_author_email'] ),
									$html_req
								)
							);
			$fields['url'] = sprintf(
							'<p class="comment-form-url">%s</p>',
							sprintf(
								'<input id="url" name="url" %s value="%s" size="30" maxlength="200" placeholder="'.esc_attr__( 'Website', 'gimont' ).'" />',
								( $html5 ? 'type="url"' : 'type="text"' ),
								esc_attr( $commenter['comment_author_url'] )
							)
						);

			
			return $fields;
			
		}

		function gimont_give_template_loader( $template ) {

	        $post_type = isset($_REQUEST['post_type'] ) ? $_REQUEST['post_type'] : get_post_type();
	        
	        
			if( is_tax( 'give_forms_category' ) ||  get_query_var( 'give_forms_category' ) != '' ){

			    $paged = get_query_var('paged') ? get_query_var('paged') : '1';
			    
			    query_posts( '&give_forms_category='.get_query_var( 'give_forms_category' ).'&paged=' . $paged );
			    get_template_part( 'archive', 'give_forms' );
			    return false;
			}

			if(  $post_type == 'give_forms' ){

				if (  is_post_type_archive( 'give_forms' )  ) { 

					get_template_part( 'archive', 'give_forms' );
					return false;

				} else if ( is_single() ) {

					get_template_part( 'give/single', 'give-form' );
					return false;

				}
			} else {
				return $template;
			}

	    }

		function gimont_progress_stats( $id = '' ){

			$form = new Give_Donate_Form( $id );

			if (function_exists('give_goal_progress_stats')) {
				$donation_progress_stats = give_goal_progress_stats( $form );
			}

			$goal_format = get_post_meta( $id, '_give_goal_format', true );

			if (function_exists('give_human_format_large_amount') && function_exists('give_format_amount') ) {
				$get_income = give_human_format_large_amount( give_format_amount( $donation_progress_stats['raw_actual'], array() ), array() );
				$get_goal   = give_human_format_large_amount( give_format_amount( $donation_progress_stats['raw_goal'], array() ), array() );
			}

			if (function_exists('give_currency_filter')) {
				$convert_income = give_currency_filter( $get_income, array( 'form_id' => $id ) );
				$conver_goal 	= give_currency_filter( $get_goal, array( 'form_id' => $id ) );
			}

			$result['to_go']    = abs($donation_progress_stats['raw_goal'] - $donation_progress_stats['raw_actual']);

			if ($goal_format == 'amount' || $goal_format == 'percentage') {
				$result['actual'] 	= $convert_income;
				$result['goal'] 	= $conver_goal;
				$result['progress'] = $donation_progress_stats['progress'];
				$result['to_go'] 	= give_currency_filter($result['to_go']);
			} else {
				$result['actual'] 	= $donation_progress_stats['actual'];
				$result['goal'] 	= $donation_progress_stats['goal'];
				$result['progress'] = $donation_progress_stats['progress'];
				$result['to_go'] 	= give_currency_filter($result['to_go']);
			}

			return $result;
		}

    	function gimont_count_donor( $id = '' ){
    		
			$form = new Give_Donate_Form( $id );

			return apply_filters( 'give_goal_donations_raised_output', $form->sales, $id, $form );
		}

		public function gimont_give_forms_supports( $supports ){
			array_push( $supports, 'editor' );
			array_push( $supports, 'comments' );
			return $supports; 
		}

		public function gimont_give_post_per_page_archive( $query ) {
		    if ( ! is_admin() && $query->is_main_query() ) {
		        if ( $query->is_post_type_archive( 'give_forms' ) || $query->is_tax( 'give_forms_category' ) ) {

					$posts_per_page = get_theme_mod( 'archive_donation_posts_per_page', 6 );

		            $query->set('post_type', array( 'give_forms' ) );
		            $query->set('posts_per_page', $posts_per_page );
		        }
		    }
		}


	}
}

new Gimont_Hooks();