<?php  defined( 'ABSPATH' ) || exit();

if( !class_exists( 'OVAEX_Admin_Assets' ) ){
	class OVAEX_Admin_Assets{

		public function __construct(){

			add_action( 'admin_footer', array( $this, 'enqueue_scripts' ), 10, 2 );

		}

		public function enqueue_scripts(){

			global $pagenow, $post_type;

			if ( ( $pagenow === 'post-new.php' || $pagenow === 'post.php' ) && $post_type === 'exhibition'  ) {
				// Datetimepicker
				wp_enqueue_style( 'datetimepicker-style', OVAEX_PLUGIN_URI.'assets/libs/datetimepicker/jquery.datetimepicker.css' );
				wp_enqueue_script( 'datetimepicker-script', OVAEX_PLUGIN_URI.'assets/libs/datetimepicker/jquery.datetimepicker.js', array('jquery'), false, true );

				// Select2
				wp_enqueue_style( 'select2', OVAEX_PLUGIN_URI.'assets/libs/select2/select2.min.css' );
				wp_enqueue_script( 'select2', OVAEX_PLUGIN_URI.'assets/libs/select2/select2.min.js', array('jquery'), null, true );
			}

			if ( $post_type === 'exhibition' || get_current_screen()->base === 'exhibition_page_ovaex_general_settings' ) { 
				// Google Map
				wp_enqueue_script( 'google','https://maps.googleapis.com/maps/api/js?key='.OVAEX_Settings::google_key_map().'&libraries=places', false, true );

				// Jquery UI
				wp_enqueue_style( 'jquery-ui', OVAEX_PLUGIN_URI.'assets/libs/jquery-ui/jquery-ui.min.css' );
				wp_enqueue_script( 'jquery-ui-tabs' );

				wp_enqueue_style( 'ovaex-admin-style', OVAEX_PLUGIN_URI.'assets/css/admin/ovaex-admin-style.css' );
				wp_enqueue_script( 'ovaex-admin-script', OVAEX_PLUGIN_URI.'assets/js/admin/ovaex-admin-script.js', array('jquery'), false, true );
			}
			

		}
	}
	
	new OVAEX_Admin_Assets();
}