<?php

if( !defined( 'ABSPATH' ) ) exit();

global $post;


$ovaex_map_name    = get_post_meta( $post->ID , 'ovaex_map_name', true ) ? get_post_meta( $post->ID ,'ovaex_map_name', true ) : esc_html__('New York', 'ovaex');
$ovaex_map_address = get_post_meta( $post->ID , 'ovaex_map_address', true ) ? get_post_meta( $post->ID ,'ovaex_map_address', true ) : '' ;
$ovaex_map_lat     = get_post_meta( $post->ID , 'ovaex_map_lat', true ) ? get_post_meta( $post->ID ,'ovaex_map_lat', true ) : '';
$ovaex_map_lng     = get_post_meta( $post->ID , 'ovaex_map_lng', true ) ? get_post_meta( $post->ID ,'ovaex_map_lng', true ) : '';

?>
<div class="ovaex_metabox">

	<br>
	<div class="ovaex_row">

		<div class="ovaex_map">
			<label class="label"><strong><?php esc_html_e( 'Map', 'ovaex' ); ?>: </strong></label>
			
			<input id="pac-input" value="<?php echo esc_attr($ovaex_map_address); ?>" class="controls" type="text" placeholder="<?php esc_html_e( 'Enter a venue', 'ovaex' ); ?>" autocomplete="off">

			<div id="ovaex_show_map"></div>

			<div id="infowindow-content">
				<span id="place-name"  class="title"><?php echo esc_attr($ovaex_map_name); ?></span><br>
				<span id="place-address"><?php echo esc_attr($ovaex_map_address); ?></span>
			</div>

			<input type="hidden" value="<?php echo esc_attr($ovaex_map_name); ?>" name="ovaex_map_name" id="ovaex_map_name"  autocomplete="off"/>	

			<label>
				<?php esc_html_e( 'Address: ', 'ovaex' ); ?>
				<input type="text" value="<?php echo esc_attr($ovaex_map_address); ?>" name="ovaex_map_address" id="ovaex_map_address" autocomplete="off"/>
			</label>

			&nbsp;&nbsp;&nbsp;

			<label>
				<?php esc_html_e( 'Latitude: ', 'ovaex' ); ?>
				<input type="text" value="<?php echo  trim(esc_attr($ovaex_map_lat)); ?>" name="ovaex_map_lat" id="ovaex_map_lat"  autocomplete="off"/>	
			</label>

			&nbsp;&nbsp;&nbsp;

			<label>

				<?php esc_html_e( 'Longitude: ', 'ovaex' ); ?>
				<input type="text" value="<?php echo trim(esc_attr($ovaex_map_lng)); ?>" name="ovaex_map_lng" id="ovaex_map_lng" autocomplete="off"/>	
			</label>

		</div>

	</div>
	<br>


</div>
<?php wp_nonce_field( 'ovaex_nonce', 'ovaex_nonce' ); ?>