(function($){
   "use strict";

   $(document).ready(function(){

        if( $('.single_exhibition .gallery_exhibition .gallery_slide').length > 0 ){
            $('.single_exhibition .gallery_exhibition .gallery_slide').each(function(){

                var rtl = false;
                
                if( $('body').hasClass('rtl') ){
                   rtl = true;
                }

                $(this).owlCarousel({
                    items:2,
                    autoplay: true,
                    autoplayHoverPause: true,
                    loop: false,
                    nav: false,
                    dots: true,
                    margin: 20,
                    rtl: rtl,
                    responsive:{
                        0:{
                            items:1,
                        },
                        767:{
                            items:2,
                        },
                        1200:{
                            items:2,
                        }
                    }
                });
                
                /* Fixed WCAG */
                $(this).find(".owl-nav button.owl-prev").attr("title", "Previous");
                $(this).find(".owl-nav button.owl-next").attr("title", "Next");
                $(this).find(".owl-dots button").attr("title", "Dots");
            });
        }


        /***** Map *****/
        function gg_map_initialize() {

            var lat = parseFloat( $("#single-exhibition-map").data('lat') );
            var lng = parseFloat( $("#single-exhibition-map").data('lng') );

            var address = $("#single-exhibition-map").data('address');
            var zoom    = parseInt( $("#single-exhibition-map").data('zoom') );

            var infoWindow = new google.maps.InfoWindow();

            var loc = {lat: lat, lng: lng};

            var map = new google.maps.Map(document.getElementById('single-exhibition-map'), {
                zoom: zoom,
                center: loc,
                scrollwheel: false
           });

            var marker = new google.maps.Marker({
                position: loc,
                map: map
           });    

            google.maps.event.addListener(marker, 'click', (function(marker) {
                return function() {
                    infoWindow.setContent(address);
                    infoWindow.open(map, marker);
                }   
            })(marker));

        }

        if( typeof google !== 'undefined' && $("#single-exhibition-map").length > 0 ){ 
            google.maps.event.addDomListener(window, "load", gg_map_initialize);
        }

        Fancybox.bind('[data-fancybox="exhibition-gallery"]', {
            Image: {
                zoom: false,
            },
        });

   });

})(jQuery);