<?php if ( !defined( 'ABSPATH' ) ) exit();

$data_options['items']              = $args['item_number'];
$data_options['slideBy']            = $args['slides_to_scroll'];
$data_options['margin']             = $args['margin_items'];
$data_options['autoplayHoverPause'] = $args['pause_on_hover'] === 'yes' ? true : false;
$data_options['loop']               = $args['infinite'] === 'yes' ? true : false;
$data_options['autoplay']           = $args['autoplay'] === 'yes' ? true : false;
$data_options['autoplayTimeout']    = $args['autoplay_speed'];
$data_options['smartSpeed']         = $args['smartspeed'];
$data_options['dots']               = $args['dot_control'] === 'yes' ? true : false;
$data_options['rtl']                = is_rtl() ? true : false;

$pors  = ova_por_query( $args );

?>

<div class="ova_por_slider" data-option="<?php echo esc_attr( json_encode($data_options) ); ?>">
	<?php if ( $pors->have_posts() ) : ?>
	    <div class="owl-carousel owl-theme">
	    	<?php while ( $pors->have_posts() ) : $pors->the_post();
				$id 		= get_the_ID();
				$image_src 	= \Elementor\Utils::get_placeholder_image_src();
				$image_alt 	= get_the_title();
				if ( has_post_thumbnail( $id ) ) {
					$image_src 	= get_the_post_thumbnail_url( $id, 'ova_por_thumbnail' );
					$image_id 	= get_post_thumbnail_id( $id );
					if (get_post_meta($image_id, '_wp_attachment_image_alt', true)) {
						$image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', true);
					}
				}
			?>
		        <div class="item portfolio">
	        		<img src="<?php echo esc_url( $image_src ) ?>" alt="<?php echo esc_attr( $image_alt ); ?>" class="img">
	        		<?php if($show_icon == 'yes') : ?>
		        		<div class="info">
		        			<div class="info-wrap">
	        					<a href="<?php the_permalink(); ?>" class="icon"
									title="<?php the_title(); ?>"
								>
									<i class="gimonticon gimonticon-right"></i>
								</a>
		        			</div>
		        		</div>
		        	<?php endif; ?>
		        </div>
	    	<?php endwhile; ?>
	    </div>
    <?php endif; wp_reset_postdata(); ?>
</div>

<?php 