<?php if ( !defined( 'ABSPATH' ) ) exit();

$data_options['items']              = $args['item_number'];
$data_options['slideBy']            = $args['slides_to_scroll'];
$data_options['margin']             = $args['margin_items'];
$data_options['autoplayHoverPause'] = $args['pause_on_hover'] === 'yes' ? true : false;
$data_options['loop']               = $args['infinite'] === 'yes' ? true : false;
$data_options['autoplay']           = $args['autoplay'] === 'yes' ? true : false;
$data_options['autoplayTimeout']    = $args['autoplay_speed'];
$data_options['smartSpeed']         = $args['smartspeed'];
$data_options['dots']               = $args['dot_control'] === 'yes' ? true : false;
$data_options['rtl']                = is_rtl() ? true : false;


$pors  = ova_por_query( $args );

?>

<div class="ova_por_slider_2" data-option="<?php echo esc_attr( json_encode($data_options) ); ?>">

	<?php if ( $pors->have_posts() ): ?>

	    <div class="owl-carousel owl-theme">

	    	<?php while ( $pors->have_posts() ) : $pors->the_post();
				$id 		= get_the_ID();
				$image_src 	= \Elementor\Utils::get_placeholder_image_src();
				$image_alt 	= get_the_title();
				if ( has_post_thumbnail( $id ) ) {
					$image_src 	= get_the_post_thumbnail_url( $id, 'gimont_thumbnail' );
					$image_id 	= get_post_thumbnail_id( $id );
					if (get_post_meta($image_id, '_wp_attachment_image_alt', true)) {
						$image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', true);
					}
				}

				// categories
				$categories = get_the_terms( $id, 'cat_por' );
				$cate_links = array();
				if ( $categories ) {
					foreach ($categories as $cate) {
						array_push( $cate_links, '<a href="'.esc_url( get_term_link( $cate ) ).'" title="'.esc_attr( get_the_title($id) ).'">'.esc_html( $cate->name ).'</a>' );
					}
				}
			?>
		        <div class="item portfolio">
	        		<img src="<?php echo esc_url( $image_src ) ?>" alt="<?php echo esc_attr( $image_alt ); ?>" class="img">

	        		<?php if ( $show_category == 'yes' ||  $show_title == 'yes' || $show_icon == 'yes' ) : ?>
		        		<div class="info">
		        			<div class="info-wrap">
		        				<div class="content">
									<?php if ( $cate_links && $show_category == 'yes' ) : ?>
										<p class="categories"><?php echo implode(", ",$cate_links); ?></p>
									<?php endif; ?>

									<?php if ( $show_title == 'yes' ) : ?>
										<?php if ( $show_link_to == 'yes' ) : ?>
										<a href="<?php the_permalink(); ?>"
											title="<?php the_title(); ?>"
										>
										<?php endif; ?>
				        					<h3 class="title">
												<?php echo esc_html( get_the_title() ); ?>
											</h3>
										<?php if ( $show_link_to == 'yes' ) : ?>
										</a>
										<?php endif; ?>
									<?php endif; ?>
		        				</div>

		        				<?php if ( $show_icon == 'yes' ) : ?>
		        					<?php if ( $show_link_to == 'yes' ) : ?>
		        					<a href="<?php the_permalink(); ?>" aria-label="<?php esc_attr_e( 'Portfolio Link', 'ova-por' ); ?>"
										title="<?php the_title(); ?>"
									>	
									<?php endif; ?>
										<div class="icon">
											<i class="gimonticon gimonticon-right" aria-hidden="true"></i>
										</div>
									<?php if ( $show_link_to == 'yes' ) : ?>
									</a>
									<?php endif; ?>
								<?php endif; ?>
		        			</div>
		        		</div>
		        	<?php endif; ?>
		        </div>

	    	<?php endwhile; ?>

	    </div>

    <?php endif;wp_reset_postdata(); ?>

</div>

<?php 