<?php
/**
 * Include and setup custom metaboxes and fields. (make sure you copy this file to outside the CMB2 directory)
 *
 * Be sure to replace all instances of 'yourprefix_' with your project's prefix.
 * http://nacin.com/2010/05/11/in-wordpress-prefix-everything/
 *
 * @category YourThemeOrPlugin
 * @package  Demo_CMB2
 * @license  http://www.opensource.org/licenses/gpl-license.php GPL v2.0 (or later)
 * @link     https://github.com/WebDevStudios/CMB2
 */



add_action( 'cmb2_init', 'ova_doc_metaboxes' );
function ova_doc_metaboxes() {

    // Start with an underscore to hide fields from custom fields list
    $prefix = 'ova_doc_met_';
    
    $doc_settings = new_cmb2_box( array(
        'id'            => 'ovadoc_settings',
        'title'         => esc_html__( 'Document settings', 'ova-doc' ),
        'object_types'  => array( 'ova_doc'), // Post type
        'context'       => 'normal',
        'priority'      => 'high',
        'show_names'    => true,
        
    ) );

    $doc_settings->add_field( array(
        'name' => esc_html__( 'List Document Attachment', 'ova-doc' ),
        'id'   => $prefix . 'list_document',
        'type' => 'file_list',
    ) );

    $doc_settings->add_field( array(
        'name'        => esc_html__( 'Publish Date', 'ova-doc' ),
        'id'          => $prefix . 'publish_date',
        'type'        => 'text_date_timestamp',
        'date_format' => 'm/d/Y',
    ) );

    $doc_settings->add_field( array(
        'name'    => esc_html__( 'Sort Order', 'ova-doc' ),
        'id'      => $prefix . 'order_doc',
        'desc'    => esc_html__( 'Insert Number', 'ova-doc' ),
        'type'    => 'text',
        'default' =>'1',
    ) );  
}

