(function($){
	"use strict";

	$(window).on('elementor/frontend/init', function () {

        elementorFrontend.hooks.addAction('frontend/element_ready/ova_doc_download_3.default', function(){

            var ovaDocSlider    = $('.document-slider');
            var owlDataOptions  = ovaDocSlider.attr('data-option');
            var owlOptions      = JSON.parse(owlDataOptions);

            if ( $('body').hasClass('rtl') ) {
                owlOptions.rtl = true;
            }

            ovaDocSlider.find('.owl-carousel').owlCarousel({
                loop:owlOptions.infinite,
                margin:owlOptions.margin,
                nav:false,
                dots: owlOptions.dots,
                items: owlOptions.items,
                autoplay: owlOptions.autoplay,
                autoplayTimeout: owlOptions.autoplaySpeed,
                autoplayHoverPause: owlOptions.pauseOnHover,
                slideBy: owlOptions.slidesToScroll,
                smartSpeed: owlOptions.smartspeed,
                rtl: owlOptions.rtl,
                responsive:{
                    0:{
                        items:1
                    },
                    600:{
                        items:2
                    },
                    1200:{
                        items:owlOptions.items
                    }
                }
            });

            /* Fixed WCAG */
            ovaDocSlider.find(".owl-nav button.owl-prev").attr("title", "Previous");
            ovaDocSlider.find(".owl-nav button.owl-next").attr("title", "Next");
            ovaDocSlider.find(".owl-dots button").attr("title", "Dots");

            var body    = $("body");
            var modal   = $(".ova-doc-download-3 .ova-doc-modal");
            var viewBtn = $(".ova-doc-download-3 .view");
            var icon    = $(".ova-doc-download-3 .icon");

            if (modal.length) {
                body.click(function(e){
                    if ( e.target == modal[0] ) {
                        modal.slideUp();
                    }
                });
                viewBtn.click(function(e){
                    e.preventDefault();
                    var loader = $(this).parent().find(".loader");
                    var docId = $(this).attr("data-id");
                    loader.addClass("is-active");
                    $.ajax({
                        type: "post",
                        dataType: "html",
                        url: ova_doc_ajax_object.ajax_url,
                        data: {
                            action: 'ova_show_file_list',
                            id: docId,
                        },
                        success: function(response){
                            modal.html(response);
                            modal.slideDown();
                            loader.removeClass("is-active");
                        }
                    });
                    
                });
                icon.click(function(e){
                    e.preventDefault();
                    var loader = $(this).parent().find(".loader");
                    var docId = $(this).attr("data-id");
                    loader.addClass("is-active");
                    $.ajax({
                        type: "post",
                        dataType: "html",
                        url: ova_doc_ajax_object.ajax_url,
                        data: {
                            action: 'ova_show_file_list',
                            id: docId,
                        },
                        success: function(response){
                            modal.html(response);
                            modal.slideDown();
                            loader.removeClass("is-active");
                        }
                    });
                    
                });

                $(document).on('click', ".ova-doc-modal .close", function () {    
                    modal.slideUp();
                });
            }
        });

    });
})(jQuery);