jQuery(document).ready(function($) {

    /* Show Document Files */
    var body  = $("body");
    var modal = $(".ova-doc-modal");

    if (modal.length) {
        body.click(function(e){
            if ( e.target == modal[0] ) {
                modal.slideUp();
            }
        });

        $(document).on('click', ".ova-doc-archive .document-list .view", function (e) {
            e.preventDefault();

            var loader = $(this).parents(".item").find(".loader");
            var docId  = $(this).attr("data-id");

            loader.addClass("is-active");

            $.ajax({
                type: "post",
                dataType: "html",
                url: ova_doc_ajax_object.ajax_url,
                data: {
                    action: 'ova_show_file_list',
                    id: docId,
                },
                success: function(response){
                    modal.html(response);
                    modal.slideDown();
                    loader.removeClass("is-active");
                }
            });
        });

        $(document).on('click', ".ova-doc-archive .document-list .icon", function (e) {
            e.preventDefault();
            var loader = $(this).parents(".item").find(".loader");
            var docId = $(this).attr("data-id");
            loader.addClass("is-active");
            $.ajax({
                type: "post",
                dataType: "html",
                url: ova_doc_ajax_object.ajax_url,
                data: {
                    action: 'ova_show_file_list',
                    id: docId,
                },
                success: function(response){
                    modal.html(response);
                    modal.slideDown();
                    loader.removeClass("is-active");
                }
            });
        });

        $(document).on('click', ".ova-doc-modal .close", function () {    
            modal.slideUp();
        });
    }

});