<?php 
defined( 'ABSPATH' ) || exit();

if( !class_exists( 'OVADOC_assets' ) ){
	class OVADOC_assets{

		public function __construct(){
			// Admin
			add_action( 'admin_enqueue_scripts', array( $this, 'ovadoc_admin_enqueue_scripts' ) );

			// Frontend
			add_action( 'wp_enqueue_scripts', array( $this, 'ovadoc_enqueue_scripts' ), 10, 0 );
		}

		// Admin
		public function ovadoc_admin_enqueue_scripts(){
			global $pagenow;
			if ( ( $pagenow == 'post.php' || $pagenow == 'post-new.php' ) && get_post_type() === 'ova_doc' ) {
				wp_enqueue_style( 'ovadoc_admin_style', OVADOC_PLUGIN_URI.'assets/css/admin/ovadoc-admin-style.css' );
			}
		}

		// Frontend
		public function ovadoc_enqueue_scripts(){

			if ( is_tax( 'cat_doc' ) || is_post_type_archive( 'ova_doc' ) ) {
				wp_enqueue_script('ova_doc_caleran_hammer', OVADOC_PLUGIN_URI . 'assets/libs/caleran/vendor/jquery.hammer.js', array('jquery'), false, true);
				wp_enqueue_script('ova_doc_caleran_moment', OVADOC_PLUGIN_URI . 'assets/libs/caleran/vendor/moment.min.js', array('jquery'), false, true);
				wp_enqueue_style( 'ova_doc_caleran', OVADOC_PLUGIN_URI.'assets/libs/caleran/css/caleran.min.css' );
				wp_enqueue_script('ova_doc_caleran_js', OVADOC_PLUGIN_URI . 'assets/libs/caleran/js/caleran.min.js', array('jquery'), false, true);

				wp_enqueue_style( 'select2', OVADOC_PLUGIN_URI.'assets/libs/select2/select2.min.css', array(), null );
				wp_enqueue_script( 'select2', OVADOC_PLUGIN_URI.'assets/libs/select2/select2.min.js', array('jquery'), false, true );

				wp_enqueue_style( 'ovadoc_style', OVADOC_PLUGIN_URI.'assets/css/frontend/ovadoc-style.css' );
				wp_enqueue_style( 'ova_show_doc_style', OVADOC_PLUGIN_URI.'assets/css/frontend/show-document.css' );
				wp_enqueue_script('ovadoc_script', OVADOC_PLUGIN_URI . 'assets/js/ova-doc.js', array('jquery'), false, true);	
				wp_localize_script( 'ovadoc_script', 'Placeholder', array('name' => esc_html__( 'Name', 'ova-doc' )) );

				wp_enqueue_script('ova_show_doc_script', OVADOC_PLUGIN_URI . 'assets/js/show-document.js', array('jquery'), false, true);
				wp_localize_script( 'ova_show_doc_script', 'ova_doc_ajax_object', array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );	
			}

			if ( is_singular( 'ova_doc' ) ) {
				wp_enqueue_style( 'ovadoc_style', OVADOC_PLUGIN_URI.'assets/css/frontend/ovadoc-style.css' );
				wp_enqueue_style( 'ova_show_doc_style', OVADOC_PLUGIN_URI.'assets/css/frontend/show-document.css' );
			}
			
		}

	}
	new OVADOC_assets();
}