<?php if ( !defined( 'ABSPATH' ) ) exit();
	$documents 	= ova_doc_query($args);
?>

<div class="ova-doc-items">
	<?php if ( $documents->have_posts() ) : ?>
		<ul class="document-list">
			<?php while ( $documents->have_posts() ) : $documents->the_post();
				$id 			= get_the_ID();
				$published_date = get_post_meta( $id, 'ova_doc_met_publish_date', true);
			?>
				<li class="item">
					<div class="item-wrap">
						<div class="info">
							<?php if ( $show_view_icon == 'yes' ) : ?>
								<a href="#" class="view"
									data-id="<?php echo esc_attr( $id ); ?>"
									title="<?php esc_attr_e( 'View files', 'ova-doc' ); ?>"
								>
									<i class="far fa-eye" aria-hidden="true"></i>
									<span class="loader"></span>
								</a>
							<?php endif; ?>

							<?php if ( $published_date && $show_date == 'yes' ) : ?>
								<p class="date">
									<?php echo esc_html( date_i18n( 'F d, Y', $published_date ) ); ?>
								</p>
							<?php endif; ?>

							<?php if ( $show_title == 'yes' ) : ?>
								<?php if ( $show_link_to == 'yes' ) : ?>
									<a href="<?php echo esc_url( get_the_permalink( $id ) ); ?>"
										title="<?php echo esc_attr( get_the_title( $id ) ); ?>"
									>
								<?php endif; ?>
									<h3 class="title">
										<?php echo esc_html( get_the_title( $id ) ); ?>
									</h3>
								<?php if ( $show_link_to == 'yes' ) : ?>
									</a>
								<?php endif; ?>
							<?php endif; ?>
						</div>

						<?php if ( $show_download_icon == 'yes' ) : ?>
							<a href="#" title="<?php esc_attr_e( 'Download files', 'ova-doc' ); ?>" class="icon" data-id="<?php echo esc_attr( $id ); ?>">
								<i class="gimonticon-download" aria-hidden="true"></i>
							</a>
						<?php endif; ?>
					</div>
				</li>
			<?php endwhile; ?>
		</ul>
	<?php endif;wp_reset_postdata();?>
	<div class="ova-doc-modal" aria-label="<?php esc_attr_e('Popup Window','ova-doc'); ?>"></div>
</div>