<?php
/**
 * Include and setup custom metaboxes and fields. (make sure you copy this file to outside the CMB2 directory)
 *
 * Be sure to replace all instances of 'yourprefix_' with your project's prefix.
 * http://nacin.com/2010/05/11/in-wordpress-prefix-everything/
 *
 * @category YourThemeOrPlugin
 * @package  Demo_CMB2
 * @license  http://www.opensource.org/licenses/gpl-license.php GPL v2.0 (or later)
 * @link     https://github.com/WebDevStudios/CMB2
 */



add_action( 'cmb2_init', 'ova_sev_metaboxes' );
function ova_sev_metaboxes() {

    // Start with an underscore to hide fields from custom fields list
    $prefix = 'ova_sev_met_';
    
    /* Team Settings ***************************************************************************/
    /* ************************************************************************************/
    $sev_settings = new_cmb2_box( array(
        'id'            => 'ovasev_settings',
        'title'         => esc_html__( 'Service settings', 'ova-sev' ),
        'object_types'  => array( 'ova_sev'), // Post type
        'context'       => 'normal',
        'priority'      => 'high',
        'show_names'    => true,
    ) );

        $sev_settings->add_field( array(
            'name'             => esc_html__( 'Template', 'ova-sev' ),
            'id'               => $prefix . 'single_template',
            'type'             => 'select',
            'default'          => '',
            'show_option_none' => true,
            'options'          => array(
                'template_1'   => esc_html__( 'Template 1', 'ova-sev' ),
                'template_2'   => esc_html__( 'Template 2', 'ova-sev' ),
            ),
            'desc' => esc_html__( 'None: please go to Dashboard > Appearance > Service > Single > Template', 'ova-sev' ),
        ) );

        $sev_settings->add_field( array(
            'name'       => esc_html__( 'Class Icon', 'ova-sev' ),
            'id'         => $prefix . 'class_icon',
            'type'    => 'text',
        ) );

        $sev_settings->add_field( array(
            'name'       => esc_html__( 'Sort Order', 'ova-sev' ),
            'id'         => $prefix . 'order_sev',
            'desc' => esc_html__( 'Insert Number', 'ova-sev' ),
            'type'    => 'text',
            'default' =>'1',
        ) );

        // Listings
        $group_listing = $sev_settings->add_field( array(
            'id'          => $prefix . 'listing',
            'type'        => 'group',
            'options'     => array(
                'group_title'       => esc_html__( 'Listing', 'ova-sev' ), 
                'add_button'        => esc_html__( 'Add Listing', 'ova-sev' ),
                'remove_button'     => esc_html__( 'Remove', 'ova-sev' ),
                'sortable'          => true, 
            ),
        ) );

        $sev_settings->add_group_field( $group_listing, array(
            'name' => esc_html__( 'Title', 'ova-sev' ),
            'id'   => $prefix . 'listing_title',
            'type' => 'text',
        ) );       
        
        $sev_settings->add_group_field( $group_listing, array(
            'name' => esc_html__( 'Value', 'ova-sev' ),
            'id'   => $prefix . 'listing_value',
            'type' => 'text',
        ) );

        $sev_settings->add_group_field( $group_listing, array(
            'name' => esc_html__( 'Link', 'ova-sev' ),
            'id'   => $prefix . 'listing_link',
            'description' => esc_html__("Example: tel:0123456789; mailto:needhelp@gmail.com; https://ovatheme.com; or can leave empty",'ova-sev'),
            'type' => 'text',
        ) );

}