<?php
namespace ova_sev_elementor\Widgets;

use Elementor\Widget_Base;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class ova_sev_category_2 extends Widget_Base {

	public function get_name() {
		return 'ova_sev_category_2';
	}

	public function get_title() {
		return esc_html__( 'Service Category 2', 'ova-sev' );
	}

	public function get_icon() {
		return 'eicon-posts-grid';
	}

	public function get_categories() {
		return [ 'ovatheme_service' ];
	}

	public function get_script_depends() {
		return [ '' ];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'ova-sev-category-2', OVASEV_PLUGIN_URI.'/assets/css/elementor/sev-category-2.css', array(), null);
		return [];
	}

	protected function register_controls() {

		/* Content */
		$this->start_controls_section(
				'content_section',
				[
					'label' => esc_html__( 'Content', 'ova-sev' ),
					'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				]
			);

			$this->add_control(
				'columns',
				[
					'label' => esc_html__( 'Columns', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'three_columns',
					'options' => [
						'one_column' => esc_html__( '1', 'ova-sev' ),
						'two_columns' => esc_html__( '2', 'ova-sev' ),
						'three_columns' => esc_html__( '3', 'ova-sev' ),
						'four_columns' => esc_html__( '4', 'ova-sev' ),
					],
				]
			);

			$this->add_control(
				'link_to',
				[
					'label' => esc_html__( 'Link to', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'category',
					'options' => [
						'category'  => esc_html__( 'Category', 'ova-sev' ),
						'new_page' 	=> esc_html__( 'New Page', 'ova-sev' ),
					],
				]
			);

			$this->add_control(
				'custom_link',
				[
					'label' 		=> esc_html__( 'Custom Link', 'ova-sev' ),
					'type' 			=> \Elementor\Controls_Manager::URL,
					'placeholder' 	=> esc_html__( 'https://your-link.com', 'ova-sev' ),
					'dynamic' 		=> [
						'active' => true,
					],
					'default' => [
						'url' 			=> '#',
						'is_external' 	=> false,
						'nofollow' 		=> false,
					],
					'condition' => [
						'link_to' => 'new_page',
					],
				]
			);

			$this->add_control(
				'category_not_in',
				[
					'label'   		=> esc_html__( 'Category Not In', 'ova-sev' ),
					'type'    		=> \Elementor\Controls_Manager::TEXT,
					'description' 	=> esc_html__( 'Enter the service category IDs. IDs are separated by "|". Ex: 1|2|3.', 'ova-sev' ),
				]
			);

			$this->add_control(
				'show_items',
				[
					'label' => esc_html__( 'Show Items', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-sev' ),
					'label_off' => esc_html__( 'Hide', 'ova-sev' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

		$this->end_controls_section();

		/* Title */
		$this->start_controls_section(
				'title_style_section',
				[
					'label' => esc_html__( 'Title', 'ova-sev' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'title_typography',
					'selector' => '{{WRAPPER}} .ova-sev-category-2 .title',
				]
			);

			$this->add_control(
				'title_color',
				[
					'label' => esc_html__( 'Color', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-sev-category-2 .title' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'title_background',
				[
					'label' => esc_html__( 'Background', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-sev-category-2 .title' => 'background: {{VALUE}}',
						'{{WRAPPER}} .ova-sev-category-2 .title:after' => 'border-top-color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		/*Category*/
		$this->start_controls_section(
				'category_style_section',
				[
					'label' => esc_html__( 'Category', 'ova-sev' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name' => 'cate_border',
					'selector' => '{{WRAPPER}} .ova-sev-category-2 .service-cat-list',
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'cate_typography',
					'selector' => '{{WRAPPER}} .ova-sev-category-2 .service-cat-list .cate_name',
				]
			);

			$this->start_controls_tabs(
				'cate_style_tabs'
				);

				$this->start_controls_tab(
						'cate_style_normal_tab',
						[
							'label' => esc_html__( 'Normal', 'ova-sev' ),
						]
					);

					$this->add_control(
						'cate_color',
						[
							'label' => esc_html__( 'Color', 'ova-sev' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-sev-category-2 .service-cat-list .cate_name' => 'color: {{VALUE}}',
								'{{WRAPPER}} .ova-sev-category-2 .service-cat-list .item-link i' => 'color: {{VALUE}}',
							],
						]
					);

					$this->add_control(
						'cate_background',
						[
							'label' => esc_html__( 'Background', 'ova-sev' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-sev-category-2 .service-cat-list .item-link' => 'background: {{VALUE}}',
							],
						]
					);

				$this->end_controls_tab();

				$this->start_controls_tab(
					'cate_style_hover_tab',
						[
							'label' => esc_html__( 'Hover', 'ova-sev' ),
						]
					);

					$this->add_control(
						'cate_hover_color',
						[
							'label' => esc_html__( 'Color', 'ova-sev' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-sev-category-2 .service-cat-list .cate_name:hover' => 'color: {{VALUE}}',
								'{{WRAPPER}} .ova-sev-category-2 .service-cat-list .item-link i:hover' => 'color: {{VALUE}}',
							],
						]
					);

					$this->add_control(
						'cate_hover_background',
						[
							'label' => esc_html__( 'Background', 'ova-sev' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-sev-category-2 .service-cat-list .item-link:hover' => 'background: {{VALUE}}',
								'{{WRAPPER}} .ova-sev-category-2 .service-cat-list .item-link.active' => 'background: {{VALUE}}',
							],
						]
					);

				$this->end_controls_tab();

			$this->end_controls_tabs();

		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();
		$template = apply_filters( 'el_elementor_ova_sev_category_2', 'elementor/ova_sev_category_2.php' );

		ob_start();
		ovasev_get_template( $template, $settings );
		echo ob_get_clean();
	}
}
