<?php if ( !defined( 'ABSPATH' ) ) exit();

get_header();

global $wp_query;

$number_column 	= get_theme_mod( 'ova_sev_layout', 'three_columns' );
$cate_slug 		= get_query_var('cat_sev') ? get_query_var('cat_sev') : 'all';

$post_per_page 	= get_theme_mod( 'ova_sev_total_record', 9 );
$order_by 		= get_theme_mod( 'ova_sev_orderby', 'ID' );
$order 			= get_theme_mod( 'ova_sev_order', 'DESC' );

$args_query = array(
	'order_by' 			=> $order_by,
	'order' 			=> $order,
	'posts_per_page' 	=> $post_per_page,
	'cate' 				=> $cate_slug,
);

$all_ids   = ova_sev_get_all_id();
$all_names = [];

foreach ($all_ids as $id ) {
	$all_names[$id] = get_the_title($id);
}

// show fields
$args_show = array(
	'show_icon' 		 => get_theme_mod( 'ova_sev_archive_show_icon', 'yes' ),
	'show_title' 		 => get_theme_mod( 'ova_sev_archive_show_title', 'yes' ),
	'show_link_of_title' => get_theme_mod( 'ova_sev_archive_show_link_of_title', 'yes' ),
	'show_desc' 		 => get_theme_mod( 'ova_sev_archive_show_excerpt', 'yes' ),
	'show_button' 		 => get_theme_mod( 'ova_sev_archive_show_button', 'yes' ),
	'show_total_results' => get_theme_mod( 'ova_sev_show_total_results', 'yes' ),
	'show_sort_by'       => get_theme_mod( 'ova_sev_show_sort_by', 'yes' ),
);

$show_search_name     = get_theme_mod( 'ova_sev_show_search_name', 'yes' );
$show_search_category = get_theme_mod( 'ova_sev_show_search_category', 'yes' );
$show_total_results   = get_theme_mod( 'ova_sev_show_total_results', 'yes' );
$show_sort_by         = get_theme_mod( 'ova_sev_show_sort_by', 'yes' );

// search sort
$order_by   = get_theme_mod( 'ova_sev_orderby', 'ID' );
$order 		= get_theme_mod( 'ova_sev_order', 'DESC' );

if( ($order_by == 'ID' || $order_by == 'date') && $order == 'DESC' ) {
	$search_sort_default = 'date-desc';
} elseif( ($order_by == 'ID' || $order_by == 'date') && $order == 'ASC' ) {
	$search_sort_default = 'date-asc';
} elseif( $order_by == 'title' && $order == 'DESC' ) {
	$search_sort_default = 'z-a';
} elseif( $order_by == 'title' && $order == 'ASC' ) {
	$search_sort_default = 'a-z';
} elseif( $order_by == 'ova_sev_met_order_sev' && $order == 'ASC' ) {
	$search_sort_default = 'sort-order-asc';
} elseif( $order_by == 'ova_sev_met_order_sev' && $order == 'DESC' ) {
	$search_sort_default = 'sort-order-desc';
} elseif( $order_by == 'rand' ) {
	$search_sort_default = 'rand';
} else {
	$search_sort_default = 'date-desc';
}

?>

<div class="row_site">
	<div class="container_site">
		<div class="ova-sev-archive has-sev-filter <?php echo esc_attr( $number_column ); ?>" 
			data-names="<?php echo esc_attr(json_encode($all_names)); ?>"
			data-post_per_page="<?php echo esc_attr($post_per_page );?>"
			data-order="<?php echo esc_attr($order );?>"
			data-order_by="<?php echo esc_attr($order_by );?>"
			data-sort_default="<?php echo esc_attr( $search_sort_default ); ?>"
			data-args_show="<?php echo esc_attr( json_encode($args_show) );?>"
		>

			<?php if($show_search_name == 'yes' || $show_search_category == 'yes' ) : ?>
				<form id="ova-sev-filter" class="ova-sev-filter" method="POST" autocomplete="off">
					<div class="wrapper">
						<?php if($show_search_name == 'yes') : ?>
							<div class="sev-name">
								<input type="text" name="ovasev_name" aria-label="<?php esc_attr_e( 'Service Name', 'ova-sev' ); ?>" id="ovasev_name" class="ovasev_name" placeholder="Name">
							</div>
						<?php endif;?>

						<?php if($show_search_category == 'yes') : ?>
							<div class="ovasev_cat_search">
								<label for="ovasev_category" class="visuallyhidden"><?php esc_html_e( 'Categories', 'ova-sev' ); ?></label>
								<?php $ovadoc_cat_dropdown = apply_filters( 'ovasev_cat_dropdown', $cate_slug ); ?>
								<i class="arrow_carrot-down" aria-hidden="true"></i>
							</div>
						<?php endif;?>

						<div class="wrap-ovasev_submit">
							<button type="submit" class="ovasev_submit" aria-label="<?php esc_attr_e( 'Search Service', 'ova-sev' ); ?>"><?php esc_html_e( 'Search', 'ova-sev' ); ?></button>
						</div>
					</div>
				</form>
			<?php endif;?>

			<div class="ova-sev-loader">
				<div class="loader" aria-hidden="true"></div>
			</div>

			<div class="content_inner">
				<div class="wrap_search_filter">
					<?php if ( $show_total_results == 'yes' ): ?>
						<div class="results_found">
							<?php if ( $wp_query->found_posts == 1 ): ?>
							<span>
								<?php echo sprintf( esc_html__( '%s Result Found', 'ova-sev' ), esc_html( $wp_query->found_posts ) ); ?>
							</span>
							<?php else: ?>
							<span>
								<?php echo sprintf( esc_html__( '%s Results Found', 'ova-sev' ), esc_html( $wp_query->found_posts ) ); ?>
							</span>
							<?php endif; ?>

							<?php if ( 1 == ceil( $wp_query->found_posts/ $wp_query->query_vars['posts_per_page']) && $wp_query->have_posts() ): ?>
								<span>
									<?php echo sprintf( esc_html__( '(Showing 1-%s)', 'ova-sev' ), esc_html( $wp_query->found_posts ) ); ?>
								</span>
							<?php elseif ( !$wp_query->have_posts() ): ?>
								<span></span>
							<?php else: ?>
								<span>
									<?php echo sprintf( esc_html__( '(Showing 1-%s)', 'ova-sev' ), esc_html( $wp_query->query_vars['posts_per_page'] ) ); ?>
								</span>
							<?php endif; ?>
						</div>
					<?php endif; ?>

					<?php if ( $show_sort_by == 'yes' ): ?>
						<div id="search_sort">
							<select name="sort">
								<option value=""><?php esc_html_e( 'Sort By', 'ova-sev' ); ?></option>
								<option value="date-desc" <?php if( $search_sort_default == 'date-desc' ) echo 'selected'; ?>>
									<?php esc_html_e( 'Newest First', 'ova-sev' ); ?>
								</option>
								<option value="date-asc" <?php if( $search_sort_default == 'date-asc' ) echo 'selected'; ?>>
									<?php esc_html_e( 'Oldest First', 'ova-sev' ); ?>
								</option>
								<option value="a-z" <?php if( $search_sort_default == 'a-z' ) echo 'selected'; ?>>
									<?php esc_html_e( 'A-Z', 'ova-sev' ); ?>
								</option>
								<option value="z-a" <?php if( $search_sort_default == 'z-a' ) echo 'selected'; ?>>
									<?php esc_html_e( 'Z-A', 'ova-sev' ); ?>
								</option>
								<option value="sort-order-desc" <?php if( $search_sort_default == 'sort-order-desc' ) echo 'selected'; ?>>
									<?php esc_html_e( 'Sort Order Desc', 'ova-sev' ); ?>
								</option>
								<option value="sort-order-asc" <?php if( $search_sort_default == 'sort-order-asc' ) echo 'selected'; ?>>
									<?php esc_html_e( 'Sort Order Asc', 'ova-sev' ); ?>
								</option>
								<option value="rand" <?php if( $search_sort_default == 'rand' ) echo 'selected'; ?>>
									<?php esc_html_e( 'Random', 'ova-sev' ); ?>
								</option>
							</select>
						</div>
					<?php endif; ?>
				</div>

				<?php if ( have_posts() ) : ?>
					<div class="wrapper">
						<?php while ( have_posts() ) : the_post();
							ovasev_get_template( 'parts/item-service.php', $args_show );
						endwhile; ?>
					</div>
					<?php else: ?>
					<p><?php esc_attr_e( 'Not found !', 'ova-sev' ); ?></p>
				<?php endif; wp_reset_postdata();
					$total_pages 	= $wp_query->max_num_pages;
					$curent_page 	= 1;
					ob_start();
					ova_sev_pagination_ajax($total_pages,$curent_page,$post_per_page,$args_query,$search_sort_default);
					echo ob_get_clean();
				?>
			</div>

		</div>
	</div>
</div>

<?php get_footer();