<?php if ( !defined( 'ABSPATH' ) ) exit();

global $post;

$id = get_the_ID();

$columns = $args['columns'];

$category_not_in = isset($args['category_not_in']) ? $args['category_not_in'] : '';

$args_query = array(
	'taxonomy' 	 => 'cat_sev',
	'orderby' 	 => 'name',
	'order'   	 => 'ASC',
	'hide_empty' => false,
	'parent' 	 => 0,
	'exclude'    => explode( '|', $category_not_in )
);

$terms     = get_the_terms( $post, 'cat_sev' );
$term_ids  = [];

if ( $terms ) {
	foreach ($terms as $key => $term) {
		array_push( $term_ids, $term->term_id );
	}
}

$categories = get_categories($args_query);

// custom link
$new_url = '';
if( ( $link_to == 'new_page' ) && isset($custom_link['url']) ) {
	$new_url = $custom_link['url'];
}

?>

<div class="ova-sev-archive elementor <?php echo esc_attr( $columns ); ?>">
	<div class="ova-sev-category-2">
		<div class="wrapper service-cat-list">
			<?php if ( $categories ): foreach ($categories as $category): 
				$cat_url  = get_term_link( $category );
				$cat_slug = $category->slug;
				$cat_name = $category->name;

				if( $new_url != '' ) {
					$cat_url = $new_url.'?cat_slug='.$cat_slug;
				}
			?>
				<a href="<?php echo esc_url( $cat_url ); ?>"
					class="item-link"
					data-slug="<?php echo esc_attr( $cat_slug ); ?>"
					title="<?php echo esc_attr( $cat_name ); ?>"
				>	
					<div class="item">
						<span class="cate_name"><?php echo esc_html( $category->name ); ?></span>
						<i class="flaticonnew- flaticon-new-right-arrows" aria-label="<?php esc_attr_e('View Details','ova-sev'); ?>"></i>
					</div>
					
					<?php if($show_items == 'yes') :
						$args_child_query = array(
							'taxonomy' 		=> 'cat_sev',
							'orderby' 		=> 'name',
							'order'   		=> 'ASC',
							'hide_empty' 	=> false,
							'parent' 		=> $category->term_id,
						);
						$term_id 			= get_queried_object_id();
						$child_categories 	= get_categories( $args_child_query );

						if ( $child_categories ) {
					?>
						<ul class="child-cate">
							<?php foreach ($child_categories as $child) { ?>
								<li class="item">
									<span class="cate_name"><?php echo esc_html( $child->name ); ?></span>
								</li>
							<?php } ?>
						</ul>
					<?php } else {
						$args_sev = array(
							'post_type' 	=> 'ova_sev',
							'numberposts' 	=> 4,
							'orderby' 		=> 'title',
							'order'   		=> 'ASC',
							'tax_query' 	=> array(
						        array(
						            'taxonomy' => 'cat_sev',
						            'field'    => 'slug',
						            'terms' => $cat_slug,
						            'include_children' => true
						        ),
							),
						);

						$list_sevs = get_posts( $args_sev );
						if ( $list_sevs ) {
					?>
						<ul class="service-of-cate">
							<?php foreach ($list_sevs as $sev) { ?>
								<li class="item">
									<span class="sev_title"><?php echo esc_html( $sev->post_title ); ?></span>
								</li>
							<?php } ?>
						</ul>
						<?php } ?>
					<?php } endif; ?>
				</a>
			<?php endforeach; endif; ?>
		</div>
	</div>
</div>