(function($){
	"use strict";

	$(window).on('elementor/frontend/init', function () {
      
      // Event Filer Ajax
      elementorFrontend.hooks.addAction('frontend/element_ready/ova_events_ajax.default', function(){
         $(".ovapo_project_grid").each(function() {

          var slide = $(this).find('.grid');
          var data  = slide.data('owl');
          if ( slide.length > 0 ) {
            slide.owlCarousel(data);
          }

          $(this).find('.button-filter button:first-child').addClass('active');
          
          $(this).find('.button-filter').each(function() {

            var $ovapo_project_grid = $(this).closest('.ovapo_project_grid');

            $(this).on('click', 'button', function(e) {
              e.preventDefault();

              $(this).parent().find('.active').removeClass('active');
              $(this).addClass('active');
              
              var filter                = $(this).data('filter');
              var order                 = $(this).data('order');
              var orderby               = $(this).data('orderby');
              var number_post           = $(this).data('number_post');
              var layout                = $(this).data('layout');
              var first_term            = $(this).data('first_term');
              var term_id_filter_string = $(this).data('term_id_filter_string');
              var show_featured         = $(this).data('show_featured');
              var args_show             = JSON.parse($(this).attr('data-args_show'));

              $ovapo_project_grid.find('.wrap_loader').fadeIn(100);
            
              $.ajax({
                 url: ajax_object.ajax_url,
                 type: 'POST',
                 data: ({
                    action: 'filter_elementor_grid',
                    filter: filter,
                    order: order,
                    orderby: orderby,
                    number_post: number_post,
                    layout: layout,
                    first_term: first_term,
                    term_id_filter_string: term_id_filter_string,
                    show_featured: show_featured,
                    args_show: args_show
                 }),
                 success: function(response){

                    $ovapo_project_grid.find('.wrap_loader').fadeOut(200);

                    var items = $ovapo_project_grid.find('.items');
                    items.empty().append(response).fadeIn(300);
                    items.trigger('destroy.owl.carousel');
                    items.owlCarousel(data);
                 },
              })
            });
          });
        });
      });

   });

})(jQuery);