<?php if ( !defined( 'ABSPATH' ) ) exit();

global $post;

$artist_phone        	= get_post_meta( $post->ID, 'artist_phone', true );
$artist_skill        	= get_post_meta( $post->ID, 'artist_skill', true );
$artist_email        	= get_post_meta( $post->ID, 'artist_email', true );
$artist_page 			= get_post_meta( $post->ID, 'artist_page', true ) ? get_post_meta( $post->ID, 'artist_page', true ) : 'default';
$artist_custom_sort 	= get_post_meta( $post->ID, 'artist_custom_sort', true ) ? get_post_meta( $post->ID, 'artist_custom_sort', true ) : 1;

// Get pages from elementor
$pages 		= get_posts( array('post_type' => 'elementor_library', 'meta_key' => '_elementor_template_type', 'meta_value' => 'page' ) );
$arr_page 	= array( 'default' => 'Default' );

if ( !empty( $pages ) ) {
    foreach( $pages as $page ) {
        $page_id    = $page->ID;
        $page_title = $page->post_title;
        $arr_page[$page_id] = $page_title;
    }
}
?>

<div class="ovacoll_metabox_artist">
	<!-- General Tab Content -->  
	<div id="ovacoll_metabox_artist_basic" class="ovacoll_metabox_artist_basic">
		<div class="ova_collection_metabox_artist">
			<br>
			<div class="ova_collection_row">
				<label class="label" for="artist_skill">
					<strong><?php esc_html_e( 'Skill', 'ova-collection' ); ?>: </strong>
				</label>
				<input 
					type="text" 
					id="artist_skill" 
					value="<?php echo esc_attr( $artist_skill ); ?>"
					placeholder="<?php esc_html_e( 'your skill', 'ova-collection' ); ?>" 
					name="artist_skill" />
			</div>
			<br>
			<div class="ova_collection_row">
				<label class="label" for="artist_phone">
					<strong><?php esc_html_e( 'Phone', 'ova-collection' ); ?>: </strong>
				</label>
				<input 
					type="text" 
					id="artist_phone" 
					value="<?php echo esc_attr( $artist_phone ); ?>" 
					placeholder="<?php esc_html_e( '+861231232323', 'ova-collection' ); ?>" 
					name="artist_phone" />
			</div>
			<br>
			<div class="ova_collection_row">
				<label class="label" for="artist_email">
					<strong><?php esc_html_e( 'Email', 'ova-collection' ); ?>: </strong>
				</label>
				<input 
					type="text" 
					id="artist_email" 
					value="<?php echo esc_attr( $artist_email ); ?>" 
					placeholder="<?php esc_html_e( 'email@mail.com', 'ova-collection' ); ?>" 
					name="artist_email" />
			</div>
			<br>
			<div class="ova_collection_row">
				<label class="label" for="artist_custom_sort">
					<strong><?php esc_html_e( 'Custom Sort', 'ova-collection' ); ?>: </strong>
				</label>
				<input 
					type="number" 
					id="artist_custom_sort" 
					value="<?php echo esc_attr( $artist_custom_sort ); ?>" 
					placeholder="<?php esc_html_e( 'Insert Number', 'ova-collection' ); ?>" 
					name="artist_custom_sort" />
			</div>
			<br>
			<div class="ova_collection_row">
				<label class="label" for="artist_page">
					<strong><?php esc_html_e( 'Add Page', 'ova-collection' ); ?>: </strong>
				</label>
				<select name="artist_page">
					<?php if ( $arr_page ):
						$templates_url =  get_admin_url() . 'edit.php?post_type=elementor_library&tabs_group=library&elementor_library_type=page';

						foreach( $arr_page as $id => $title ):
							$selected = $artist_page == $id ? ' selected' : '';
						?>
						<option value="<?php echo esc_attr( $id ); ?>"<?php echo esc_attr( $selected ); ?> > 
							<?php echo esc_html( $title ); ?>
						</option>
					<?php endforeach; endif; ?>
				</select>
				<span class="note">
					<a href="<?php echo esc_url( $templates_url ); ?>">
						<i><?php esc_html_e( 'Elementor Templates(Type: Page)', 'ova-collection' ); ?></i>
					</a>
				</span>
			</div>
			<br>
		</div>
	</div>
</div>

<?php wp_nonce_field( 'ova_collection_nonce', 'ova_collection_nonce' ); ?>