<?php

if (!defined( 'ABSPATH' )) {
	exit;
}
if (!class_exists( 'Ova_Dep_Customize' )){

	class Ova_Dep_Customize {

		public function __construct() {
			add_action( 'customize_register', array( $this, 'ova_dep_customize_register' ) );
		}

		public function ova_dep_customize_register($wp_customize) {

			$this->ova_dep_init( $wp_customize );

			do_action( 'ova_dep_customize_register', $wp_customize );
		}

		public function ova_dep_init( $wp_customize ){

			$wp_customize->add_panel( 'ova_dep_section' , array(
				'title'      => esc_html__( 'Department', 'ova-dep' ),
				'priority'   => 5,
			) );

			$wp_customize->add_section( 'ova_dep_archive_section' , array(
				'title'      => esc_html__( 'Archive', 'ova-dep' ),
				'priority'   => 30,
				'panel' => 'ova_dep_section',
			) );

			$wp_customize->add_section( 'ova_dep_single_section' , array(
				'title'      => esc_html__( 'Single', 'ova-dep' ),
				'priority'   => 30,
				'panel' => 'ova_dep_section',
			) );


			$wp_customize->add_setting( 'ova_dep_total_record', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 8,
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_dep_total_record', array(
				'label' => esc_html__('Number of posts per page','ova-dep'),
				'section' => 'ova_dep_archive_section',
				'settings' => 'ova_dep_total_record',
				'type' =>'number'
			));

			$wp_customize->add_setting( 'ova_dep_archive_template', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'template1',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name  
			) );

			$wp_customize->add_control('ova_dep_archive_template', array(
				'label' => esc_html__('Template','ova-dep'),
				'section' => 'ova_dep_archive_section',
				'settings' => 'ova_dep_archive_template',
				'type' =>'select',
				'choices' => array(
					'template1'   => esc_html__( 'Template1', 'ova-dep' ),
					'template2'   => esc_html__( 'Template2', 'ova-dep' ),
				)
			));

			$wp_customize->add_setting( 'ova_dep_orderby', array(
				'type' 					=> 'theme_mod', // or 'option'
				'capability' 			=> 'edit_theme_options',
				'theme_supports' 		=> '', // Rarely needed.
				'default' 				=> 'sort_order',
				'transport' 			=> 'refresh', // or postMessage
				'sanitize_callback' 	=> 'sanitize_text_field' // Get function name  
			) );

			$wp_customize->add_control('ova_dep_orderby', array(
				'label' 	=> esc_html__('Orderby','ova-dep'),
				'section' 	=> 'ova_dep_archive_section',
				'settings' 	=> 'ova_dep_orderby',
				'type' 		=>'select',
				'choices' 	=> array(
					'sort_order' 	=> esc_html__( 'Sort Order', 'ova-dep' ),
					'ID' 			=> esc_html__( 'ID', 'ova-dep' ),
					'title' 		=> esc_html__( 'Title', 'ova-dep' ),
					'date' 			=> esc_html__( 'Date', 'ova-dep' ),
					'rand' 			=> esc_html__( 'Random', 'ova-dep' ),
				)
			));

			$wp_customize->add_setting( 'ova_dep_order', array(
				  'type' 				=> 'theme_mod', // or 'option'
				  'capability' 			=> 'edit_theme_options',
				  'theme_supports' 		=> '', // Rarely needed.
				  'default' 			=> 'ASC',
				  'transport' 			=> 'refresh', // or postMessage
				  'sanitize_callback' 	=> 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_dep_order', array(
				'label' 	=> esc_html__('Order','ova-dep'),
				'section' 	=> 'ova_dep_archive_section',
				'settings' 	=> 'ova_dep_order',
				'type' 		=>'select',
				'choices' 	=> array(
					'ASC' 	=> esc_html__( 'Ascending', 'ova-dep' ),
					'DESC' 	=> esc_html__( 'Descending', 'ova-dep' ),
				)
			));

			$wp_customize->add_setting( 'ova_dep_layout', array(
				  'type' => 'theme_mod', // or 'option'
				  'capability' => 'edit_theme_options',
				  'theme_supports' => '', // Rarely needed.
				  'default' => 'four_column',
				  'transport' => 'refresh', // or postMessage
				  'sanitize_callback' => 'sanitize_text_field' // Get function name  
			) );

			$wp_customize->add_control('ova_dep_layout', array(
				'label' => esc_html__('Layout','ova-dep'),
				'section' => 'ova_dep_archive_section',
				'settings' => 'ova_dep_layout',
				'type' =>'select',
				'choices' => array(
					'two_column'    => esc_html__( '2 column', 'ova-dep' ),
					'three_column'  => esc_html__( '3 column', 'ova-dep' ),
					'four_column'   => esc_html__( '4 column', 'ova-dep' ),
				)
			));

			$wp_customize->add_setting( 'header_archive_dep', array(
			  	'type' => 'theme_mod', // or 'option'
			  	'capability' => 'edit_theme_options',
			  	'theme_supports' => '', // Rarely needed.
			  	'default' => 'default',
			  	'transport' => 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('header_archive_dep', array(
				'label' => esc_html__('Header Archive','ova-dep'),
				'section' => 'ova_dep_archive_section',
				'settings' => 'header_archive_dep',
				'type' =>'select',
				'choices' => apply_filters('gimont_list_header', '')
			));

			$wp_customize->add_setting( 'archive_footer_dep', array(
			  'type' => 'theme_mod', // or 'option'
			  'capability' => 'edit_theme_options',
			  'theme_supports' => '', // Rarely needed.
			  'default' => 'default',
			  'transport' => 'refresh', // or postMessage
			  'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('archive_footer_dep', array(
				'label' => esc_html__('Footer Archive','ova-dep'),
				'section' => 'ova_dep_archive_section',
				'settings' => 'archive_footer_dep',
				'type' =>'select',
				'choices' => apply_filters('gimont_list_footer', '')
			));

			$wp_customize->add_setting( 'ova_dep_show_search_name', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name  
			) );

			$wp_customize->add_control('ova_dep_show_search_name', array(
				'label' => esc_html__('Show Search by Name','ova-dep'),
				'section' => 'ova_dep_archive_section',
				'settings' => 'ova_dep_show_search_name',
				'type' =>'select',
				'choices' => array(
					'yes'   => esc_html__( 'Yes', 'ova-dep' ),
					'no'    => esc_html__( 'No', 'ova-dep' ),
				)
			));

			$wp_customize->add_setting( 'ova_dep_show_search_category', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name  
			) );

			$wp_customize->add_control('ova_dep_show_search_category', array(
				'label' => esc_html__('Show Search by Category','ova-dep'),
				'section' => 'ova_dep_archive_section',
				'settings' => 'ova_dep_show_search_category',
				'type' =>'select',
				'choices' => array(
					'yes'   => esc_html__( 'Yes', 'ova-dep' ),
					'no'    => esc_html__( 'No', 'ova-dep' ),
				)
			));

			$wp_customize->add_setting( 'ova_dep_archive_show_thumbnail', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name  
			) );

			$wp_customize->add_control('ova_dep_archive_show_thumbnail', array(
				'label' => esc_html__('Show Thumbnail','ova-dep'),
				'section' => 'ova_dep_archive_section',
				'settings' => 'ova_dep_archive_show_thumbnail',
				'type' =>'select',
				'choices' => array(
					'yes'   => esc_html__( 'Yes', 'ova-dep' ),
					'no'    => esc_html__( 'No', 'ova-dep' ),
				)
			));

			$wp_customize->add_setting( 'ova_dep_archive_show_icon', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name  
			) );

			$wp_customize->add_control('ova_dep_archive_show_icon', array(
				'label' => esc_html__('Show Icon','ova-dep'),
				'section' => 'ova_dep_archive_section',
				'settings' => 'ova_dep_archive_show_icon',
				'type' =>'select',
				'choices' => array(
					'yes'   => esc_html__( 'Yes', 'ova-dep' ),
					'no'    => esc_html__( 'No', 'ova-dep' ),
				)
			));

			$wp_customize->add_setting( 'ova_dep_archive_show_title', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name  
			) );

			$wp_customize->add_control('ova_dep_archive_show_title', array(
				'label' => esc_html__('Show Title','ova-dep'),
				'section' => 'ova_dep_archive_section',
				'settings' => 'ova_dep_archive_show_title',
				'type' =>'select',
				'choices' => array(
					'yes'   => esc_html__( 'Yes', 'ova-dep' ),
					'no'    => esc_html__( 'No', 'ova-dep' ),
				)
			));

			$wp_customize->add_setting( 'ova_dep_archive_show_excerpt', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name  
			) );

			$wp_customize->add_control('ova_dep_archive_show_excerpt', array(
				'label' => esc_html__('Show Excerpt','ova-dep'),
				'section' => 'ova_dep_archive_section',
				'settings' => 'ova_dep_archive_show_excerpt',
				'type' =>'select',
				'choices' => array(
					'yes'   => esc_html__( 'Yes', 'ova-dep' ),
					'no'    => esc_html__( 'No', 'ova-dep' ),
				)
			));

			$wp_customize->add_setting( 'ova_dep_archive_show_readmore', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name  
			) );

			$wp_customize->add_control('ova_dep_archive_show_readmore', array(
				'label' => esc_html__('Show Read More','ova-dep'),
				'section' => 'ova_dep_archive_section',
				'settings' => 'ova_dep_archive_show_readmore',
				'type' =>'select',
				'choices' => array(
					'yes'   => esc_html__( 'Yes', 'ova-dep' ),
					'no'    => esc_html__( 'No', 'ova-dep' ),
				),
				'active_callback' => array( $this, 'is_archive_control_visible' ),
			));

			// Single
			$wp_customize->add_setting( 'ova_dep_single_sidebar', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'right_sidebar',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_dep_single_sidebar', array(
				'label' => esc_html__('Sidebar','ova-dep'),
				'section' => 'ova_dep_single_section',
				'settings' => 'ova_dep_single_sidebar',
				'type' =>'select',
				'choices' => array(
					'right_sidebar'   => esc_html__( 'Right Sidebar', 'ova-dep' ),
					'left_sidebar'    => esc_html__( 'Left Sidebar', 'ova-dep' ),
					'no_sidebar'      => esc_html__( 'No Sidebar', 'ova-dep' ),
				)
			));

			$wp_customize->add_setting( 'header_single_dep', array(
			  	'type' => 'theme_mod', // or 'option'
			  	'capability' => 'edit_theme_options',
			  	'theme_supports' => '', // Rarely needed.
			  	'default' => 'default',
			  	'transport' => 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('header_single_dep', array(
				'label' => esc_html__('Header Single','ova-dep'),
				'section' => 'ova_dep_single_section',
				'settings' => 'header_single_dep',
				'type' =>'select',
				'choices' => apply_filters('gimont_list_header', '')
			));

			$wp_customize->add_setting( 'single_footer_dep', array(
			  	'type' => 'theme_mod', // or 'option'
			  	'capability' => 'edit_theme_options',
			  	'theme_supports' => '', // Rarely needed.
			  	'default' => 'default',
			  	'transport' => 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('single_footer_dep', array(
				'label' => esc_html__('Footer Single','ova-dep'),
				'section' => 'ova_dep_single_section',
				'settings' => 'single_footer_dep',
				'type' =>'select',
				'choices' => apply_filters('gimont_list_footer', '')
			));

			$wp_customize->add_setting( 'ova_dep_single_show_share', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name  
			) );

			$wp_customize->add_control('ova_dep_single_show_share', array(
				'label' => esc_html__('Show Share Social','ova-dep'),
				'section' => 'ova_dep_single_section',
				'settings' => 'ova_dep_single_show_share',
				'type' =>'select',
				'choices' => array(
					'yes'   => esc_html__( 'Yes', 'ova-dep' ),
					'no'    => esc_html__( 'No', 'ova-dep' ),
				)
			));

			$wp_customize->add_setting( 'ova_dep_single_show_comment', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name  
			) );

			$wp_customize->add_control('ova_dep_single_show_comment', array(
				'label' => esc_html__('Show Comment','ova-dep'),
				'section' => 'ova_dep_single_section',
				'settings' => 'ova_dep_single_show_comment',
				'type' =>'select',
				'choices' => array(
					'yes'   => esc_html__( 'Yes', 'ova-dep' ),
					'no'    => esc_html__( 'No', 'ova-dep' ),
				)
			));


		}

		// Define the callback function
		public function is_archive_control_visible() {
		    return get_theme_mod( 'ova_dep_archive_template', 'template1' ) === 'template2';
		}

	}

}

new Ova_Dep_Customize();