<?php

if ( !defined( 'ABSPATH' ) ) {
	exit;
}

add_action( 'pre_get_posts', 'ova_dir_post_per_page_archive' );

function ova_dir_post_per_page_archive( $query ) {

	if ( ! is_admin() && $query->is_main_query() ) {

		if ( is_post_type_archive( 'ova_dir' ) || is_tax('cat_dir') || is_tax('tag_dir')  ) {

			if( $query->is_post_type_archive( 'ova_dir' ) || $query->is_tax('cat_dir') || $query->is_tax('tag_dir') ) {
				$query->set('post_type', array( 'ova_dir' ) );
				$query->set('posts_per_page', get_theme_mod( 'ova_dir_total_record', 8 ) );

				$orderby 	= get_theme_mod( 'ova_dir_orderby', 'title' );
				$order 		= get_theme_mod( 'ova_dir_order', 'ASC' );

				$query->set('order', $order );

				if ( $orderby === 'ova_dir_met_order_dir' ) {
					$query->set('orderby', 'meta_value_num' );
					$query->set('meta_type', 'NUMERIC' );
					$query->set('meta_key', 'ova_dir_met_order_dir' );
				} else {
					$query->set('orderby', $orderby );
				}
			}

		}

	}

}

function ova_dir_get_child_cate( $parent_id, $term_ids){
	if (! $parent_id) {
		return;
	}
	$args = array(
		'taxonomy' 		=> 'cat_dir',
		'orderby' 		=> 'name',
		'order'   		=> 'ASC',
		'hide_empty' 	=> false,
		'parent' 		=> $parent_id,
	);
	$id 				= get_the_ID();
	$term_id 			= get_queried_object_id();
	$child_categories 	= get_categories( $args );

	if ( $child_categories ) { ?>
		<ul class="child-cate">
			<?php foreach ($child_categories as $child) {
				$active_class = $child->term_id == $term_id ? 'active' : '';
				if ( $id ) {
					$active_class = in_array( $child->term_id, $term_ids) ? 'active' : '';
				}
			?>
				<li class="item">
					<a href="<?php echo esc_url( get_term_link( $child ) ); ?>"
						class="item-link <?php echo esc_attr( $active_class ); ?>"
						data-slug="<?php echo esc_attr( $child->slug ); ?>"
						title="<?php echo esc_attr( $child->name ); ?>">
						<span class="cate_name"><?php echo esc_html( $child->name ); ?></span>
						<?php if (get_term_children( $child->term_id, 'cat_dir' ) ): ?>
							<i class="fas fa-plus"></i>
						<?php endif; ?>
					</a>
					<?php ova_dir_get_child_cate( $child->term_id, $term_ids); ?>
				</li>
			<?php } ?>
		</ul>
	<?php }
}

if ( ! function_exists('ova_dir_get_properties') ) {
	function ova_dir_get_properties( $the_query ){
		$properties = array();
		if ( $the_query->have_posts() ) {
			while ( $the_query->have_posts() ) {
				$the_query->the_post();

				$latitude 		= get_post_meta( get_the_ID(), 'ova_dir_met_latitude', true );
				$longitude 		= get_post_meta( get_the_ID(), 'ova_dir_met_longitude', true );
				$address 		= get_post_meta( get_the_ID(), 'ova_dir_met_address', true );
				$marker_img 	= get_post_meta( get_the_ID(), 'ova_dir_met_marker_img', true );
				$terms 			= get_the_terms( get_the_ID(), 'cat_dir' );
				$image_id 		= get_post_thumbnail_id( get_the_ID() );
				$image_alt 		= get_post_meta($image_id, '_wp_attachment_image_alt', true);
				$image_title 	= get_the_title($image_id);
				if ( ! $image_alt ) {
					$image_alt = $image_title;
				}

				$directory = [];
				$directory['title'] 	= get_the_title(); 
				$directory['thumbnail'] = get_the_post_thumbnail_url( get_the_ID(), 'gimont_medium' );
				$directory['thumb_sml'] = get_the_post_thumbnail_url( get_the_ID(), 'thumbnail' );
				$directory['image_alt'] = $image_alt;
				$directory['url'] 		= get_permalink();
				$directory['address'] 	= $address;
				$directory['position'] 	= array(
					'lat' => $latitude,
					'lng' => $longitude,
				);

				if( $marker_img && !empty($marker_img)) {
					$directory['thumb_sml'] = $marker_img; 
				}

				if ( $terms ) {
					$term_data = array();
					foreach ($terms as $key => $term) {
						$new_term = array(
							'name' 		=> $term->name,
							'url'	 	=> get_term_link( $term ),
						);
						array_push( $term_data, $new_term );
					}
					$directory['terms'] = $term_data;
				}
				array_push( $properties, $directory );
			}
		}
		return $properties;
	}
}

function ova_dir_query($args) {
	$order_by 		= $args['order_by'];
	$order 			= $args['order'];
	$posts_per_page = $args['posts_per_page'];
	$cate 			= $args['cate'];

	$wp_args = array(
		'post_type' 		=> 'ova_dir',
		'post_status' 		=> 'publish',
		'order' 			=> $order,
		'orderby' 			=> $order_by,
		'posts_per_page' 	=> $posts_per_page,
	);

	if ( array_key_exists('offset', $args) ) {
		if ($args['offset'] != -1) {
			$wp_args['offset'] = $args['offset'];
		}
	}

	if ($cate != '0') {
		$wp_args['tax_query'] = array(
			array(
				'taxonomy'         => 'cat_dir',
				'field'            => 'id',
				'terms'            => $cate,
				'include_children' => true,
				'operator'         => 'IN',
			),
		);
	}

	return new WP_Query( $wp_args );
}

if ( ! function_exists('ova_dir_get_items') ) {
	function ova_dir_get_items( $the_query, $args_show ){
		$use_gg_map = get_theme_mod('ova_dir_use_google_map','yes');

		if($use_gg_map == 'yes'){
			$zoom 		= get_theme_mod( 'ova_dir_archive_zoom', 3 );
			$latitude 	= get_theme_mod( 'ova_dir_latitude', 39.177972 );
			$longitude 	= get_theme_mod( 'ova_dir_longitude', -100.36375 );

			$data_map 	= array(
				'latitude' 	=> $latitude,
				'longitude' => $longitude,
				'zoom'		=> $zoom,
			);
			$data_properties = ova_dir_get_properties( $the_query );
		}

		// show fields
		$show_map 		 = isset($args_show['show_map']) ? $args_show['show_map'] : 'yes';
		$show_image 	 = isset($args_show['show_image']) ? $args_show['show_image'] : 'yes';
		$show_title 	 = isset($args_show['show_title']) ? $args_show['show_title'] : 'yes';
		$show_location   = isset($args_show['show_location']) ? $args_show['show_location'] : 'yes';
		$show_category   = isset($args_show['show_category']) ? $args_show['show_category'] : 'yes';
		$show_short_desc = isset($args_show['show_short_desc']) ? $args_show['show_short_desc'] : 'yes';
		$show_link_to    = isset($args_show['show_link_to']) ? $args_show['show_link_to'] : 'yes';
	?>

		<?php if ( $show_map == 'yes' && $use_gg_map == 'yes' ): ?>
			<div id="el_ova_dir_archive_google_map" 
				data-map="<?php echo esc_attr( json_encode( $data_map ) ); ?>" 
				data-properties="<?php echo esc_attr( json_encode( $data_properties ) ); ?>"
			>
			</div>
		<?php endif; ?>

		<div class="ova-dir-items">
			<?php if( $the_query->have_posts() ) : while( $the_query->have_posts() ) : $the_query->the_post();
				$post_id = get_the_ID();
				$address 		= get_post_meta( $post_id, 'ova_dir_met_address', true );
				$short_address  = get_post_meta( $post_id, 'ova_dir_met_short_address', true );

				if( !empty($short_address) ) {
					$address = $short_address;
				}
			?>
				<div class="item">
					<?php if ( has_post_thumbnail() && $show_image == 'yes' ): ?>
						<?php if ( $show_link_to == 'yes' ): ?>
							<a href="<?php the_permalink(); ?>" class="thumbnail" title="<?php the_title(); ?>">
								<?php the_post_thumbnail( 'gimont_medium' ); ?>
							</a>
						<?php else: ?>
							<div class="thumbnail">
								<?php the_post_thumbnail( 'gimont_medium' ); ?>
							</div>
						<?php endif; ?>
					<?php endif; ?>

					<div class="content">
						<?php if ( $show_title == 'yes' ): ?>
							<?php if ( $show_link_to == 'yes' ): ?>
								<a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
							<?php endif; ?>
								<h2 class="title">
									<?php the_title(); ?>	
								</h2>
							<?php if ( $show_link_to == 'yes' ): ?>
								</a>
							<?php endif; ?>
						<?php endif; ?>

						<?php if ( $show_short_desc == 'yes' ): ?>
							<p class="description">
								<?php echo wp_trim_words(get_the_excerpt(),12,'..'); ?>
							</p>
						<?php endif; ?>

						<?php if ( $show_location == 'yes' || $show_category == 'yes' ): ?>
							<ul class="info">
								<?php if ( $address && $show_location == 'yes' ): ?>
									<li>
										<i class="fas fa-map-marker-alt" aria-hidden="true"></i>
										<div class="text">
											<?php echo esc_html( $address ); ?>
										</div>
									</li>
								<?php endif; ?>
								<?php if ( $show_category == 'yes' ): ?>
								<li>
									<i class="far fa-folder" aria-hidden="true"></i>
									<div class="text"><?php the_terms( $post_id, 'cat_dir' ); ?></div>
								</li>
								<?php endif; ?>
							</ul>
						<?php endif; ?>
					</div>
				</div>
			<?php endwhile; endif; wp_reset_postdata(); ?>
		</div>

	<?php }
}

if ( ! function_exists('ova_dir_get_items_archive') ) {
	function ova_dir_get_items_archive( $the_query, $args_show ){
		$use_gg_map = get_theme_mod('ova_dir_use_google_map','yes');

		if($use_gg_map == 'yes'){
			$zoom 		= get_theme_mod( 'ova_dir_archive_zoom', 3 );
			$latitude 	= get_theme_mod( 'ova_dir_latitude', 39.177972 );
			$longitude 	= get_theme_mod( 'ova_dir_longitude', -100.36375 );

			$data_map 	= array(
				'latitude' 	=> $latitude,
				'longitude' => $longitude,
				'zoom'		=> $zoom,
			);
			$data_properties = ova_dir_get_properties( $the_query );
		}

		// show fields
		$show_map 		= isset($args_show['show_map']) ? $args_show['show_map'] : 'yes';
		$show_image 	= isset($args_show['show_image']) ? $args_show['show_image'] : 'yes';
		$show_title 	= isset($args_show['show_title']) ? $args_show['show_title'] : 'yes';
		$show_location  = isset($args_show['show_location']) ? $args_show['show_location'] : 'yes';
		$show_category  = isset($args_show['show_category']) ? $args_show['show_category'] : 'yes';
		$show_link_to   = isset($args_show['show_link_to']) ? $args_show['show_link_to'] : 'yes';
	?>

		<?php if ( $show_map == 'yes' && $use_gg_map == 'yes' ): ?>
			<div id="ova_dir_archive_google_map" 
				data-map="<?php echo esc_attr( json_encode( $data_map ) ); ?>" 
				data-properties="<?php echo esc_attr( json_encode( $data_properties ) ); ?>"
			>
			</div>
		<?php endif; ?>


		<div class="ova-dir-items">
			<?php if( $the_query->have_posts() ) : while( $the_query->have_posts() ) : $the_query->the_post();
				$post_id = get_the_ID();
				$address 		= get_post_meta( $post_id, 'ova_dir_met_address', true );
				$short_address  = get_post_meta( $post_id, 'ova_dir_met_short_address', true );

				if( !empty($short_address) ) {
					$address = $short_address;
				}
			?>
				<div class="item">
					<?php if ( has_post_thumbnail() && $show_image == 'yes' ): ?>
						<?php if ( $show_link_to == 'yes' ): ?>
							<a href="<?php the_permalink(); ?>" class="thumbnail" title="<?php the_title(); ?>">
								<?php the_post_thumbnail( 'gimont_medium' ); ?>
							</a>
						<?php else: ?>
							<div class="thumbnail">
								<?php the_post_thumbnail( 'gimont_medium' ); ?>
							</div>
						<?php endif; ?>
					<?php endif; ?>

					<div class="content">
						<?php if ( $show_title == 'yes' ): ?>
							<?php if ( $show_link_to == 'yes' ): ?>
								<a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
							<?php endif; ?>
								<h2 class="title">
									<?php the_title(); ?>	
								</h2>
							<?php if ( $show_link_to == 'yes' ): ?>
								</a>
							<?php endif; ?>
						<?php endif; ?>

						<?php if ( $show_location == 'yes' || $show_category == 'yes' ): ?>
							<ul class="info">
								<?php if ( $address && $show_location == 'yes' ): ?>
									<li>
										<i class="fas fa-map-marker-alt" aria-hidden="true"></i>
										<div class="text">
											<?php echo esc_html( $address ); ?>
										</div>
									</li>
								<?php endif; ?>
								<?php if ( $show_category == 'yes' ): ?>
								<li>
									<i class="far fa-folder" aria-hidden="true"></i>
									<div class="text"><?php the_terms( $post_id, 'cat_dir' ); ?></div>
								</li>
								<?php endif; ?>
							</ul>
						<?php endif; ?>
					</div>
				</div>
			<?php endwhile; endif; wp_reset_postdata(); ?>
		</div>

	<?php }
}

function ova_dir_pagination_ajax($total_pages,$curent_page,$posts_per_page,$args){
	if ( $total_pages > 1 ) :
		$page_num_arr = range(1, $total_pages);
	?>
	<div class="ova_dir_pagination_ajax"
		data-args="<?php echo esc_attr( json_encode( $args ) ); ?>">
		<nav class="navigation pagination">
			<div class="nav-links">
				<ul class="page-numbers">
					<?php if ( $curent_page > 1 ): ?>
						<?php $offset = $posts_per_page * ( max( $curent_page - 1, 1) - 1) == 0 ? -1 : $posts_per_page * ( max( $curent_page - 1, 1) - 1); ?>
						<li>
							<a class="prev page-numbers" href="#"
								aria-label="<?php esc_attr_e('Previous Page', 'ova-dir'); ?>"
								data-offset="<?php echo esc_attr( $offset ); ?>"
								data-page="<?php echo esc_attr( max( $curent_page - 1, 1) ); ?>">
								<i class="ovaicon-back"></i>
							</a>
						</li>
					<?php endif;

					$first_item = max( $curent_page - 1, 1 );
					$last_item = min( $curent_page + 1, $total_pages );
					if ($curent_page == 1) {
						$last_item = min( $curent_page + 2, $total_pages );
					}
					if ($curent_page == $total_pages) {
						$first_item = max( $curent_page - 2, 1 );
					}
					$sub_page_num_arr = range( $first_item, $last_item );

					foreach ( $sub_page_num_arr as $page_number ): ?>
						<li>
							<?php if ( $curent_page == $page_number ): ?>
								<span aria-current="page" class="page-numbers current">
									<?php echo esc_html( $page_number ); ?>
								</span>
							<?php else: ?>
							<?php
								$offset = $posts_per_page * ($page_number - 1) == 0 ? -1 : $posts_per_page * ($page_number - 1);
							?>
							<a href="#" class="page-numbers"
								data-offset="<?php echo esc_attr( $offset ); ?>"
								data-page="<?php echo esc_attr( $page_number ); ?>">
								<?php echo esc_html( $page_number ); ?>
							</a>
							<?php endif; ?>
						</li>
					<?php endforeach; ?>

					<?php if ( $curent_page < $total_pages ): ?>
						<li>
							<a class="next page-numbers" href="#"
								aria-label="<?php esc_attr_e('Next Page', 'ova-dir'); ?>"
								data-offset="<?php echo esc_attr( $posts_per_page * ( min( $curent_page + 1, $total_pages) - 1) ); ?>"
								data-page="<?php echo esc_attr( min( $curent_page + 1, $total_pages) ); ?>"
							>
								<i class="ovaicon-next"></i>
							</a>
						</li>
					<?php endif; ?>

				</ul>
			</div>
		</nav>
	</div>
<?php endif;
}