<?php

if (!defined( 'ABSPATH' )) {
	exit;
}
if (!class_exists( 'Ova_Doc_Customize' )){

	class Ova_Doc_Customize {

		public function __construct() {
			add_action( 'customize_register', array( $this, 'ova_doc_customize_register' ) );
		}

		public function ova_doc_customize_register($wp_customize) {

			$this->ova_doc_init( $wp_customize );

			do_action( 'ova_doc_customize_register', $wp_customize );
		}


		/* Doc */
		public function ova_doc_init( $wp_customize ){

			$wp_customize->add_panel( 'ova_doc_panel', array(
			  	'title' => esc_html__( 'Document', 'ova-doc' ),
			  	'priority' => 5,
			) );

			$wp_customize->add_section( 'ova_doc_archive_section' , array(
				'title'      => esc_html__( 'Archive', 'ova-doc' ),
				'priority'   => 30,
				'panel' => 'ova_doc_panel',
			) );

			$wp_customize->add_section( 'ova_doc_single_section' , array(
				'title'      => esc_html__( 'Single', 'ova-doc' ),
				'priority'   => 30,
				'panel' => 'ova_doc_panel',
			) );


			$wp_customize->add_setting( 'ova_doc_total_record', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 8,
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_doc_total_record', array(
				'label' => esc_html__('Number of posts per page','ova-doc'),
				'section' => 'ova_doc_archive_section',
				'settings' => 'ova_doc_total_record',
				'type' =>'number'
			));

			$wp_customize->add_setting( 'ova_doc_orderby', array(
				'type' 				=> 'theme_mod', // or 'option'
				'capability' 		=> 'edit_theme_options',
				'theme_supports' 	=> '', // Rarely needed.
				'default' 			=> 'ID',
				'transport' 		=> 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			));

			$wp_customize->add_control('ova_doc_orderby', array(
				'label' 	=> esc_html__('Order By','ova-doc'),
				'section' 	=> 'ova_doc_archive_section',
				'settings' 	=> 'ova_doc_orderby',
				'type' 		=>'select',
				'choices' 	=> array(
					'ova_doc_met_order_doc' 	=> esc_html__( 'Sort Order', 'ova-doc' ),
					'ova_doc_met_publish_date' 	=> esc_html__( 'Published Date', 'ova-doc' ),
					'ID' 						=> esc_html__( 'ID', 'ova-doc' ),
					'title' 					=> esc_html__( 'Title', 'ova-doc' ),
					'date' 						=> esc_html__( 'Date', 'ova-doc' ),
					'rand' 						=> esc_html__( 'Random', 'ova-doc' ),
				)
			));

			$wp_customize->add_setting( 'ova_doc_order', array(
				'type' 				=> 'theme_mod', // or 'option'
				'capability' 		=> 'edit_theme_options',
				'theme_supports' 	=> '', // Rarely needed.
				'default' 			=> 'DESC',
				'transport' 		=> 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			));

			$wp_customize->add_control('ova_doc_order', array(
				'label' 	=> esc_html__('Order','ova-doc'),
				'section' 	=> 'ova_doc_archive_section',
				'settings' 	=> 'ova_doc_order',
				'type' 		=>'select',
				'choices' 	=> array(
					'ASC' 	=> esc_html__( 'Ascending', 'ova-doc' ),
					'DESC' 	=> esc_html__( 'Descending', 'ova-doc' ),
				)
			));

			$wp_customize->add_setting( 'ova_doc_layout', array(
				  'type' => 'theme_mod', // or 'option'
				  'capability' => 'edit_theme_options',
				  'theme_supports' => '', // Rarely needed.
				  'default' => 'two_column',
				  'transport' => 'refresh', // or postMessage
				  'sanitize_callback' => 'sanitize_text_field' // Get function name 
				  
				) );
			$wp_customize->add_control('ova_doc_layout', array(
				'label' => esc_html__('Layout','ova-doc'),
				'section' => 'ova_doc_archive_section',
				'settings' => 'ova_doc_layout',
				'type' =>'select',
				'choices' => array(
					'one_column'   => esc_html__( '1 Column', 'ova-doc' ),
					'two_column'   => esc_html__( '2 Columns', 'ova-doc' ),
					'three_column' => esc_html__( '3 Columns', 'ova-doc' ),
				)
			));

			$wp_customize->add_setting( 'ova_doc_archive_sidebar', array(
				  'type' => 'theme_mod', // or 'option'
				  'capability' => 'edit_theme_options',
				  'theme_supports' => '', // Rarely needed.
				  'default' => 'left_sidebar',
				  'transport' => 'refresh', // or postMessage
				  'sanitize_callback' => 'sanitize_text_field' // Get function name 
				  
				) );

			$wp_customize->add_control('ova_doc_archive_sidebar', array(
				'label' => esc_html__('Sidebar','ova-doc'),
				'section' => 'ova_doc_archive_section',
				'settings' => 'ova_doc_archive_sidebar',
				'type' =>'select',
				'choices' => array(
					'left_sidebar'    	=> esc_html__( 'Left Sidebar', 'ova-doc' ),
					'right_sidebar'    	=> esc_html__( 'Right Sidebar', 'ova-doc' ),
					'no_sidebar'      	=> esc_html__( 'No Sidebar', 'ova-doc' ),
				)
			));

			$wp_customize->add_setting( 'ova_doc_archive_show_search_name', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name  
			) );

			$wp_customize->add_control('ova_doc_archive_show_search_name', array(
				'label' => esc_html__('Show Search by Name','ova-doc'),
				'section' => 'ova_doc_archive_section',
				'settings' => 'ova_doc_archive_show_search_name',
				'type' =>'select',
				'choices' => array(
					'yes'   => esc_html__( 'Yes', 'ova-doc' ),
					'no'    => esc_html__( 'No', 'ova-doc' ),
				)
			));

			$wp_customize->add_setting( 'ova_doc_archive_show_search_date', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name  
			) );

			$wp_customize->add_control('ova_doc_archive_show_search_date', array(
				'label' => esc_html__('Show Search by Date','ova-doc'),
				'section' => 'ova_doc_archive_section',
				'settings' => 'ova_doc_archive_show_search_date',
				'type' =>'select',
				'choices' => array(
					'yes'   => esc_html__( 'Yes', 'ova-doc' ),
					'no'    => esc_html__( 'No', 'ova-doc' ),
				)
			));

			$wp_customize->add_setting( 'ova_doc_archive_show_search_category', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name  
			) );

			$wp_customize->add_control('ova_doc_archive_show_search_category', array(
				'label' => esc_html__('Show Search by Category','ova-doc'),
				'section' => 'ova_doc_archive_section',
				'settings' => 'ova_doc_archive_show_search_category',
				'type' =>'select',
				'choices' => array(
					'yes'   => esc_html__( 'Yes', 'ova-doc' ),
					'no'    => esc_html__( 'No', 'ova-doc' ),
				)
			));


			$wp_customize->add_setting( 'ova_doc_archive_show_date', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name  
			) );

			$wp_customize->add_control('ova_doc_archive_show_date', array(
				'label' => esc_html__('Show Date','ova-doc'),
				'section' => 'ova_doc_archive_section',
				'settings' => 'ova_doc_archive_show_date',
				'type' =>'select',
				'choices' => array(
					'yes'   => esc_html__( 'Yes', 'ova-doc' ),
					'no'    => esc_html__( 'No', 'ova-doc' ),
				)
			));

			$wp_customize->add_setting( 'ova_doc_archive_show_title', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name  
			) );

			$wp_customize->add_control('ova_doc_archive_show_title', array(
				'label' => esc_html__('Show Title','ova-doc'),
				'section' => 'ova_doc_archive_section',
				'settings' => 'ova_doc_archive_show_title',
				'type' =>'select',
				'choices' => array(
					'yes'   => esc_html__( 'Yes', 'ova-doc' ),
					'no'    => esc_html__( 'No', 'ova-doc' ),
				)
			));

			$wp_customize->add_setting( 'ova_doc_archive_show_link_of_title', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name  
			) );

			$wp_customize->add_control('ova_doc_archive_show_link_of_title', array(
				'label' => esc_html__('Show Link of Title','ova-doc'),
				'section' => 'ova_doc_archive_section',
				'settings' => 'ova_doc_archive_show_link_of_title',
				'type' =>'select',
				'choices' => array(
					'yes'   => esc_html__( 'Yes', 'ova-doc' ),
					'no'    => esc_html__( 'No', 'ova-doc' ),
				)
			));

			$wp_customize->add_setting( 'ova_doc_archive_show_view_icon', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name  
			) );

			$wp_customize->add_control('ova_doc_archive_show_view_icon', array(
				'label' => esc_html__('Show View Icon','ova-doc'),
				'section' => 'ova_doc_archive_section',
				'settings' => 'ova_doc_archive_show_view_icon',
				'type' =>'select',
				'choices' => array(
					'yes'   => esc_html__( 'Yes', 'ova-doc' ),
					'no'    => esc_html__( 'No', 'ova-doc' ),
				)
			));

			$wp_customize->add_setting( 'ova_doc_archive_show_download_icon', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name  
			) );

			$wp_customize->add_control('ova_doc_archive_show_download_icon', array(
				'label' => esc_html__('Show Download Icon','ova-doc'),
				'section' => 'ova_doc_archive_section',
				'settings' => 'ova_doc_archive_show_download_icon',
				'type' =>'select',
				'choices' => array(
					'yes'   => esc_html__( 'Yes', 'ova-doc' ),
					'no'    => esc_html__( 'No', 'ova-doc' ),
				)
			));

			// Single
			$wp_customize->add_setting( 'ova_doc_single_sidebar', array(
				  'type' => 'theme_mod', // or 'option'
				  'capability' => 'edit_theme_options',
				  'theme_supports' => '', // Rarely needed.
				  'default' => 'left_sidebar',
				  'transport' => 'refresh', // or postMessage
				  'sanitize_callback' => 'sanitize_text_field' // Get function name 
				  
				) );

			$wp_customize->add_control('ova_doc_single_sidebar', array(
				'label' => esc_html__('Sidebar','ova-doc'),
				'section' => 'ova_doc_single_section',
				'settings' => 'ova_doc_single_sidebar',
				'type' =>'select',
				'choices' => array(
					'left_sidebar'    	=> esc_html__( 'Left Sidebar', 'ova-doc' ),
					'right_sidebar'    	=> esc_html__( 'Right Sidebar', 'ova-doc' ),
					'no_sidebar'      	=> esc_html__( 'No Sidebar', 'ova-doc' ),
				)
			));

			$wp_customize->add_setting( 'header_archive_doc', array(
			  'type' => 'theme_mod', // or 'option'
			  'capability' => 'edit_theme_options',
			  'theme_supports' => '', // Rarely needed.
			  'default' => 'default',
			  'transport' => 'refresh', // or postMessage
			  'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('header_archive_doc', array(
				'label' => esc_html__('Header','ova-doc'),
				'section' => 'ova_doc_archive_section',
				'settings' => 'header_archive_doc',
				'type' =>'select',
				'choices' => apply_filters('gimont_list_header', '')
			));

			$wp_customize->add_setting( 'archive_footer_doc', array(
			  	'type' => 'theme_mod', // or 'option'
			  	'capability' => 'edit_theme_options',
			  	'theme_supports' => '', // Rarely needed.
			  	'default' => 'default',
			  	'transport' => 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('archive_footer_doc', array(
				'label' => esc_html__('Footer','ova-doc'),
				'section' => 'ova_doc_archive_section',
				'settings' => 'archive_footer_doc',
				'type' =>'select',
				'choices' => apply_filters('gimont_list_footer', '')
			));

			$wp_customize->add_setting( 'header_single_doc', array(
			  'type' => 'theme_mod', // or 'option'
			  'capability' => 'edit_theme_options',
			  'theme_supports' => '', // Rarely needed.
			  'default' => 'default',
			  'transport' => 'refresh', // or postMessage
			  'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('header_single_doc', array(
				'label' => esc_html__('Header','ova-doc'),
				'section' => 'ova_doc_single_section',
				'settings' => 'header_single_doc',
				'type' =>'select',
				'choices' => apply_filters('gimont_list_header', '')
			));

			$wp_customize->add_setting( 'single_footer_doc', array(
			  'type' => 'theme_mod', // or 'option'
			  'capability' => 'edit_theme_options',
			  'theme_supports' => '', // Rarely needed.
			  'default' => 'default',
			  'transport' => 'refresh', // or postMessage
			  'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('single_footer_doc', array(
				'label' => esc_html__('Footer','ova-doc'),
				'section' => 'ova_doc_single_section',
				'settings' => 'single_footer_doc',
				'type' =>'select',
				'choices' => apply_filters('gimont_list_footer', '')
			));

			$wp_customize->add_setting( 'ova_doc_single_show_date', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name  
			) );

			$wp_customize->add_control('ova_doc_single_show_date', array(
				'label' => esc_html__('Show Date','ova-doc'),
				'section' => 'ova_doc_single_section',
				'settings' => 'ova_doc_single_show_date',
				'type' =>'select',
				'choices' => array(
					'yes'   => esc_html__( 'Yes', 'ova-doc' ),
					'no'    => esc_html__( 'No', 'ova-doc' ),
				)
			));

			$wp_customize->add_setting( 'ova_doc_single_show_category', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name  
			) );

			$wp_customize->add_control('ova_doc_single_show_category', array(
				'label' => esc_html__('Show Category','ova-doc'),
				'section' => 'ova_doc_single_section',
				'settings' => 'ova_doc_single_show_category',
				'type' =>'select',
				'choices' => array(
					'yes'   => esc_html__( 'Yes', 'ova-doc' ),
					'no'    => esc_html__( 'No', 'ova-doc' ),
				)
			));

			$wp_customize->add_setting( 'ova_doc_single_show_title', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name  
			) );

			$wp_customize->add_control('ova_doc_single_show_title', array(
				'label' => esc_html__('Show Title','ova-doc'),
				'section' => 'ova_doc_single_section',
				'settings' => 'ova_doc_single_show_title',
				'type' =>'select',
				'choices' => array(
					'yes'   => esc_html__( 'Yes', 'ova-doc' ),
					'no'    => esc_html__( 'No', 'ova-doc' ),
				)
			));

			$wp_customize->add_setting( 'ova_doc_single_show_content', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name  
			) );

			$wp_customize->add_control('ova_doc_single_show_content', array(
				'label' => esc_html__('Show Content','ova-doc'),
				'section' => 'ova_doc_single_section',
				'settings' => 'ova_doc_single_show_content',
				'type' =>'select',
				'choices' => array(
					'yes'   => esc_html__( 'Yes', 'ova-doc' ),
					'no'    => esc_html__( 'No', 'ova-doc' ),
				)
			));

			$wp_customize->add_setting( 'ova_doc_single_show_files', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name  
			) );

			$wp_customize->add_control('ova_doc_single_show_files', array(
				'label' => esc_html__('Show Attachment Files','ova-doc'),
				'section' => 'ova_doc_single_section',
				'settings' => 'ova_doc_single_show_files',
				'type' =>'select',
				'choices' => array(
					'yes'   => esc_html__( 'Yes', 'ova-doc' ),
					'no'    => esc_html__( 'No', 'ova-doc' ),
				)
			));

			$wp_customize->add_setting( 'ova_doc_single_show_share', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name  
			) );

			$wp_customize->add_control('ova_doc_single_show_share', array(
				'label' => esc_html__('Show Share Social','ova-doc'),
				'section' => 'ova_doc_single_section',
				'settings' => 'ova_doc_single_show_share',
				'type' =>'select',
				'choices' => array(
					'yes'   => esc_html__( 'Yes', 'ova-doc' ),
					'no'    => esc_html__( 'No', 'ova-doc' ),
				)
			));

			$wp_customize->add_setting( 'ova_doc_comments', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_doc_comments', array(
				'label' => esc_html__('Show Comments','ova-doc'),
				'section' => 'ova_doc_single_section',
				'settings' => 'ova_doc_comments',
				'type' =>'select',
				'choices' => array(
					'yes'	=> esc_html__( 'Yes', 'ova-doc' ),
					'no'	=> esc_html__( 'No', 'ova-doc' ),
				)
			));

		}

	}

}

new Ova_Doc_Customize();