<?php defined( 'ABSPATH' ) || exit();

if( !class_exists( 'OVAEV_Admin_Assets' ) ){
	class OVAEV_Admin_Assets{

		public function __construct(){

			add_action( 'admin_footer', array( $this, 'enqueue_scripts' ), 10, 2 );
		}

		public function enqueue_scripts(){

			global $pagenow, $post_type;

			if ( $post_type === 'event' || get_current_screen()->base === 'events_page_ovaev_general_settings' ) {
				wp_enqueue_style( 'ovaev-admin-style', OVAEV_PLUGIN_URI.'assets/css/admin/ovaev-admin-style.css' );
				wp_enqueue_script( 'ovaev-admin-script', OVAEV_PLUGIN_URI.'assets/js/admin/ovaev-admin-script.js', array('jquery','media-upload','thickbox'), false, true );

				// Map
				wp_enqueue_script( 'google','https://maps.googleapis.com/maps/api/js?key='.OVAEV_Settings::google_key_map().'&libraries=places', false, true );

				// Jquery UI
				wp_enqueue_style( 'jquery-ui', OVAEV_PLUGIN_URI.'assets/libs/jquery-ui/jquery-ui.min.css' );
				wp_enqueue_script( 'jquery-ui-tabs' );
			}

			if ( ( $pagenow === 'post-new.php' || $pagenow === 'post.php' ) && $post_type === 'event'  ) {
				wp_enqueue_script('media-upload');
			    wp_enqueue_script('thickbox');

			    wp_enqueue_script('wp-color-picker');
	    		wp_enqueue_style('wp-color-picker');

    			// datetimepicker
				wp_enqueue_style( 'event-datetimepicker', OVAEV_PLUGIN_URI.'assets/libs/datetimepicker/jquery.datetimepicker.css' );
				wp_enqueue_script( 'event-datetimepicker', OVAEV_PLUGIN_URI.'assets/libs/datetimepicker/jquery.datetimepicker.js', array('jquery'), false, true );
				
				// select2
				wp_enqueue_style( 'select2', OVAEV_PLUGIN_URI.'assets/libs/dist/css/select2.min.css', array(), null );
				wp_enqueue_script( 'select2', OVAEV_PLUGIN_URI.'assets/libs/dist/js/select2.min.js', array('jquery'), false, true );
			}
		}
	}

	new OVAEV_Admin_Assets();
}