<?php if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

	$data_event 	= $args['data_posts'];
	$data_carousel 	= $args['data_carousel'];
	$settings 		= $args['settings'];
	$args_show 		= isset($args['args_show']) ? $args['args_show'] : [];
	$layout 		= isset($settings['layout']) ? $settings['layout'] : 2;

	// show fileds
	$args_show = array(
		'show_thumbnail'  => isset($args_show['show_thumbnail']) ? $args_show['show_thumbnail'] : 'yes',
		'show_date' 	  => isset($args_show['show_date']) ? $args_show['show_date'] : 'yes',
		'show_hour' 	  => isset($args_show['show_hour']) ? $args_show['show_hour'] : 'yes',
		'show_location'   => isset($args_show['show_location']) ? $args_show['show_location'] : 'yes',
		'show_title' 	  => isset($args_show['show_title']) ? $args_show['show_title'] : 'yes',
		'show_short_desc' => isset($args_show['show_short_desc']) ? $args_show['show_short_desc'] : 'yes',
		'show_link_to' 	  => isset($args_show['show_link_to']) ? $args_show['show_link_to'] : 'yes',
	);

?>

<?php if( !empty($data_event) ): ?>
	<div class="ovapo_project_grid full_width">
		
		<?php if ($settings['show_filter'] == 'yes') { ?>
			<div class="button-filter container">
				<?php if ($settings['show_all'] == 'yes') { ?>
					<button 
						data-filter="all" 
						data-order="<?php echo esc_attr($settings['order_post']); ?>" 
						data-orderby="<?php echo esc_attr($settings['orderby_post']); ?>" 
						data-first_term="<?php echo esc_attr($settings['first_term']); ?>" 
						data-term_id_filter_string="<?php echo esc_attr($settings['term_id_filter_string']); ?>" 
						data-number_post="<?php echo esc_attr($settings['number_post']); ?>" 
						data-layout='<?php echo esc_attr($layout); ?>' 
						data-show_featured="<?php echo esc_attr($settings['show_featured']); ?>"
						data-args_show="<?php echo esc_attr( json_encode($args_show) ); ?>"
					>
						<?php esc_html_e( 'All', 'ovaev' ); ?>
					</button>
				<?php } ?>

				<?php if ( count( $settings['terms'] ) > 0 ){
					foreach ( $settings['terms'] as $term ) { ?>
						<button 
							data-filter="<?php echo esc_attr($term->term_id); ?>" 
							data-order="<?php echo esc_attr($settings['order_post']); ?>" 
							data-orderby="<?php echo esc_attr($settings['orderby_post']); ?>" 
							data-first_term="<?php echo esc_attr($settings['first_term']); ?>" 
							data-term_id_filter_string="<?php echo esc_attr($settings['term_id_filter_string']); ?>" 
							data-number_post="<?php echo esc_attr($settings['number_post']); ?>" 
							data-layout='<?php echo esc_attr($layout); ?>' 
							data-show_featured="<?php echo esc_attr($settings['show_featured']); ?>"
							data-args_show="<?php echo esc_attr( json_encode($args_show) ); ?>"
						>
							<?php echo esc_html( $term->name ); ?>
						</button>
					<?php }
				} ?>
			</div>
		<?php } ?>
		
		<div class="content ovapo_project_slide">
			<div class="items grid owl-carousel" data-owl="<?php echo esc_attr(json_encode( $data_carousel )); ?>">
				<?php if( $data_event->have_posts() ) : while( $data_event->have_posts() ) : $data_event->the_post();
					$id = get_the_ID();
					$ovapo_cat = get_the_terms( $id, 'event_category' );

					$cat_name = array();
					if ($ovapo_cat != '') {
						foreach ($ovapo_cat as $key => $value) {
							$cat_name[] = $value->name;
						}
					}

					$category_name = join(', ', $cat_name);

					switch ($layout) {
						case '1':
							ovaev_get_template( 'event-templates/event-type1.php', $args_show );
							break;
						case '2':
							ovaev_get_template( 'event-templates/event-type2.php', $args_show );
							break;
						case '3':
							ovaev_get_template( 'event-templates/event-type3.php', $args_show );
							break;
						case '4':
							ovaev_get_template( 'event-templates/event-type4.php', $args_show );
							break;
						case '5':
							ovaev_get_template( 'event-templates/event-type5.php', $args_show );
							break;
						case '6':
							ovaev_get_template( 'event-templates/event-type6.php', $args_show );
							break;
						case '7':
							ovaev_get_template( 'event-templates/event-type7.php', $args_show );
							break;
						default:
							ovaev_get_template( 'event-templates/event-type1.php', $args_show );
					} ?>
				<?php endwhile; endif; wp_reset_postdata(); ?>
			</div>

	    	<div class="title-readmore">
				<?php if( $settings['show_read_more'] == 'yes' ){ ?>
					<div class="btn_grid" >
						<a href="<?php echo get_post_type_archive_link('event') ?>" class="read-more second_font btn_grid_event">
							<?php echo esc_html( $settings['text_read_more'] ); ?>
						</a>
					</div>
				<?php } ?>
	    	</div>
			<div class="wrap_loader">
				<svg class="loader" width="50" height="50">
					<circle cx="25" cy="25" r="10" stroke="#a1a1a1"/>
					<circle cx="25" cy="25" r="20" stroke="#a1a1a1"/>
				</svg>
			</div>
		</div>

	</div>

<?php else : ?>
	<div class="search_not_found">
		<?php esc_html_e( 'Not Found Event', 'ovaev' ); ?>
	</div>
<?php endif;