(function( $ ){
	'use strict';

	/***** Menu Tab *****/
	$( function() {
		$( "#tabs" ).tabs();
	} );

	if ( $.isFunction( $.fn.select2 ) ) {
		$('.ovaex_row select[name="exhibition_artist[]"]').select2({
			closeOnSelect: true,
		});
	}

	/***** Map *****/
	$( function($) {
		$.fn.ovaex_map = function( paramObject ){

			paramObject = $.extend( { lat: -33.8688, lng: 151.2195, zoom: 17 }, paramObject );

			var map_canvas = paramObject.id;
			var map = new google.maps.Map(document.getElementById('ovaex_show_map'), {
				center: {
					lat: paramObject.lat,
					lng: paramObject.lng
				},
				zoom: paramObject.zoom,
				scrollwheel: true,
				draggable: true,
			});


			// alert('x');

			var input = document.getElementById('pac-input');

			var autocomplete = new google.maps.places.Autocomplete(input);
			autocomplete.bindTo('bounds', map);

			map.controls[google.maps.ControlPosition.TOP_LEFT].push(input);

			var mapIWcontent = $('#pac-input').val();
			var infowindow = new google.maps.InfoWindow({
				content: mapIWcontent,
			});

			var infowindowContent = document.getElementById('infowindow-content');

			var marker = new google.maps.Marker({
				map: map,
				position: map.getCenter()
			});
			marker.addListener('click', function() {
				infowindow.open(map, marker);
			});


			autocomplete.addListener('place_changed', function() {
				infowindow.close();
				var place = autocomplete.getPlace();
				if (!place.geometry) {
					return;
				}

				if (place.geometry.viewport) {
					map.fitBounds(place.geometry.viewport);
				} else {
					map.setCenter(place.geometry.location);
					map.setZoom(17);
				}

            	// Set the position of the marker using the place ID and location.
            	marker.setPlace({
            		placeId: place.place_id,
            		location: place.geometry.location
            	});
            	marker.setVisible(true);
            	infowindowContent.children['place-name'].textContent = place.name;
            	infowindowContent.children['place-address'].textContent = place.formatted_address;

            	$(".ovaex_map #ovaex_map_name").val(place.name);
            	$(".ovaex_map #ovaex_map_address").val(place.formatted_address);

            	var location_map = String(place.geometry.location);
            	var lacation_input = location_map.replace("(","").replace(")","").replace(" ", "").split(",");
            	$(".ovaex_map #ovaex_map_lat").val(lacation_input[0]);
            	$(".ovaex_map #ovaex_map_lng").val(lacation_input[1]);

            	infowindow.setContent(place.formatted_address);
            	infowindow.open(map, marker);

            });
		}
	} );

	$( function($) {
		if( typeof google !== 'undefined' && $("#ovaex_show_map").length > 0 ){
			var ovaex_map_lat = parseFloat( $('input#ovaex_map_lat').val() );
			var ovaex_map_lng = parseFloat( $('input#ovaex_map_lng').val() );

			$("#ovaex_show_map").ovaex_map({ lat: ovaex_map_lat, lng: ovaex_map_lng, zoom: 17, id:'#ovaex_show_map'  });	
		}
	} );
	/***** End Map *****/


	/***** Upload Image *****/
	$( function() {
		var file_frame;
		$(document).on('click', '#metabox-exhibition-gallery a.gallery-add', function(e) {

			e.preventDefault();

			if (file_frame) file_frame.close();

			file_frame = wp.media.frames.file_frame = wp.media({
				title: $(this).data('uploader-title'),
				button: {
					text: $(this).data('uploader-button-text'),
				},
				multiple: true
			});

			file_frame.on('select', function() {
				var listIndex = $('#gallery-metabox-list li').index($('#gallery-metabox-list li:last')),
				selection = file_frame.state().get('selection');

				selection.map(function(attachment, i) {
					attachment = attachment.toJSON();
					var index   = listIndex + (i + 1);
					var url 	   = attachment.sizes.full.url;
					if ( $(attachment.sizes.thumbnail).length > 0 ) {
						url = attachment.sizes.thumbnail.url;
					}

					$('#gallery-metabox-list').append('<li><input type="hidden" name="ovaex_gallery_id[' + index + ']" value="' + attachment.id + '"><img class="image-preview" src="' + url + '"><a class="change-image button button-small" href="#" data-uploader-title="Change image" data-uploader-button-text="Change image">Change image</a><small><a class="remove-image" href="#">Remove image</a></small></li>');
				});
			});

			makeSortable();

			file_frame.open();

		});

		$(document).on('click', '#metabox-exhibition-gallery a.change-image', function(e) {

			e.preventDefault();

			var that = $(this);

			if (file_frame) file_frame.close();

			file_frame = wp.media.frames.file_frame = wp.media({
				title: $(this).data('uploader-title'),
				button: {
					text: $(this).data('uploader-button-text'),
				},
				multiple: false
			});

			file_frame.on( 'select', function() {
				attachment = file_frame.state().get('selection').first().toJSON();

				that.parent().find('input:hidden').attr('value', attachment.id);
				that.parent().find('img.image-preview').attr('src', attachment.sizes.thumbnail.url);
			});

			file_frame.open();

		});

		function resetIndex() {
			$('#metabox-exhibition-gallery #gallery-metabox-list li').each(function(i) {
				$(this).find('input:hidden').attr('name', 'ovaex_gallery_id[' + i + ']');
			});
		}

		function makeSortable() {
			$('#metabox-exhibition-gallery #gallery-metabox-list').sortable({
				opacity: 0.6,
				stop: function() {
					resetIndex();
				}
			});
		}

		$(document).on('click', '#metabox-exhibition-gallery a.remove-image', function(e) {
			e.preventDefault();

			$(this).parents('li').animate({ opacity: 0 }, 200, function() {
				$(this).remove();
				resetIndex();
			});
		});

		makeSortable();
	} );


	/***** Date Time Picker *****/
	$( function($) {
		$('.ex_start_date, .ex_end_date').each(function(){
         var date = $(this).data('date');
         var lang = $(this).data('lang');

         $(this).datetimepicker({
            format: date,
         });
         $.datetimepicker.setLocale(lang);

      });
	} );

	if ( $.isFunction( $.fn.select2 ) ) {
		$('.ovaex_row select[name="exhibition_artist[]"]').select2({
			closeOnSelect: true,
		});
	}

})(jQuery); 	