(function($){
	"use strict";

	$(window).on('elementor/frontend/init', function () {
		
		/* Masonry Element */
      elementorFrontend.hooks.addAction('frontend/element_ready/ovaex_exhibition_ajax.default', function(){

         $('.ova_more_post, .exhibition_tab_item a').on( "click", function() {

            var type_action     = $(this).attr('data-type_action');
            var behav           = $(this).attr('data-behav');

            var upcoming_day    = $(this).attr('data-upcoming');

            var pageid          = $(this).attr('data-paged');
            var ovaex_perpage   = $(this).attr('data-perpage');
            var ovaex_order     = $(this).attr('data-order');
            var ovaex_order_by  = $(this).attr('data-order-by');
            var ovaex_data_post = $(this).attr('data-post');
            var categories      = $(this).attr('data-categories');
            var artist          = $(this).attr('data-artist');

            var args_show = JSON.parse($(this).closest('.ova-exhibition-ajax').attr('data-args_show'));

            if ( categories ) {
               categories = JSON.parse( categories );
            }

            if( behav == 'tab' ){
               $('.tab-content').html('');
               $('.ova_more_post').attr('data-paged','1');
               $('.ova_more_post').show();
               $('.ova-nodata').hide();
               $('.image-loadmore').css('display','none');
               $( '.ova_more_post' ).attr( 'data-type_action', type_action );
            }

            $('.load-more').hide();
            $('.image-loadmore').css('display','inline-block');
            $.ajax({
               url: load_more.url,
               type: 'POST',
               data: ({
                  type_action: type_action,
                  upcoming_day: upcoming_day,
                  action: 'ovaex_loadmore',
                  pageid: pageid,
                  ovaex_perpage: ovaex_perpage,
                  ovaex_order_by: ovaex_order_by,
                  ovaex_order: ovaex_order,
                  ovaex_data_post: ovaex_data_post,
                  ovaex_categories: categories,
                  ovaex_artist: artist,
                  args_show: args_show
               }),
               success: function(data){
                  if (data){
                     $('.tab-content').append(data);
                  }else{
                     $('.ova_more_post').hide();
                     $('.ova-nodata').show();
                     $('.ova-noload').show();
                  }

                  var new_paged = parseInt(pageid) + 1;
                  $('.ova_more_post').attr('data-paged',new_paged);

                  $('.load-more').show();
                  $('.image-loadmore').css('display','none');
               }
            });
         });
      });

      /***** Exhibition Slide *****/
      elementorFrontend.hooks.addAction('frontend/element_ready/ovaex_exhibition_type.default', function(){

         if( $('.slide-owl').length > 0 ){  
            $('.slide-owl').each(function(){
               var owl_slide = $(this);
               var ovaex_sl  = $(this).data('options');
               var rtl       = false;

               if( $('body').hasClass('rtl') ){
                  rtl = true;
               }

               owl_slide.owlCarousel({
                  margin: ovaex_sl.margin,
                  smartSpeed: ovaex_sl.smartSpeed,
                  loop: ovaex_sl.loop,
                  autoplay: ovaex_sl.autoplay,
                  autoplayTimeout: ovaex_sl.autoplayTimeout,
                  autoplayHoverPause: ovaex_sl.autoplayHoverPause,
                  dots: ovaex_sl.dots,  
                  nav: false,
                  slideBy: ovaex_sl.slideBy,
                  navText:[ovaex_sl.prev,ovaex_sl.next],
                  rtl: rtl,
                  responsive:{
                     0:{
                        items: ovaex_sl.items_mobile
                     },
                     768:{
                        items: ovaex_sl.items_ipad
                     },
                     1170:{
                        items: ovaex_sl.total_columns_slide,
                     }
                  }
               });

               /* Fixed WCAG */
               owl_slide.find(".owl-nav button.owl-prev").attr("title", "Previous");
               owl_slide.find(".owl-nav button.owl-next").attr("title", "Next");
               owl_slide.find(".owl-dots button").attr("title", "Dots");
               
            });
         }

      });

      /***** Exhibition Ajax *****/
      elementorFrontend.hooks.addAction('frontend/element_ready/ovaex_exhibition_ajax.default', function(){
    
        $('.ova-exhibition-ajax').each(function(){
            var that = $(this);
            var filter_btn = that.find('.exhibition_tab_item .nav-link');

            filter_btn.click(function(){
               $('.exhibition_tab_item .nav-link').removeClass("active");
               $(this).addClass("active");
            }); 
        });

      });

   });
})(jQuery);