<?php defined( 'ABSPATH' ) || exit();

if( !class_exists( 'OVADIR_assets' ) ){
	class OVADIR_assets{
		public function __construct(){
			// Admin
			add_action( 'admin_enqueue_scripts', array( $this, 'ovadir_admin_enqueue_scripts' ) );

			// Frontend
			add_action( 'wp_enqueue_scripts', array( $this, 'ovadir_frontend_enqueue_scripts' ) );
		}

		// Admin
		public function ovadir_admin_enqueue_scripts() {
			global $pagenow;

			$use_gg_map = get_theme_mod('ova_dir_use_google_map','yes');

			if ( ( $pagenow == 'post.php' || $pagenow == 'post-new.php' ) && get_post_type() === 'ova_dir' && $use_gg_map == 'yes' ) {
				if ( get_option( 'ova_dir_google_map_api', false ) ) {
					wp_enqueue_script( 'google','https://maps.googleapis.com/maps/api/js?key='.get_option( 'ova_dir_google_map_api', '' ).'&callback=Function.prototype&libraries=places', false, true );
				} else {
					wp_enqueue_script( 'google_map','https://maps.googleapis.com/maps/api/js?sensor=false&callback=Function.prototype&libraries=places', array('jquery'), false, true );
				}
			}

			if ( ( $pagenow == 'post.php' || $pagenow == 'post-new.php' ) && get_post_type() === 'ova_dir' ) {
				wp_enqueue_script('ova_dir_admin_scripts', OVADIR_PLUGIN_URI . 'assets/js/admin/scripts.js', array('jquery'),false, true);
				wp_enqueue_style( 'ovadir_admin_styles', OVADIR_PLUGIN_URI.'assets/css/admin/styles.css');
			}
			
		}

		// Frontend
		public function ovadir_frontend_enqueue_scripts(){

			$use_gg_map = get_theme_mod('ova_dir_use_google_map','yes');

			if ( (is_singular( 'ova_dir' ) || is_post_type_archive( 'ova_dir' ) || is_tax( 'tag_dir' ) || is_tax( 'cat_dir' )) && $use_gg_map == 'yes' ) {
				if ( get_option( 'ova_dir_google_map_api', false ) ) {
					wp_enqueue_script('markerclusterer','https://unpkg.com/@googlemaps/markerclusterer/dist/index.min.js', array('jquery'),false, true);
					wp_enqueue_script( 'google','https://maps.googleapis.com/maps/api/js?key='.get_option( 'ova_dir_google_map_api', '' ).'&callback=Function.prototype&libraries=places', false, true );					
				} else {
					wp_enqueue_script( 'google_map','https://maps.googleapis.com/maps/api/js?sensor=false&callback=Function.prototype&libraries=places', array('jquery'), false, true );
				}
			}

			if ( is_post_type_archive( 'ova_dir' ) || is_tax( 'tag_dir' ) || is_tax( 'cat_dir' ) ) {
				wp_enqueue_style( 'ovadir_frontend_styles', OVADIR_PLUGIN_URI.'assets/css/frontend/styles.css');
				wp_enqueue_script('ova_dir_frontend_scripts', OVADIR_PLUGIN_URI . 'assets/js/frontend/scripts.js', array('jquery'),false, true);
				wp_localize_script( 'ova_dir_frontend_scripts', 'ova_dir_use_google_map', array( 'value' => $use_gg_map ) );
			}

			if ( is_singular( 'ova_dir' ) ) {
				// Fancybox libs
				wp_enqueue_style( 'fancybox', OVADIR_PLUGIN_URI.'assets/libs/fancybox/fancybox.css');
				wp_enqueue_script('fancybox', OVADIR_PLUGIN_URI . 'assets/libs/fancybox/fancybox.umd.js', array('jquery'),false, true);

				wp_enqueue_style( 'ovadir_single_styles', OVADIR_PLUGIN_URI.'assets/css/frontend/single-styles.css');
				wp_enqueue_script('ova_dir_frontend_scripts', OVADIR_PLUGIN_URI . 'assets/js/frontend/scripts.js', array('jquery'),false, true);
				wp_localize_script( 'ova_dir_frontend_scripts', 'ova_dir_use_google_map', array( 'value' => $use_gg_map ) );
			}
			
		}

	}
	new OVADIR_assets();
}