<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Utils;
use Elementor\Group_Control_Border;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Gimont_Elementor_Countdown extends Widget_Base {

	public function get_name() {
		return 'gimont_elementor_countdown';
	}

	public function get_title() {
		return esc_html__( 'Ova Countdown', 'gimont' );
	}

	public function get_icon() {
		return 'eicon-countdown';
	}

	public function get_categories() {
		return [ 'gimont' ];
	}

	public function get_script_depends() {
		wp_enqueue_style( 'countdown', get_theme_file_uri('/assets/libs/countdown/jquery.countdown.css'), 'all' );
		wp_enqueue_script( 'localisation', get_theme_file_uri('/assets/libs/localisation/jquery.localisation.js'), array('jquery'), false, true);
		wp_enqueue_script( 'plugin', get_theme_file_uri('/assets/libs/countdown/jquery.plugin.js'), array('jquery'), false, true);
		wp_enqueue_script( 'countdown', get_theme_file_uri('/assets/libs/countdown/jquery.countdown.min.js'), array('jquery'), false, true);
		return [ 'gimont-elementor-countdown' ];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'gimont-elementor-countdown', GIMONT_URI.'/assets/scss/elementor/countdown/countdown.css' );
		return [];
	}
	
	// Add Your Controll In This Function
	protected function register_controls() {

		/* Content */
		$this->start_controls_section(
				'section_content',
				[
					'label' => esc_html__( 'Content', 'gimont' ),
				]
			);

			$this->add_control(
				'due_date',
				[
					'label' => esc_html__( 'Due Date', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DATE_TIME,
					'default' 		=> gmdate( 'Y-m-d H:i', strtotime( '+1 month' ) + ( get_option( 'gmt_offset' ) * HOUR_IN_SECONDS ) ),
				]
			);
			$this->add_control(
				'lang',
				[
					'label' => esc_html__( 'Language', 'gimont' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'en',
					'options' => [
						'en' => esc_html__( 'English' , 'gimont' ),
						'ar' => '‫العربية (Arabic)',
						'id' => 'Bahasa Indonesia (Indonesian)',
						'ms' => 'Bahasa Melayu (Malaysian)',
						'bn' => 'বাংলা (Bengali/Bangla)',
						'nb' => 'Bokmål (Norwegian)',
						'bs' => 'Bosanski (Bosnian)',
						'bg' => 'български език (Bulgarian)',
						'ca' => 'Català (Catalan)',
						'cs' => 'Čeština (Czech)',
						'cy' => 'Cymraeg (Welsh)',
						'da' => 'Dansk (Danish)',
						'de' => 'Deutsch (German)',
						'et' => 'eesti keel (Estonian)',
						'el' => 'Ελληνικά (Greek)',
						'es' => 'Español (Spanish)',
						'fo' => 'føroyskt (Faroese)',
						'fa' => '‫فارسی (Farsi/Persian)',
						'fr' => 'Français (French)',
						'gl' => 'Galego (Galician)',
						'sq' => 'Gjuha shqipe (Albanian)',
						'gu' => 'ગુજરાતી (Gujarati)',
						'ko' => '한국어 (Korean)',
						'he' => '‫עברית (Hebrew)',
						'hi' => 'हिन्दी (Hindi)',
						'hr' => 'Hrvatski jezik (Croatian)',
						'hy' => 'Հայերեն (Armenian)',
						'is' => 'Íslenska (Icelandic)',
						'it' => 'Italiano (Italian)',
						'kn' => 'ಕನ್ನಡ (Kannada)',
						'kk' => 'қазақша (Kazakh)',
						'lv' => 'Latviešu Valoda (Latvian)',
						'lt' => 'lietuvių kalba (Lithuanian)',
						'mk' => 'македонски јазик (Macedonian)',
						'hu' => 'Magyar (Hungarian)',
						'ml' => 'മലയാളം (Malayalam)',
						'my' => 'မြန်မာစာ (Burmese)',
						'nl' => 'Nederlands (Dutch)',
						'ja' => '日本語 (Japanese)',
						'uz' => 'O‘zbek tili (Uzbek)',
						'th' => 'ภาษาไทย (Thai)',
						'pl' => 'Polski (Polish)',
						'pt-BR' => 'Português (Portuguese/Brazilian)',
						'ro' => 'Română (Romanian)',
						'ru' => 'Русский (Russian)',
						'sk' => 'Slovenčina (Slovak)',
						'sl' => 'Slovenščina (Slovenian)',
						'sr' => 'српски језик (Serbian)',
						'sr-SR' => 'srpski jezik (Serbian)',
						'fi' => 'suomi (Finnish)',
						'sv' => 'Svenska (Swedish)',
						'vi' => 'Tiếng Việt (Vietnamese)',
						'tr' => 'Türkçe (Turkish)',
						'uk' => 'українська мова (Ukrainian)',
						'ur' => '‫اُردوُ‬ (Urdu)',
						'zh-CN' => '简体中文 (Chinese/Simplified)',
						'zh-TW' => '繁體中文 (Chinese/Traditional)',
					],
				]
			);


			$this->add_control(
				'format',
				[
					'label' => esc_html__( 'Format', 'gimont' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'DHMS',
					'options' => [
						'YOWDHMS' => 'YOWDHMS',
						'YODHMS' => 'YODHMS',
						'ODHMS' => 'ODHMS',
						'DHMS' => 'DHMS',
						'HMS' => 'HMS',
					],
					'description' => esc_html__( "'Y' for years, 'O' for months, 'W' for weeks, 'D' for days, 'H' for hours, 'M' for minutes, 'S' for seconds.", 'gimont' ),
				]
			);

			$this->add_responsive_control(
				'item_align',
				[
					'label' => esc_html__( 'Alignment', 'gimont' ),
					'type' => \Elementor\Controls_Manager::CHOOSE,
					'options' => [
						'flex-start' => [
							'title' => esc_html__( 'Left', 'gimont' ),
							'icon' => 'eicon-text-align-left',
						],
						'center' => [
							'title' => esc_html__( 'Center', 'gimont' ),
							'icon' => 'eicon-text-align-center',
						],
						'flex-end' => [
							'title' => esc_html__( 'Right', 'gimont' ),
							'icon' => 'eicon-text-align-right',
						],
					],
					'toggle' => true,
					'selectors' => [
						'{{WRAPPER}} .ova-countdown .countdown-row' => 'justify-content: {{VALUE}};',
					],
				]
			);

		$this->end_controls_section();

		/* Item */
		$this->start_controls_section(
				'item_style_section',
				[
					'label' => esc_html__( 'Item', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'item_margin',
				[
					'label' => esc_html__( 'Margin', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-countdown .countdown-section' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);


			$this->add_control(
				'item_width',
				[
					'label' => esc_html__( 'Width', 'gimont' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 300,
							'step' => 5,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .ova-countdown .countdown-section' => 'width: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_control(
				'item_gap',
				[
					'label' => esc_html__( 'Gap', 'gimont' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 100,
							'step' => 5,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .ova-countdown .countdown-row' => 'gap: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name' => 'item_border',
					'selector' => '{{WRAPPER}} .ova-countdown .countdown-section',
				]
			);

		$this->end_controls_section();

		/* Number */
		$this->start_controls_section(
				'number_style_section',
				[
					'label' => esc_html__( 'Number', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'number_padding',
				[
					'label' => esc_html__( 'Padding', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-countdown .countdown-amount' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'number_typography',
					'selector' => '{{WRAPPER}} .ova-countdown .countdown-amount',
				]
			);

			$this->add_control(
				'number_color',
				[
					'label' => esc_html__( 'Color', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-countdown .countdown-amount' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'number_background',
				[
					'label' => esc_html__( 'Background', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-countdown .countdown-amount' => 'background: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		/* Label */
		$this->start_controls_section(
				'label_style_section',
				[
					'label' => esc_html__( 'Label', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'label_padding',
				[
					'label' => esc_html__( 'Padding', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-countdown .countdown-period' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'label_typography',
					'selector' => '{{WRAPPER}} .ova-countdown .countdown-period',
				]
			);

			$this->add_control(
				'label_color',
				[
					'label' => esc_html__( 'Color', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-countdown .countdown-period' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'label_background',
				[
					'label' => esc_html__( 'Background', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-countdown .countdown-period' => 'background: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

	}

	// Render Template Here
	protected function render() {
		$settings 	= $this->get_settings();
		$due_date 	= $settings['due_date'] ? strtotime( $settings['due_date'] ) : time();
		$lang 		= $settings['lang'];
		$lang_url 	= get_theme_file_uri('/assets/libs/countdown/jquery.countdown');
		if ( $lang == 'en' ) {
			$lang_url = '';
		}
		$format 	= $settings['format'];
		$data 		= array(
						'year' 		=> date( "Y", $due_date ),
						'month' 	=> date( "n", $due_date ),
						'day' 		=> date( "j", $due_date ),
						'hours' 	=> date( "G", $due_date ),
						'minutes' 	=> intval( date( "i", $due_date ) ),
						'timezone' 	=> get_option( 'gmt_offset' ),
						'langUrl'	=> $lang_url,
						'lang'		=> $lang,
						'format'	=> $format,
					);

		?>
		<div class="ova-countdown" data-date="<?php echo esc_attr( json_encode( $data ) ); ?>"></div>
		<?php
	}

	
}
$widgets_manager->register( new Gimont_Elementor_Countdown() );