<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Utils;
use Elementor\Group_Control_Border;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Gimont_Elementor_Gallery_Filter extends Widget_Base {

	public function get_name() {
		return 'gimont_elementor_gallery_filter';
	}

	public function get_title() {
		return esc_html__( 'Gallery Filter', 'gimont' );
	}

	public function get_icon() {
		return 'eicon-gallery-grid';
	}

	public function get_categories() {
		return [ 'gimont' ];
	}

	public function get_script_depends() {
		wp_enqueue_script( 'isotope', get_template_directory_uri().'/assets/libs/isotope/isotope.pkgd.min.js', array('jquery'), false, true );
		return [ 'gimont-elementor-gallery-filter' ];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'gimont-elementor-gallery-filter', GIMONT_URI.'/assets/scss/elementor/galleries/gallery-filter.css' );
		return [];
	}
	
	// Add Your Controll In This Function
	protected function register_controls() {

		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Content', 'gimont' ),
			]
		);

			// Add Class control
			$this->add_control(
				'show_category_filter',
				[
					'label' 		=> esc_html__( 'Show Category Filter', 'gimont' ),
					'type' 			=> \Elementor\Controls_Manager::SWITCHER,
					'label_on' 		=> esc_html__( 'Show', 'gimont' ),
					'label_off' 	=> esc_html__( 'Hide', 'gimont' ),
					'return_value' 	=> 'yes',
					'default' 		=> 'yes',
				]
			);
			
			$this->add_control(
				'number_column',
				[
					'label' => esc_html__( 'Layout', 'gimont' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'three_column',
					'options' => [
						'three_column' => esc_html__( '3 Columns', 'gimont' ),
						'four_column'  => esc_html__( '4 Columns', 'gimont' ),
					],
				]
			);

			$this->add_control(
				'cateAll',
				[
					'label' => esc_html__( 'Text Show All', 'gimont' ),
					'type' => \Elementor\Controls_Manager::TEXT,
					'default' => esc_html__('Show all','gimont'),
				]
			);

			$repeater = new \Elementor\Repeater();

			$repeater->add_control(
				'link',
				[
					'label' => esc_html__( 'Link', 'gimont' ),
					'type' => \Elementor\Controls_Manager::URL,
					'placeholder' => esc_html__( 'https://your-link.com', 'gimont' ),
					'options' => [ 'url', 'is_external', 'nofollow' ],
					'default' => [
						'url' => '',
						'is_external' => false,
						'nofollow' => false,
					],
					'description' => esc_html__('( If you enter the link, it will redirect to the link instead of Fancybox popup )','gimont'),
					'dynamic' => [
						'active' => true,
					],
				]
			);

			$repeater->add_control(
				'video_link',
				[
					'label' => esc_html__( 'Embed Video Link', 'gimont' ),
					'type' => \Elementor\Controls_Manager::URL,
					'placeholder' => esc_html__( 'https://your-link.com', 'gimont' ),
					'options' => [ 'url', 'is_external', 'nofollow' ],
					'default' => [
						'url' => '',
						'is_external' => false,
						'nofollow' => false,
					],
					'description' => 'https://www.youtube.com/watch?v=MLpWrANjFbI',
					'dynamic' => [
						'active' => true,
					],
				]
			);

			$repeater->add_control(
				'icon',
				[
					'label' => esc_html__( 'Icon', 'gimont' ),
					'type' => \Elementor\Controls_Manager::ICONS,
					'default' => [
						'value' => 'ovaicon ovaicon-next-4',
						'library' => 'all',
					],
				]
			);

			$repeater->add_control(
				'category',
				[
					'label'   => esc_html__( 'Category', 'gimont' ),
					'type'    => \Elementor\Controls_Manager::TEXT,
					'default' => esc_html__( 'Documention', 'gimont' ),
				]
			);

			$repeater->add_control(
				'title',
				[
					'label'   => esc_html__( 'Title', 'gimont' ),
					'type' => \Elementor\Controls_Manager::TEXTAREA,
					'rows' => 3,
					'default' =>  esc_html__( 'Economy growth rates', 'gimont' ),
				]
			);

			$repeater->add_control(
				'description',
				[
					'label'   => esc_html__( 'Description', 'gimont' ),
					'type'    => \Elementor\Controls_Manager::TEXTAREA,
					'default' => esc_html__( 'Documention', 'gimont' ),
				]
			);

			$repeater->add_control(
				'image',
				[
					'label'   => esc_html__( 'Image', 'gimont' ),
					'type'    => \Elementor\Controls_Manager::MEDIA,
					'default' => [
						'url' => \Elementor\Utils::get_placeholder_image_src(),
					],
				]
			);

			$this->add_control(
				'tab_item',
				[
					'label'		=> esc_html__( 'Items Gallery', 'gimont' ),
					'type'		=> \Elementor\Controls_Manager::REPEATER,
					'fields'  	=> $repeater->get_controls(),
					'default' 	=> [
						[
							'title' => esc_html__('City visitors guide', 'gimont'),
							'category' => esc_html__('Services', 'gimont'),
							'description' => esc_html__('Services', 'gimont'),
						],
						[
							'title' => esc_html__('Public Service Identity', 'gimont'),
							'category' => esc_html__('Services', 'gimont'),
							'description' => esc_html__('Services', 'gimont'),
						],
						[
							'title' => esc_html__('Culture & Recreation', 'gimont'),
							'category' => esc_html__('Departments', 'gimont'),
							'description' => esc_html__('Departments', 'gimont'),
						],
						[
							'title' => esc_html__('Service departments', 'gimont'),
							'category' => esc_html__('Services', 'gimont'),
							'description' => esc_html__('Services', 'gimont'),
						],
						[
							'title' => esc_html__('Policing & crimes', 'gimont'),
							'category' => esc_html__('Departments', 'gimont'),
							'description' => esc_html__('Departments', 'gimont'),
						],
						[
							'title' => esc_html__('Your governement', 'gimont'),
							'category' => esc_html__('Departments', 'gimont'),
							'description' => esc_html__('Departments', 'gimont'),
						],
						[
							'title' => esc_html__('Economy growth rates', 'gimont'),
							'category' => esc_html__('Documention', 'gimont'),
							'description' => esc_html__('Documention', 'gimont'),
						],
						[
							'title' => esc_html__('City board applications', 'gimont'),
							'category' => esc_html__('Documention', 'gimont'),
							'description' => esc_html__('Documention', 'gimont'),
						],
						[
							'title' => esc_html__('Parking Permission', 'gimont'),
							'category' => esc_html__('Services', 'gimont'),
							'description' => esc_html__('Services', 'gimont'),
						],
					],
					'title_field' => '{{{ title }}}',
				]
			);

		$this->end_controls_section();

		/* BEGIN WRAP CATEGORY STYLE */
		$this->start_controls_section(
	            'wrap_category_style',
	            [
	                'label' => esc_html__( 'Wrap Category', 'gimont' ),
	                'tab' 	=> Controls_Manager::TAB_STYLE,
	            ]
	        );

        	$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name' => 'wrap_category_border',
					'label' => esc_html__( 'Border', 'gimont' ),
					'selector' => '{{WRAPPER}} .ova-gallery-filter .filter-btn-wrapper',
				]
			);

			$this->add_responsive_control(
	            'wrap_category_padding',
	            [
	                'label' 		=> esc_html__( 'Padding', 'gimont' ),
	                'type' 			=> Controls_Manager::DIMENSIONS,
	                'size_units' 	=> [ 'px', '%', 'em' ],
	                'selectors' 	=> [
	                    '{{WRAPPER}} .ova-gallery-filter .filter-btn-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
	                ],
	            ]
	        );

	        $this->add_responsive_control(
	            'wrap_category_margin',
	            [
	                'label' 		=> esc_html__( 'Margin', 'gimont' ),
	                'type' 			=> Controls_Manager::DIMENSIONS,
	                'size_units' 	=> [ 'px', '%', 'em' ],
	                'selectors' 	=> [
	                    '{{WRAPPER}} .ova-gallery-filter .filter-btn-wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
	                ],
	            ]
	        );

        $this->end_controls_section();
        /* END WRAP CATEGORY STYLE */

		/* BEGIN CATEGORY FILTER STYLE */
		$this->start_controls_section(
	            'filter_style',
	            [
	                'label' => esc_html__( 'Filter', 'gimont' ),
	                'tab' 	=> Controls_Manager::TAB_STYLE,
	            ]
	        );

        	$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 	=> 'filter_typography',
					'selector' 	=> '{{WRAPPER}} .ova-gallery-filter .filter-btn-wrapper li.filter-btn',	
				]
			);

			$this->add_control(
	            'filter_color_normal',
	            [
	                'label' 	=> esc_html__( 'Color', 'gimont' ),
	                'type' 		=> Controls_Manager::COLOR,
	                'selectors' => [
	                    '{{WRAPPER}} .ova-gallery-filter .filter-btn-wrapper li.filter-btn' => 'color: {{VALUE}}',
	                ],
	            ]
	        );

			$this->add_control(
	            'filter_color_active',
	            [
	                'label' 	=> esc_html__( 'Color Active', 'gimont' ),
	                'type' 		=> Controls_Manager::COLOR,
	                'selectors' => [
	                    '{{WRAPPER}} .ova-gallery-filter .filter-btn-wrapper li.filter-btn.active-category' => 'color: {{VALUE}}',
	                ],
	            ]
	        );

	        $this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name' => 'border_filter',
					'label' => esc_html__( 'Border', 'gimont' ),
					'selector' => '{{WRAPPER}} .ova-gallery-filter .filter-btn-wrapper li.filter-btn',
				]
			);

			$this->add_control(
	            'filter_border_color_active',
	            [
	                'label' 	=> esc_html__( 'Border Color Active', 'gimont' ),
	                'type' 		=> Controls_Manager::COLOR,
	                'selectors' => [
	                    '{{WRAPPER}} .ova-gallery-filter .filter-btn-wrapper li.filter-btn.active-category' => 'border-color: {{VALUE}}',
	                ],
	            ]
	        );

			$this->add_responsive_control(
	            'filter_padding',
	            [
	                'label' 		=> esc_html__( 'Padding', 'gimont' ),
	                'type' 			=> Controls_Manager::DIMENSIONS,
	                'size_units' 	=> [ 'px', '%', 'em' ],
	                'selectors' 	=> [
	                    '{{WRAPPER}} .ova-gallery-filter .filter-btn-wrapper li.filter-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
	                ],
	            ]
	        );

	        $this->add_responsive_control(
	            'filter_margin',
	            [
	                'label' 		=> esc_html__( 'Margin', 'gimont' ),
	                'type' 			=> Controls_Manager::DIMENSIONS,
	                'size_units' 	=> [ 'px', '%', 'em' ],
	                'selectors' 	=> [
	                    '{{WRAPPER}} .ova-gallery-filter .filter-btn-wrapper li.filter-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
	                ],
	            ]
	        );

        $this->end_controls_section();
        /* END CATEGORY FILTER STYLE */

		/* BEGIN IMAGE STYLE */
		$this->start_controls_section(
				'section_image',
				[
					'label' => esc_html__( 'Image', 'gimont' ),
					'tab' => Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'image_height',
				[
					'label' 		=> esc_html__( 'Height', 'gimont' ),
					'type' 			=> Controls_Manager::SLIDER,
					'size_units' 	=> ['px'],
					'range' => [
						'px' => [
							'min' => 300,
							'max' => 500,
							'step' => 10,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .ova-gallery-filter .gallery-item .gallery-img img' => 'height: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_control(
	            'overlay_bgcolor',
	            [
	                'label' 	=> esc_html__( 'Overlay Color', 'gimont' ),
	                'type' 		=> Controls_Manager::COLOR,
	                'selectors' => [
	                    '{{WRAPPER}} .ova-gallery-filter .gallery-item .gallery-img .mask' => 'background-color: {{VALUE}}',
	                ],
	            ]
	        );

		$this->end_controls_section();
		/* END IMAGE STYLE */

		/* BEGIN ICON STYLE */
		$this->start_controls_section(
				'section_icon_style',
				[
					'label' => esc_html__( 'Icon', 'gimont' ),
					'tab' => Controls_Manager::TAB_STYLE,
				]
			);

		    $this->add_responsive_control(
				'icon_size',
				[
					'label' 		=> esc_html__( 'Size', 'gimont' ),
					'type' 			=> Controls_Manager::SLIDER,
					'size_units' 	=> [ 'px'],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 40,
							'step' => 1,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .ova-gallery-filter .gallery-item .gallery-img .icon i' => 'font-size: {{SIZE}}{{UNIT}};',
					],
				]
			);

            $this->add_responsive_control(
				'icon_bgsize',
				[
					'label' 		=> esc_html__( 'Background Size', 'gimont' ),
					'type' 			=> Controls_Manager::SLIDER,
					'size_units' 	=> [ 'px'],
					'range' => [
						'px' => [
							'min' => 48,
							'max' => 130,
							'step' => 1,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .ova-gallery-filter .gallery-item .gallery-img .icon' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'icon_rotate',
				[
					'label' => esc_html__( 'Rotate', 'gimont' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'deg', 'grad', 'rad', 'turn', 'custom' ],
					'default' => [
						'unit' => 'deg',
						'size' => -45,
					],
					'tablet_default' => [
						'unit' => 'deg',
					],
					'mobile_default' => [
						'unit' => 'deg',
					],
					'selectors' => [
						'{{WRAPPER}} .ova-gallery-filter .gallery-item .gallery-img .icon i' => 'transform: rotate({{SIZE}}{{UNIT}});',
					],
				]
			);

			$this->add_responsive_control(
				'icon_rotate_hover',
				[
					'label' => esc_html__( 'Rotate Hover', 'gimont' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'deg', 'grad', 'rad', 'turn', 'custom' ],
					'default' => [
						'unit' => 'deg',
						'size' => -135,
					],
					'tablet_default' => [
						'unit' => 'deg',
					],
					'mobile_default' => [
						'unit' => 'deg',
					],
					'selectors' => [
						'{{WRAPPER}} .ova-gallery-filter .gallery-item .gallery-img .icon:hover i' => 'transform: rotate({{SIZE}}{{UNIT}});',
					],
				]
			);


			$this->add_control(
				'bg_border_radius_icon',
				[
					'label' => esc_html__( 'Border Radius', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors' => [
						'{{WRAPPER}} .ova-gallery-filter .gallery-item .gallery-img .icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->start_controls_tabs( 'tabs_icons_style' );
				
				$this->start_controls_tab(
		            'tab_icon_normal',
		            [
		                'label' => esc_html__( 'Normal', 'gimont' ),
		            ]
		        );

		            $this->add_control(
						'color_icon',
						[
							'label' => esc_html__( 'Color', 'gimont' ),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-gallery-filter .gallery-item .gallery-img .icon i' => 'color : {{VALUE}};',
							],
						]
					);

					$this->add_control(
						'bgcolor_icon',
						[
							'label' => esc_html__( 'Background Color', 'gimont' ),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-gallery-filter .gallery-item .gallery-img .icon' => 'background-color : {{VALUE}};',
							],
						]
					);

		        $this->end_controls_tab();

		        $this->start_controls_tab(
		            'tab_icon_hover',
		            [
		                'label' => esc_html__( 'Hover', 'gimont' ),
		            ]
		        );

		            $this->add_control(
						'color_icon_hover',
						[
							'label' => esc_html__( 'Color Hover', 'gimont' ),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-gallery-filter .gallery-item .gallery-img .icon:hover i' => 'color : {{VALUE}};',
							],
						]
					);

					$this->add_control(
						'bgcolor_icon_hover',
						[
							'label' => esc_html__( 'Background Color Hover', 'gimont' ),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-gallery-filter .gallery-item .gallery-img .icon:hover' => 'background-color : {{VALUE}};',
							],
						]
					);

		        $this->end_controls_tab();

		     $this->end_controls_tabs();

        $this->end_controls_section();
        /* END ICON STYLE */

		/* BEGIN TITLE STYLE */
		$this->start_controls_section(
	            'title_style',
	            [
	                'label' => esc_html__( 'Title', 'gimont' ),
	                'tab' 	=> Controls_Manager::TAB_STYLE,
	            ]
	        );

        	$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 	=> 'name_typography',
					'selector' 	=> '{{WRAPPER}} .ova-gallery-filter .gallery-item .title',	
				]
			);

			$this->add_control(
	            'name_color',
	            [
	                'label' 	=> esc_html__( 'Color', 'gimont' ),
	                'type' 		=> Controls_Manager::COLOR,
	                'selectors' => [
	                    '{{WRAPPER}} .ova-gallery-filter .gallery-item .title' => 'color: {{VALUE}}',
	                ],
	            ]
	        );

	        $this->add_responsive_control(
	            'name_margin',
	            [
	                'label' 		=> esc_html__( 'Margin', 'gimont' ),
	                'type' 			=> Controls_Manager::DIMENSIONS,
	                'size_units' 	=> [ 'px', '%', 'em' ],
	                'selectors' 	=> [
	                    '{{WRAPPER}} .ova-gallery-filter .gallery-item .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
	                ],
	            ]
	        );

        $this->end_controls_section();
        /* END TITLE STYLE */

        /* BEGIN DESCRIPTION */
		$this->start_controls_section(
	            'description_style',
	            [
	                'label' => esc_html__( 'Description', 'gimont' ),
	                'tab' 	=> Controls_Manager::TAB_STYLE,
	            ]
	        );

        	$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 	=> 'description_typography',
					'selector' 	=> '{{WRAPPER}} .ova-gallery-filter .gallery-item .style',	
				]
			);

			$this->add_control(
	            'description_color',
	            [
	                'label' 	=> esc_html__( 'Color', 'gimont' ),
	                'type' 		=> Controls_Manager::COLOR,
	                'selectors' => [
	                    '{{WRAPPER}} .ova-gallery-filter .gallery-item .style' => 'color: {{VALUE}}',
	                ],
	            ]
	        );

	        $this->add_responsive_control(
	            'description_margin',
	            [
	                'label' 		=> esc_html__( 'Margin', 'gimont' ),
	                'type' 			=> Controls_Manager::DIMENSIONS,
	                'size_units' 	=> [ 'px', '%', 'em' ],
	                'selectors' 	=> [
	                    '{{WRAPPER}} .ova-gallery-filter .gallery-item .style' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
	                ],
	            ]
	        );

        $this->end_controls_section();
        /* END DESCRIPTION */
	}

	protected function slugify($text, string $divider = '-') {

	  	// replace non letter or digits by divider
	  	$text = preg_replace('~[^\pL\d]+~u', $divider, $text);

	  	// remove unwanted characters
	  	$text = preg_replace('~[^-\w]+~', '', $text);

	  	// trim
	  	$text = trim($text, $divider);

	  	// remove duplicate divider
	  	$text = preg_replace('~-+~', $divider, $text);

	  	// lowercase
	  	$text = strtolower($text);

	  	if (empty($text)) {
	    	return '';
	  	}

	  	return $text;

	}

	// Render Template Here
	protected function render() {
		$settings = $this->get_settings();

		$tabs 	  = $settings['tab_item'];
		$cateAll  = $settings['cateAll'];

		$show_category_filer = $settings['show_category_filter'];

		$number_column = $settings['number_column'];

		$cate_array = array();

		?>

		<?php if ( $tabs && is_array( $tabs ) ): ?>

		<div class="ova-gallery-filter">

			<?php foreach ( $tabs as $key => $items ):

            	$category = $items['category'];

            	array_push($cate_array,$category);
            	$cate_array = array_unique($cate_array);

			endforeach; ?>
            
            <?php if( $show_category_filer == 'yes') { ?>
	            <ul class="filter-btn-wrapper">

	                <li class="filter-btn active-category" data-filter="*">
	                    <?php echo esc_html( $cateAll ); ?>
	                </li>

	                <?php if ( $cate_array ) : foreach ( $cate_array as $cate) :
	                	$slug = $this->slugify($cate); 
	                ?>

	                    <?php if( $cate != '' ) { ?>
		                	<li class="filter-btn" data-slug=".<?php echo esc_attr($slug);?>">
			                    <?php echo esc_html( $cate ); ?>
			                </li>
			            <?php } ?>

		            <?php endforeach; endif; ?>

	            </ul> 
	        <?php } ?>

            <div class="gallery-row">
            	<div class="gallery-column <?php echo esc_attr( $number_column ); ?>">

            		<?php foreach ( $tabs as $key => $items ):
                        
                        $category2  	= $items['category'];
                        $slug2 			= $this->slugify($category2);
	  					$title 			= $items['title'];
	  					$description 	= $items['description'];

	  					// replace % to %% avoid printf error
						if(strpos($description, '%') !== false){
						    $description = str_replace('%', '%%', $description);
						}

	  					$img_id 	= $items['image']['id']; 
                        $img_url 	= $items['image']['url'];

                        $thumbnail_url  = isset(wp_get_attachment_image_src( $img_id, 'gimont_thumbnail' )[0]) ? wp_get_attachment_image_src( $img_id, 'gimont_thumbnail' )[0] : '';
                        if( $thumbnail_url == '') {
                        	$thumbnail_url = $img_url;
                        }
                        
                        // alt and caption
	  					$img_alt 		= ( isset($items['image']['alt']) && $items['image']['alt'] != '' ) ? $items['image']['alt'] : $title;
	  					$caption        = wp_get_attachment_caption( $img_id );

	  					if ( $caption == '' ) {
	  						$caption = $img_alt;
	  					}

	  					// link
	  					$video_link = $items['video_link']['url'];
                        $link 		= $items['link']['url'];
						$target 	= $items['link']['is_external'] ? 'target="_blank"' : '';
	  				?>

		            	<div class="gallery-item <?php echo esc_attr($slug2);?>">

                            <?php if( $video_link ) { ?>
                            	<a class="gallery-fancybox" data-src="<?php echo esc_url( $video_link ); ?>" 
                            		href="<?php echo esc_attr($video_link); ?>"
	  								data-fancybox="gallery-filter" 
	  								data-caption="<?php echo esc_attr( $caption ); ?>">
	  						<?php } elseif ( $link ) { ?>
	  							<a href="<?php echo esc_attr($link); ?>" <?php printf( $target ); ?>>
                            <?php } else { ?>
                            	<a class="gallery-fancybox" data-src="<?php echo esc_url( $img_url ); ?>" 
	  								data-fancybox="gallery-filter" 
	  								data-caption="<?php echo esc_attr( $caption ); ?>">
                            <?php } ?>
								<div class="gallery-img">
							    	<img src="<?php echo esc_url( $thumbnail_url ) ?>" alt="<?php echo esc_attr($img_alt); ?>">
							    	<div class="icon">
										<?php \Elementor\Icons_Manager::render_icon( $items['icon'], [ 'aria-hidden' => 'true' ] ); ?>
									</div>
									<div class="mask"></div>
								</div>

							</a>

							<div class="info">
								<?php if ( $link ) { ?>
	  							<a href="<?php echo esc_attr($link); ?>" <?php printf( $target ); ?>>
                           		<?php } ?>
									<h3 class="title">
										<?php echo esc_html($title); ?>
									</h3>
								<?php if ( $link ) { ?>
	  							</a>
                           		<?php } ?>

								<?php if($description) { ?>
									<p class="description">
										<?php printf($description); ?>
									</p>
								<?php } ?>
							</div>
							
						</div>
	                
	                <?php endforeach; ?>

	            </div>
            </div>

        </div>

        <?php endif;
	}

	
}
$widgets_manager->register( new Gimont_Elementor_Gallery_Filter() );