<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class Gimont_Elementor_Gallery_Slide extends Widget_Base {

	
	public function get_name() {
		return 'gimont_elementor_gallery_slide';
	}

	
	public function get_title() {
		return esc_html__( 'Gallery Slide', 'gimont' );
	}

	
	public function get_icon() {
		return 'eicon-slider-album';
	}

	
	public function get_categories() {
		return [ 'gimont' ];
	}

	public function get_script_depends() {
		return [ 'gimont-elementor-gallery-slide' ];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'gimont-elementor-gallery-slide', GIMONT_URI.'/assets/scss/elementor/galleries/gallery-slide.css' );
		return [];
	}
	
	// Add Your Controll In This Function
	protected function register_controls() {

		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Content', 'gimont' ),
			]
		);	

			$this->add_control(
				'template',
				[
					'label' => esc_html__( 'Template', 'gimont' ),
					'type' => Controls_Manager::SELECT,
					'default' => 'template1',
					'options' => [
						'template1' => esc_html__('Template 1', 'gimont'),
						'template2' => esc_html__('Template 2', 'gimont'),
						'template3' => esc_html__('Template 3', 'gimont'),
					]
				]
			);
			
			$repeater = new \Elementor\Repeater();

			$repeater->add_control(
				'link',
				[
					'label' => esc_html__( 'Link', 'gimont' ),
					'type' => Controls_Manager::URL,
					'dynamic' => [
						'active' => true,
					],
					'placeholder' => esc_html__( 'https://your-link.com', 'gimont' ),
					'show_label' => true,
					'default' => [
						'url' => '#',
					],
				]
			);

			$repeater->add_control(
				'image',
				[
					'label'   => esc_html__( 'Choose Image', 'gimont' ),
					'type'    => Controls_Manager::MEDIA,
					'default' => [
						'url' => Utils::get_placeholder_image_src(),
					],
				]
			);

			$repeater->add_control(
				'title',
				[
					'label' => esc_html__( 'Title', 'gimont' ),
					'type' => Controls_Manager::TEXT,
					'default' => esc_html__( 'Children Park', 'gimont' ),
				]
			);

			$repeater->add_control(
				'category',
				[
					'label' => esc_html__( 'Category/Text', 'gimont' ),
					'type' => Controls_Manager::TEXTAREA,
					'default' => esc_html__( 'Favorite place', 'gimont' ),
				]
			);

			$this->add_control(
				'tab_item',
				[
					'label'		=> esc_html__( 'Tabs', 'gimont' ),
					'type'		=> Controls_Manager::REPEATER,
					'fields'  	=> $repeater->get_controls(),
					'default' 	=> [
						[
							'title' => esc_html__('Children Park', 'gimont'),
						],
						[
							'title' => esc_html__('Metro Stations', 'gimont'),
						],
						[
							'title' => esc_html__('Historical Building', 'gimont'),
						],
						[
							'title' => esc_html__('New York City Museum', 'gimont'),
						],
						[
							'title' => esc_html__('The Bund', 'gimont'),
						],
					],
				]
			);

		$this->end_controls_section();

		/*****************************************************************
						START SECTION ADDITIONAL
		******************************************************************/
		$this->start_controls_section(
			'section_additional_options',
			[
				'label' => esc_html__( 'Additional Options', 'gimont' ),
			]
		);

			$this->add_control(
				'margin_items',
				[
					'label'   => esc_html__( 'Margin Right Items', 'gimont' ),
					'type'    => Controls_Manager::NUMBER,
					'default' => 30,
				]
				
			);

			$this->add_control(
				'stagePadding',
				[
					'label'   => esc_html__( 'Stage Padding', 'gimont' ),
					'type'    => Controls_Manager::NUMBER,
					'default' => 0,
				]
				
			);

			$this->add_control(
				'item_number',
				[
					'label'       => esc_html__( 'Item Number', 'gimont' ),
					'type'        => Controls_Manager::NUMBER,
					'description' => esc_html__( 'Number Item', 'gimont' ),
					'default'     => 3,
				]
			);

			$this->add_control(
				'slides_to_scroll',
				[
					'label'       => esc_html__( 'Slides to Scroll', 'gimont' ),
					'type'        => Controls_Manager::NUMBER,
					'description' => esc_html__( 'Set how many slides are scrolled per swipe.', 'gimont' ),
					'default'     => 1,
				]
			);

			$this->add_control(
				'pause_on_hover',
				[
					'label'   => esc_html__( 'Pause on Hover', 'gimont' ),
					'type'    => Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'gimont' ),
						'no'  => esc_html__( 'No', 'gimont' ),
					],
					'frontend_available' => true,
				]
			);


			$this->add_control(
				'infinite',
				[
					'label'   => esc_html__( 'Infinite Loop', 'gimont' ),
					'type'    => Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'gimont' ),
						'no'  => esc_html__( 'No', 'gimont' ),
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'autoplay',
				[
					'label'   => esc_html__( 'Autoplay', 'gimont' ),
					'type'    => Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'gimont' ),
						'no'  => esc_html__( 'No', 'gimont' ),
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'autoplay_speed',
				[
					'label'     => esc_html__( 'Autoplay Speed', 'gimont' ),
					'type'      => Controls_Manager::NUMBER,
					'default'   => 3000,
					'step'      => 500,
					'condition' => [
						'autoplay' => 'yes',
					],
					'frontend_available' => false,
				]
			);

			$this->add_control(
				'smartspeed',
				[
					'label'   => esc_html__( 'Smart Speed', 'gimont' ),
					'type'    => Controls_Manager::NUMBER,
					'default' => 500,
				]
			);

			$this->add_control(
				'dot_control',
				[
					'label'   => esc_html__( 'Show Dots', 'gimont' ),
					'type'    => Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'gimont' ),
						'no'  => esc_html__( 'No', 'gimont' ),
					],
					'frontend_available' => true,
				]
			);

		$this->end_controls_section();
		/****************************  END SECTION ADDITIONAL *********************/
        
        $this->start_controls_section(
			'section_gallery_slide',
			[
				'label' => esc_html__( 'Image', 'gimont' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
            
            $this->add_responsive_control(
				'image_border_radius',
				[
					'label'      => esc_html__( 'Border Radius', 'gimont' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .ova-gallery-slide .gallery-slide-img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'image_height',
				[
					'label' 	=> esc_html__( 'Height', 'gimont' ),
					'type' 		=> Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => 380,
							'max' => 600,
						],
					],
					'size_units' 	=> [ 'px', '%' ],
					'selectors' 	=> [
						'{{WRAPPER}} .ova-gallery-slide .gallery-slide-img img' => 'height: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_control(
				'image_overlay_color',
				[
					'label'     => esc_html__( 'Overlay Color', 'gimont' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-gallery-slide .gallery-slide-img .overlay' => 'background-color : {{VALUE}};',
					],
				]
			);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Title', 'gimont' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'title_typography',
					'selector' => '{{WRAPPER}} .ova-gallery-slide .gallery-slide-img .info .title',
				]
			);

			$this->add_control(
				'title_color',
				[
					'label'     => esc_html__( 'Color', 'gimont' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-gallery-slide .gallery-slide-img .info .title' => 'color : {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'title_bgcolor',
				[
					'label'     => esc_html__( 'Background Color', 'gimont' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-gallery-slide .gallery-slide-img .info .title' => 'background-color : {{VALUE}};',
					],
				]
			);

			$this->add_responsive_control(
				'title_padding',
				[
					'label'      => esc_html__( 'Padding', 'gimont' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .ova-gallery-slide .gallery-slide-img .info .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_category',
			[
				'label' => esc_html__( 'Category', 'gimont' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'category_typography',
					'selector' => '{{WRAPPER}} .ova-gallery-slide .gallery-slide-img .info .category',
				]
			);

			$this->add_control(
				'category_color',
				[
					'label'     => esc_html__( 'Color', 'gimont' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-gallery-slide .gallery-slide-img .info .category' => 'color : {{VALUE}};',
						'{{WRAPPER}} .ova-gallery-slide .gallery-slide-img .info .category:before, {{WRAPPER}} .ova-gallery-slide .gallery-slide-img .info .category:after' => 'background-color : {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'category_bgcolor',
				[
					'label'     => esc_html__( 'Background Color', 'gimont' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-gallery-slide .gallery-slide-img .info .category' => 'background-color : {{VALUE}};',
					],
				]
			);

			$this->add_responsive_control(
				'category_padding',
				[
					'label'      => esc_html__( 'Padding', 'gimont' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .ova-gallery-slide .gallery-slide-img .info .category' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

		$this->end_controls_section();

		// Icon
		$this->start_controls_section(
			'section_icon_style',
			[
				'label' => esc_html__( 'Icon', 'gimont' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'icon_normal_color',
				[
					'label' 	=> esc_html__( 'Color', 'gimont' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-gallery-slide .gallery-slide-img .view-detail' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'icon_hover_color',
				[
					'label' 	=> esc_html__( 'Color Hover', 'gimont' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-gallery-slide .gallery-slide-img .view-detail:hover' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'icon_normal_bgcolor',
				[
					'label' 	=> esc_html__( 'Background Color', 'gimont' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-gallery-slide .gallery-slide-img .view-detail' => 'background-color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'icon_hover_bgcolor',
				[
					'label' 	=> esc_html__( 'Background Color Hover', 'gimont' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-gallery-slide .gallery-slide-img .view-detail:hover' => 'background-color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

        /* Begin Dots Style */
		$this->start_controls_section(
            'dots_style',
            [
                'label' => esc_html__( 'Dots', 'gimont' ),
                'tab' 	=> Controls_Manager::TAB_STYLE,
                'condition' => [
					'dot_control' => 'yes',
				]
            ]
        );

            $this->add_responsive_control(
				'dots_margin',
				[
					'label'      => esc_html__( 'Margin', 'gimont' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .ova-gallery-slide .owl-dots' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->start_controls_tabs( 'tabs_dots_style' );
				
				$this->start_controls_tab(
		            'tab_dots_normal',
		            [
		                'label' => esc_html__( 'Normal', 'gimont' ),
		            ]
		        );

		            $this->add_control(
						'dot_color',
						[
							'label' 	=> esc_html__( 'Color', 'gimont' ),
							'type' 		=> Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-gallery-slide .owl-dots .owl-dot span' => 'background-color: {{VALUE}}',
							],
						]
					);

					$this->add_responsive_control(
						'dots_width',
						[
							'label' 	=> esc_html__( 'Width', 'gimont' ),
							'type' 		=> Controls_Manager::SLIDER,
							'range' => [
								'px' => [
									'min' => 0,
									'max' => 100,
								],
							],
							'size_units' 	=> [ 'px' ],
							'selectors' 	=> [
								'{{WRAPPER}} .ova-gallery-slide .owl-dots .owl-dot span' => 'width: {{SIZE}}{{UNIT}};',
							],
						]
					);

					$this->add_responsive_control(
						'dots_height',
						[
							'label' 	=> esc_html__( 'Height', 'gimont' ),
							'type' 		=> Controls_Manager::SLIDER,
							'range' => [
								'px' => [
									'min' => 0,
									'max' => 100,
								],
							],
							'size_units' 	=> [ 'px' ],
							'selectors' 	=> [
								'{{WRAPPER}} .ova-gallery-slide .owl-dots .owl-dot span' => 'height: {{SIZE}}{{UNIT}};',
							],
						]
					);

					$this->add_control(
			            'dots_border_radius',
			            [
			                'label' 		=> esc_html__( 'Border Radius', 'gimont' ),
			                'type' 			=> Controls_Manager::DIMENSIONS,
			                'size_units' 	=> [ 'px', '%' ],
			                'selectors' 	=> [
			                    '{{WRAPPER}} .ova-gallery-slide .owl-dots .owl-dot span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			                ],
			            ]
			        );

		        $this->end_controls_tab();

		        $this->start_controls_tab(
		            'tab_dots_active',
		            [
		                'label' => esc_html__( 'Active', 'gimont' ),
		            ]
		        );

		             $this->add_control(
						'dot_color_active',
						[
							'label' 	=> esc_html__( 'Color', 'gimont' ),
							'type' 		=> Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-gallery-slide .owl-dots .owl-dot.active span' => 'background-color: {{VALUE}}',
							],
						]
					);

					$this->add_responsive_control(
						'dots_width_active',
						[
							'label' 	=> esc_html__( 'Width', 'gimont' ),
							'type' 		=> Controls_Manager::SLIDER,
							'range' => [
								'px' => [
									'min' => 0,
									'max' => 100,
								],
							],
							'size_units' 	=> [ 'px' ],
							'selectors' 	=> [
								'{{WRAPPER}} .ova-gallery-slide .owl-dots .owl-dot.active span' => 'width: {{SIZE}}{{UNIT}};',
							],
						]
					);

					$this->add_responsive_control(
						'dots_height_active',
						[
							'label' 	=> esc_html__( 'Height', 'gimont' ),
							'type' 		=> Controls_Manager::SLIDER,
							'range' => [
								'px' => [
									'min' => 0,
									'max' => 100,
								],
							],
							'size_units' 	=> [ 'px' ],
							'selectors' 	=> [
								'{{WRAPPER}} .ova-gallery-slide .owl-dots .owl-dot.active span' => 'height: {{SIZE}}{{UNIT}};',
							],
						]
					);

					$this->add_control(
			            'dots_border_radius_active',
			            [
			                'label' 		=> esc_html__( 'Border Radius', 'gimont' ),
			                'type' 			=> Controls_Manager::DIMENSIONS,
			                'size_units' 	=> [ 'px', '%' ],
			                'selectors' 	=> [
			                    '{{WRAPPER}} .ova-gallery-slide .owl-dots .owl-dot.active span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			                ],
			            ]
			        );

		        $this->end_controls_tab();
			$this->end_controls_tabs();

        $this->end_controls_section();
        /* End Dots Style */
		
	}

	// Render Template Here
	protected function render() {

		$settings 	= $this->get_settings();

		$template 	= $settings['template'];
		$tab_item 	= $settings['tab_item'];

		$data_options['items']              = $settings['item_number'];
		$data_options['slideBy']            = $settings['slides_to_scroll'];
		$data_options['margin']             = $settings['margin_items'];
		$data_options['stagePadding']       = $settings['stagePadding'];
		$data_options['autoplayHoverPause'] = $settings['pause_on_hover'] === 'yes' ? true : false;
		$data_options['loop']               = $settings['infinite'] === 'yes' ? true : false;
		$data_options['autoplay']           = $settings['autoplay'] === 'yes' ? true : false;
		$data_options['autoplayTimeout']    = $settings['autoplay_speed'];
		$data_options['smartSpeed']         = $settings['smartspeed'];
		$data_options['dots']               = $settings['dot_control'] === 'yes' ? true : false;
		$data_options['rtl']				= is_rtl() ? true: false;

		 ?>

		 	<div class="ova-gallery-slide <?php echo esc_attr($template); ?>">

				<div class="gallery-slide-carousel owl-carousel owl-theme" data-options="<?php echo esc_attr(json_encode($data_options)) ?>">
					<?php if(!empty($tab_item)) : foreach ($tab_item as $items) : 
					
						$title       = $items['title'];
						$category    = $items['category'];

						// replace % to %% avoid printf error
						if(strpos($category, '%') !== false){
						    $category = str_replace('%', '%%', $category);
						}

						$img_url 	 = $items['image']['url'];
						$img_alt 	 = isset( $items['image']['alt'] ) ? $items['image']['alt'] : $title;

						$link        = $items['link'];
						$nofollow    = ( isset( $link['nofollow'] ) && $link['nofollow'] ) ? ' rel="nofollow"' : '';
						$target      = ( isset( $link['is_external'] ) && $link['is_external'] !== '' ) ? ' target="_blank"' : '';

					?>

						<div class="gallery-slide-img">

							<div class="gallery-img">
								<img src="<?php echo esc_url( $img_url ); ?>" alt="<?php echo esc_attr( $img_alt ); ?>">
							</div>

							<div class="overlay" data-fancybox="accommodation-gallery-slide" data-src="<?php echo esc_url( $img_url ); ?>"
							data-caption="<?php echo esc_attr( $title ); ?>"></div>

							<?php if( $template == "template3") { ?>
                            	<?php if ( !empty($link['url'])) : ?>	
								<a class="view-detail" href="<?php echo esc_url( $link['url'] ); ?>" aria-label="<?php esc_attr_e('View Detail','gimont'); ?>" <?php echo esc_attr( $target ); ?> <?php echo esc_attr( $nofollow ); ?>>
							    <?php endif; ?>
									<i aria-hidden="true" class="flaticonnew- flaticon-new-right"></i>
								<?php if ( !empty($link['url']) ) : ?>
							    </a>
						        <?php endif; ?>
					        <?php } ?>
                            
                            <div class="info-wrapper">

                            	<?php if( $template != "template3") { ?>
	                            	<?php if ( !empty($link['url'])) : ?>	
										<a class="view-detail" href="<?php echo esc_url( $link['url'] ); ?>" aria-label="<?php esc_attr_e('View Detail','gimont'); ?>" <?php echo esc_attr( $target ); ?> <?php echo esc_attr( $nofollow ); ?>>
									    <?php endif; ?>
											<i aria-hidden="true" class="flaticonnew- flaticon-new-right"></i>
										<?php if ( !empty($link['url']) ) : ?>
									    </a>
								    <?php endif; ?>
						        <?php } ?>

                            	<div class="info">
                            		<?php if( $template != "template2") { ?>
										<?php if ( !empty ($category)) : ?>
											<span class="category">
												<?php printf($category); ?>
											</span>
										<?php endif; ?>
									<?php } ?>
									<?php if ( !empty ($title)) : ?>
										<?php if ( !empty($link['url'])) : ?>	
										<a href="<?php echo esc_url( $link['url'] ); ?>" <?php echo esc_attr( $target ); ?> <?php echo esc_attr( $nofollow ); ?>>
									    <?php endif; ?>
										<h3 class="title">
											<?php echo esc_html($title); ?>
										</h3>
										<?php if ( !empty($link['url']) ) : ?>
									    </a>
								        <?php endif; ?>
									<?php endif; ?>
									<?php if( $template == "template2") { ?>
										<?php if ( !empty ($category)) : ?>
											<span class="category">
												<?php printf($category); ?>
											</span>
										<?php endif; ?>
									<?php } ?>
								</div>

                            </div>			

						</div>
					

					<?php endforeach; endif; ?>

				</div>

			</div>

		<?php
	}

	
}
$widgets_manager->register( new Gimont_Elementor_Gallery_Slide() );