<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Utils;
use Elementor\Group_Control_Border;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Gimont_Elementor_Testimonial_2 extends Widget_Base {

	public function get_name() {
		return 'gimont_elementor_testimonial_2';
	}

	public function get_title() {
		return esc_html__( 'Ova Testimonial 2', 'gimont' );
	}

	public function get_icon() {
		return 'eicon-testimonial';
	}

	public function get_categories() {
		return [ 'gimont' ];
	}

	public function get_script_depends() {
		return [ 'gimont-elementor-testimonial-2' ];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'gimont-elementor-testimonial', GIMONT_URI.'/assets/scss/elementor/testimonials/testimonial.css' );
		wp_enqueue_style( 'gimont-elementor-testimonial-2', GIMONT_URI.'/assets/scss/elementor/testimonials/testimonial-2.css' );
		return [];
	}
	
	// Add Your Controll In This Function
	protected function register_controls() {

		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Content', 'gimont' ),
			]
		);

			$this->add_control(
				'template',
				[
					'label' => esc_html__( 'Template', 'gimont' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'template_1',
					'options' => [
						'template_1' => esc_html__( 'Template 1', 'gimont' ),
						'template_2' => esc_html__( 'Template 2', 'gimont' ),
					],
				]
			);

			$this->add_control(
				'show_rating',
				[
					'label' => esc_html__( 'Show rating', 'gimont' ),
					'type' => Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'gimont' ),
					'label_off' => esc_html__( 'Hide', 'gimont' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);


			$this->add_control(
				'show_quote',
				[
					'label' => esc_html__( 'Show quote', 'gimont' ),
					'type' => Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'gimont' ),
					'label_off' => esc_html__( 'Hide', 'gimont' ),
					'return_value' => 'yes',
					'default' => 'no',
				]
			);

			$repeater = new \Elementor\Repeater();

				$repeater->add_control(
					'background_image',
					[
						'label' => esc_html__( 'Choose Backround Image', 'gimont' ),
						'type' => \Elementor\Controls_Manager::MEDIA,
						'default' => [
							'url' => \Elementor\Utils::get_placeholder_image_src(),
						],
					]
				);

				$repeater->add_control(
					'image_author',
					[
						'label'   => esc_html__( 'Author Image', 'gimont' ),
						'type'    => \Elementor\Controls_Manager::MEDIA,
						'default' => [
							'url' => Utils::get_placeholder_image_src(),
						],
					]
				);

				$repeater->add_control(
					'name_author',
					[
						'label'   => esc_html__( 'Author Name', 'gimont' ),
						'type'    => \Elementor\Controls_Manager::TEXT,
						'default' => 'Sarah albert',
					]
				);

				$repeater->add_control(
					'job',
					[
						'label'   => esc_html__( 'Job', 'gimont' ),
						'type'    => \Elementor\Controls_Manager::TEXT,
						'default' => esc_html__( 'CUSTOMER', 'gimont' ),
					]
				);

				$repeater->add_control(
					'testimonial',
					[
						'label'   => esc_html__( 'Testimonial ', 'gimont' ),
						'type'    => \Elementor\Controls_Manager::TEXTAREA,
						'default' => esc_html__( 'This is due to their excellent service, competitive pricing and customer support. It’s throughly refresing to get such a personal touch.', 'gimont' ),
					]
				);

				$this->add_control(
					'tab_item',
					[
						'label'       => esc_html__( 'Items Testimonial', 'gimont' ),
						'type'        => \Elementor\Controls_Manager::REPEATER,
						'fields'      => $repeater->get_controls(),
						'default' => [
							[
								'name_author' => 'Mike ronobs',
							],
							[
								'name_author' => 'Aleesha brown',
							],
							[
								'name_author' => 'Mike ronobs',
							],
							[
								'name_author' => 'Aleesha brown',
							],
						],
						'title_field' => '{{{ name_author }}}',
					]
				);

		$this->end_controls_section();


		/*****************************************************************
						START SECTION ADDITIONAL
		******************************************************************/

		$this->start_controls_section(
			'section_additional_options',
			[
				'label' => esc_html__( 'Additional Options', 'gimont' ),
			]
		);

			$this->add_control(
				'margin_items',
				[
					'label'   => esc_html__( 'Margin Right Items', 'gimont' ),
					'type'    => \Elementor\Controls_Manager::NUMBER,
					'default' => 30,
				]
			);

			$this->add_control(
				'item_number',
				[
					'label'       => esc_html__( 'Item Number', 'gimont' ),
					'type'        => \Elementor\Controls_Manager::NUMBER,
					'description' => esc_html__( 'Number Item', 'gimont' ),
					'default'     => 2,
				]
			);

			$this->add_control(
				'slides_to_scroll',
				[
					'label'       => esc_html__( 'Slides to Scroll', 'gimont' ),
					'type'        => \Elementor\Controls_Manager::NUMBER,
					'description' => esc_html__( 'Set how many slides are scrolled per swipe.', 'gimont' ),
					'default'     => 1,
				]
			);

			$this->add_control(
				'pause_on_hover',
				[
					'label'   => esc_html__( 'Pause on Hover', 'gimont' ),
					'type'    => \Elementor\Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'gimont' ),
						'no'  => esc_html__( 'No', 'gimont' ),
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'infinite',
				[
					'label'   => esc_html__( 'Infinite Loop', 'gimont' ),
					'type'    => \Elementor\Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'gimont' ),
						'no'  => esc_html__( 'No', 'gimont' ),
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'autoplay',
				[
					'label'   => esc_html__( 'Autoplay', 'gimont' ),
					'type'    => \Elementor\Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'gimont' ),
						'no'  => esc_html__( 'No', 'gimont' ),
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'autoplay_speed',
				[
					'label'     => esc_html__( 'Autoplay Speed', 'gimont' ),
					'type'      => \Elementor\Controls_Manager::NUMBER,
					'default'   => 3000,
					'step'      => 500,
					'condition' => [
						'autoplay' => 'yes',
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'smartspeed',
				[
					'label'   => esc_html__( 'Smart Speed', 'gimont' ),
					'type'    => \Elementor\Controls_Manager::NUMBER,
					'default' => 500,
				]
			);

		$this->end_controls_section();
		
		$this->start_controls_section(
			'section_content_style',
			[
				'label' => esc_html__( 'Content', 'gimont' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_responsive_control(
				'content_max_width',
				[
					'label' 		=> esc_html__( 'Max Width', 'gimont' ),
					'type' 			=> Controls_Manager::SLIDER,
					'size_units' 	=> [ 'px', '%' ],
					'range' => [
						'px' => [
							'min' 	=> 300,
							'max' 	=> 1170,
							'step' 	=> 1,
						],
						'%' => [
							'min' 	=> 0,
							'max' 	=> 100,
							'step' 	=> 1,
						]
					],
					'selectors' 	=> [
						'{{WRAPPER}} .ova-testimonial-2' => 'max-width: {{SIZE}}{{UNIT}};',
					],
				]
			);

		$this->end_controls_section();

		/* Item */
		$this->start_controls_section(
				'item_style_section',
				[
					'label' => esc_html__( 'Item', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'item_padding',
				[
					'label' => esc_html__( 'Padding', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-testimonial-2 .ova-testimonial' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'item_box_shadow',
					'selector' => '{{WRAPPER}} .ova-testimonial-2 .ova-testimonial',
				]
			);

			$this->add_control(
				'item_background',
				[
					'label' => esc_html__( 'Backround', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-testimonial-2 .ova-testimonial' => 'background: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		/* Job */
		$this->start_controls_section(
				'job_style_section',
				[
					'label' => esc_html__( 'Job', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_control(
				'job_reverse_position',
				[
					'label' => esc_html__( 'Reverse Position', 'gimont' ),
					'type' => Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'gimont' ),
					'label_off' => esc_html__( 'Hide', 'gimont' ),
					'return_value' => 'yes',
					'default' => 'no',
				]
			);

			$this->add_responsive_control(
				'job_margin',
				[
					'label' => esc_html__( 'Margin', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-testimonial-2 .ova-testimonial .author .job' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'job_typography',
					'selector' => '{{WRAPPER}} .ova-testimonial-2 .ova-testimonial .author .job',
				]
			);

			$this->add_control(
				'job_color',
				[
					'label' => esc_html__( 'Color', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-testimonial-2 .ova-testimonial .author .job' => 'color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		/* Name */
		$this->start_controls_section(
			'name_style_section',
			[
				'label' => esc_html__( 'Author Name', 'gimont' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_responsive_control(
				'name_margin',
				[
					'label' => esc_html__( 'Margin', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-testimonial-2 .ova-testimonial .author .name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'name_typography',
					'selector' => '{{WRAPPER}} .ova-testimonial-2 .ova-testimonial .author .name',
				]
			);

			$this->add_control(
				'name_color',
				[
					'label' => esc_html__( 'Color', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-testimonial-2 .ova-testimonial .author .name' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name' => 'author_border',
					'selector' => '{{WRAPPER}} .ova-testimonial-2 .ova-testimonial .author',
				]
			);

		$this->end_controls_section();

		/* Testimonial */
		$this->start_controls_section(
				'desc_style_section',
				[
					'label' => esc_html__( 'Testimonial', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'desc_margin',
				[
					'label' => esc_html__( 'Margin', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-testimonial-2 .ova-testimonial .desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'desc_typography',
					'selector' => '{{WRAPPER}} .ova-testimonial-2 .ova-testimonial .desc',
				]
			);

			$this->add_control(
				'desc_color',
				[
					'label' => esc_html__( 'Color', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-testimonial-2 .ova-testimonial .desc' => 'color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		/*************  SECTION NAV.  *******************/
		$this->start_controls_section(
			'section_nav',
			[
				'label' => esc_html__( 'Nav', 'gimont' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'nav_width',
				[
					'label' 		=> esc_html__( 'Size', 'gimont' ),
					'type' 			=> Controls_Manager::SLIDER,
					'size_units' 	=> [ 'px' ],
					'range' => [
						'px' => [
							'min' 	=> 1,
							'max' 	=> 300,
							'step' 	=> 1,
						]
					],
					'selectors' 	=> [
						'#nav-ova-testimonial-2 button' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
					],
				]
			);
			
			$this->add_control(
				'icon_size_nav',
				[
					'label' 		=> esc_html__( 'Icon Size', 'gimont' ),
					'type' 			=> Controls_Manager::SLIDER,
					'size_units' 	=> [ 'px' ],
					'range' => [
						'px' => [
							'min' 	=> 1,
							'max' 	=> 300,
							'step' 	=> 1,
						]
					],
					'selectors' 	=> [
						'#nav-ova-testimonial-2 button i' => 'font-size: {{SIZE}}{{UNIT}};',
					],
				]
			);	


			$this->start_controls_tabs(
					'nav_tabs'
				);

					$this->start_controls_tab(
						'style_normal_tab',
						[
							'label' => esc_html__( 'Normal', 'gimont' ),
						]
					);

						$this->add_control(
							'bg_icon_color',
							[
								'label'     => esc_html__( 'Icon', 'gimont' ),
								'type'      => Controls_Manager::COLOR,
								'selectors' => [
									'#nav-ova-testimonial-2 button i' => 'color : {{VALUE}};',
								],
							]
						);	

						$this->add_control(
							'nav__bg_color_',
							[
								'label'     => esc_html__( 'Background', 'gimont' ),
								'type'      => Controls_Manager::COLOR,
								'selectors' => [
									'#nav-ova-testimonial-2 button' => 'background-color : {{VALUE}};',
								],
							]
						);	

						$this->add_group_control(
							\Elementor\Group_Control_Border::get_type(),
							[
								'name' => 'nav_border',
								'selector' => '#nav-ova-testimonial-2 button',
							]
						);

					$this->end_controls_tab();

					$this->start_controls_tab(
						'style_hover_tab',
						[
							'label' => esc_html__( 'Hover', 'gimont' ),
						]
					);

						$this->add_control(
							'nav__bg_icon_color_hover',
							[
								'label'     => esc_html__( 'Icon', 'gimont' ),
								'type'      => Controls_Manager::COLOR,
								'selectors' => [
									'#nav-ova-testimonial-2 button:hover i' => 'color : {{VALUE}};',
								],
							]
						);

						$this->add_control(
							'nav__bg_color_hover',
							[
								'label'     => esc_html__( 'Background', 'gimont' ),
								'type'      => Controls_Manager::COLOR,
								'selectors' => [
									'#nav-ova-testimonial-2 button:hover' => 'background-color : {{VALUE}};',
								],
							]
						);

						$this->add_group_control(
							\Elementor\Group_Control_Border::get_type(),
							[
								'name' => 'nav_border_hover',
								'selector' => '#nav-ova-testimonial-2 button:hover',
							]
						);

					$this->end_controls_tab();

				$this->end_controls_tabs();

		$this->end_controls_section();

	}

	// Render Template Here
	protected function render() {
		$settings 	= $this->get_settings();

		$tab_item 	= $settings['tab_item'];

		$template 	 = $settings['template'];
		$show_rating = $settings['show_rating'];
		$show_quote  = $settings['show_quote'];

		$job_reverse_position = $settings['job_reverse_position'];
		
		$data_options['items']              = $settings['item_number'];
		$data_options['slideBy']            = $settings['slides_to_scroll'];
		$data_options['margin']             = $settings['margin_items'];
		$data_options['autoplayHoverPause'] = $settings['pause_on_hover'] === 'yes' ? true : false;
		$data_options['loop']               = $settings['infinite'] === 'yes' ? true : false;
		$data_options['autoplay']           = $settings['autoplay'] === 'yes' ? true : false;
		$data_options['autoplayTimeout']    = $settings['autoplay_speed'];
		$data_options['smartSpeed']         = $settings['smartspeed'];
		$data_options['rtl']				= is_rtl() ? true : false;

		?>

		<div class="ova-testimonial-2 <?php echo esc_attr( $template ); ?>">
			<div class="slide-testimonial" data-options="<?php echo esc_attr(json_encode($data_options)) ?>">
				<div class="owl-carousel owl-theme">
					<?php if ( ! empty( $tab_item ) ) : foreach( $tab_item as $item ):

						$testimonial 			= $item['testimonial'];
						$name_author 			= $item['name_author'];
						$background_image 		= $item['background_image'];
						$background_image_url 	= $background_image ? $background_image['url'] : Utils::get_placeholder_image_src();
						$image_author 			= $item['image_author'];
						$image_author_url 		= $image_author ? $image_author['url'] : Utils::get_placeholder_image_src();
						$image_author_alt 		= $name_author;
						$image_author_title 	= $name_author;
						$job 					= $item['job'];

						if ( $image_author && $image_author['id'] ) {
							$image_author_alt = get_post_meta( $image_author['id'], '_wp_attachment_image_alt', true);
							$image_author_title = get_the_title( $image_author['id'] );
						}

					?>
						
						<div class="item">
							<div class="ova-testimonial">
								<div class="background-img" style="background-image: url('<?php echo esc_url( $background_image_url ); ?>');"></div>
								<?php if($template == 'template_2') { ?>
									<div class="img">
										<img src="<?php echo esc_url( $image_author_url ); ?>" alt="<?php echo esc_attr( $image_author_alt ); ?>">
									</div>
								<?php } ?>
								<div class="wrapper">
									<div class="author">
										<?php if($template == 'template_1') { ?>
											<div class="img">
												<img src="<?php echo esc_url( $image_author_url ); ?>" alt="<?php echo esc_attr( $image_author_alt ); ?>">
											</div>
										<?php } ?>
										<div class="info">
											<?php if($job && ($job_reverse_position != 'yes')) : ?>
												<p class="job"><?php echo esc_html( $job ); ?></p>
											<?php endif; ?>

											<h3 class="name"><?php echo esc_html( $name_author ); ?></h3>

											<?php if($job && ($job_reverse_position == 'yes')) : ?>
												<p class="job"><?php echo esc_html( $job ); ?></p>
											<?php endif; ?>

											<?php if($show_rating == 'yes') : ?>
												<div class="rating">
													<i class="fas fa-star"></i>
													<i class="fas fa-star"></i>
													<i class="fas fa-star"></i>
													<i class="fas fa-star"></i>
													<i class="fas fa-star"></i>
												</div>
											<?php endif; ?>
										</div>
									</div>

									<?php if ( $testimonial ): ?>
										<p class="desc"><?php echo esc_html( $testimonial ); ?></p>
									<?php endif; ?>
								</div>

								<?php if($show_quote == 'yes') : ?>
									<div class="quote">
										<i class="ovaicon ovaicon-close"></i>
									</div>
								<?php endif; ?>
							</div>
						</div>
						
					<?php endforeach; endif; ?>
				</div>
			</div>
		</div>

		<?php
	}

	
}
$widgets_manager->register( new Gimont_Elementor_Testimonial_2() );