<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

do_action( 'give_before_single_form' );

if ( post_password_required() ) {
	echo get_the_password_form();
	return;
}

$id = get_the_ID();

$thumbnail   	= wp_get_attachment_image_url(get_post_thumbnail_id() , 'large' );
if ( $thumbnail == '') {
    $thumbnail  =  \Elementor\Utils::get_placeholder_image_src();
}

$ova_met_contact_form_give = get_post_meta( $id, 'ova_met_contact_form_give', true ) ? get_post_meta( $id, 'ova_met_contact_form_give', true ) : '';

$ova_met_media_give 	= get_post_meta( $id, 'ova_met_media_give', true );
$ova_met_gallery_give 	= get_post_meta( $id, 'ova_met_gallery_give', true );

$gallery_data = array();

if ( $ova_met_gallery_give && is_array( $ova_met_gallery_give ) ) {
    foreach( $ova_met_gallery_give as $img_id => $image_url ) {
        $image_caption  = wp_get_attachment_caption( $img_id );

        if ( !$image_caption ) {
            $image_caption = get_post_meta( $img_id, '_wp_attachment_image_alt', true );
        }

        if ( !$image_caption ) {
            $image_caption = get_the_title( $img_id );
        }

        array_push( $gallery_data, array(
            'src'       => $image_url,
            'caption'   => $image_caption,
            'thumb'     => $image_url,
            'type'      => 'image',
        ));
    }
}

$show_goal 				= give_get_meta( $id, '_give_goal_option', true ) ? get_post_meta( $id, '_give_goal_option', true ) : '';
$gimont_progress_stats  = apply_filters( 'gimont_progress_stats', $id );

$show_content 			= give_get_meta( $id, '_give_display_content', true );
$content 				= get_post_meta( $id, '_give_form_content', true );
$gimont_count_donor 	= apply_filters( 'gimont_count_donor', $id);

$content                = get_the_content();

$show_sidebar			= get_theme_mod( 'single_donation_show_sidebar', 'yes' );

if ( isset($_GET['show_sidebar']) ) {
	$show_sidebar = $_GET['show_sidebar'];
}

?>


<div id="give-form-<?php the_ID(); ?>-content" <?php post_class(); ?>>	

	<div class="<?php echo apply_filters( 'give_forms_single_summary_classes', 'summary entry-summary' ); ?>">

		<div class="content_fist">
			
			<div class="progress-wrapper">
				<div class="give-progress">
					<?php if ( $show_goal != 'disabled' ) { ?>
						<span class="project-percent" data-percent=<?php echo esc_attr( $gimont_progress_stats['progress'] ); ?>  >	
							<?php if ($show_goal != 'disabled') { ?>
								<span class="percentage">
									<?php echo esc_html( $gimont_progress_stats['progress'] . '%' ); ?>
								</span>
							<?php } ?>
						</span>
					<?php } ?>
				</div>
				<div class="raised">
					<div class="income">
						<span><?php esc_html_e( 'Raised', 'gimont' ); ?></span>
						<span class="money"><?php echo esc_html( $gimont_progress_stats['actual'] ); ?></span>
					</div>

					<?php if ($show_goal != 'disabled') { ?>
						<div class="goal">
							<span><?php esc_html_e( 'Goal', 'gimont' ); ?></span>
							<span class="money"><?php echo esc_html( $gimont_progress_stats['goal'] ); ?></span>
						</div>
					<?php } ?>
				</div>
			</div>
		 
			<div class="image_future">

				<div class="thumbnail">
					<img src="<?php echo esc_url( $thumbnail ); ?>" alt="<?php the_title(); ?>">
				</div>

				<div class="media">

					<?php if ( $ova_met_gallery_give ) { ?>
						<div class="gallery" data-gallery="<?php echo esc_attr( json_encode( $gallery_data ) );?>">
							<i class="fas fa-photo-video"></i>
						</div>
					<?php } ?>

					<?php if ( $ova_met_media_give ) { ?>
						<a href="<?php echo esc_url( $ova_met_media_give ); ?>" data-fancybox="give-video" data-src="<?php echo esc_attr( $ova_met_media_give ); ?>" class="video" aria-label="<?php esc_attr_e('Give Video','gimont');?>">
							<i class="fas fa-play"></i>
						</a>
					<?php } ?>
				</div>

				<div class="share_social icon_give">
					<?php echo apply_filters( 'ova_share_social', get_the_permalink(), get_the_title() ); ?>
				</div>

				<?php 
					$give_type  = !is_wp_error( get_the_terms( $id, 'give_forms_category') ) ? get_the_terms( $id, 'give_forms_category') : '' ;

					$value_give_type = array();
					if ( $give_type != '' ) {
						foreach ( $give_type as $value ) {
							$value_give_type[] = $value->term_id ? '<a class="give_type" href="'.get_term_link($value->term_id).'">' .$value->name. '</a>': "";
						}
					}
				?>
				<?php if ( !empty(array_filter($value_give_type)) ) { ?>
					<div class="post_cat">
						<?php echo implode( '&nbsp;', $value_give_type ); ?>
					</div>
				<?php } ?>

			</div>

			<div class="donation-and-tab">

				<div class="donation">
					<?php if ( $gimont_progress_stats ) { ?>
						<div class="ova_info_donation" data-donate_now_btn="<?php esc_html_e( 'Donate Now', 'gimont' ); ?>">
							<?php
								remove_action( 'give_single_form_summary', 'give_template_single_title', 5 );
								remove_action( 'give_pre_form_output', 'give_form_content', 10 );
								remove_action( 'give_pre_form', 'give_show_goal_progress', 10 );
								do_action( 'give_single_form_summary' );

								/* Add action */
								add_action( 'give_pre_form_output', 'give_form_content', 10, 2 );
								add_action( 'give_pre_form', 'give_show_goal_progress', 10, 2 );
							?>
						</div>
					<?php } ?>
				</div>

				<?php if( ! empty( $content ) || comments_open($id) || get_comments_number($id) || ! empty( $ova_met_contact_form_give ) || ($gimont_count_donor != 0)  ) { ?>
					<div class="tab-Location">

						<ul class="give_nav give_nav-tabs" role="tablist">

							<?php if( ! empty( $content ) ) { ?>
							 	<li class="give_nav-item active">
							    	<a class="give_nav-link second_font " data-href="#description" role="tab">
							    		<?php esc_html_e('Description','gimont')?>
							    	</a>
							  	</li>
							<?php } ?>
	                        
	                        <?php if( $gimont_count_donor != 0 ) { ?>
							    <li class="give_nav-item">
							    	<a class="give_nav-link second_font " data-href="#give_donor" role="tab">
							    		<?php esc_html_e('Donor','gimont')?>
							    	</a>
							  	</li>
	                        <?php } ?>

	                        <?php if( ! empty( $ova_met_contact_form_give ) ) { ?>
							  	 <li class="give_nav-item">
							    	<a class="give_nav-link second_font " data-href="#give_contact" role="tab">
							    		<?php esc_html_e('Contact','gimont')?>
							    	</a>
							  	</li>
							<?php } ?>

						  	<?php if ( comments_open($id) || get_comments_number($id) ) { ?>
							  	<li class="give_nav-item">
							    	<a class="give_nav-link second_font" data-href="#give_comment" role="tab">
							    		<?php esc_html_e('Comment','gimont')?>
							    	</a>
							 	</li>
						 	<?php } ?>

						</ul>

						<!-- Tab panel -->
						<div class="tab-content">

							<?php if( ! empty( $content ) ) { ?>
								<div role="tabpanel" class="give_tab-pane active" id="description">
									<?php the_content() ; ?>
								</div>
						  	<?php } ?>

						  	<?php if( $gimont_count_donor != 0 ) { ?>
							  	<div role="tabpanel" class="give_tab-pane"  id="give_donor">
									<?php echo do_shortcode( '[give_donor_wall form_id="'.$id.'"]' ); ?>
								</div>
							<?php } ?>
	                        
	                        <?php if( ! empty( $ova_met_contact_form_give ) ) { ?>
								<div role="tabpanel" class="give_tab-pane" id="give_contact">
									<?php echo do_shortcode( $ova_met_contact_form_give ); ?>
								</div>
	                        <?php } ?>
	                        
					  		<?php  if ( comments_open($id) || get_comments_number($id) ) { ?>
								<div role="tabpanel" class="give_tab-pane" id="give_comment">
									<?php comments_template(); ?>
								</div>
							<?php } ?>	
				 		 	
						</div>
					</div>
				<?php } ?>

			</div>	

		</div>

	</div>

	<?php if ( give_is_setting_enabled( give_get_option( 'form_sidebar' ) ) && $show_sidebar == 'yes' ) { ?>
		<div class="sidebar sidebar_give">
			<?php
				do_action( 'give_before_single_form_summary' );
			?>
		</div>
	<?php } ?>

</div>