<?php

class Gimont_Elementor {
	
	function __construct() {
            
		// Register Header Footer Category in Pane
	    add_action( 'elementor/elements/categories_registered', array( $this, 'gimont_add_category' ) );

	    add_action( 'elementor/frontend/after_register_scripts', array( $this, 'gimont_enqueue_scripts' ) );
		
		add_action( 'elementor/widgets/register', array( $this, 'gimont_include_widgets' ) );
		
		add_filter( 'elementor/controls/animations/additional_animations', array( $this, 'gimont_add_animations'), 10 , 0 );

		add_action( 'wp_print_footer_scripts', array( $this, 'gimont_enqueue_footer_scripts' ) );

		// load icons
		add_filter( 'elementor/icons_manager/additional_tabs', array( $this, 'gimont_icons_filters_new' ), 9999999, 1 );

		// Add fonts ( Reey )
		add_filter( 'elementor/fonts/groups', array( $this, 'gimont_font_groups' ), 9999999, 1 );
		add_filter( 'elementor/fonts/additional_fonts', array( $this, 'gimont_additional_fonts' ), 9999999, 1 );

		// Add icons social custom
		add_action( 'elementor/element/social-icons/section_social_hover/after_section_end', array( $this, 'gimont_social_icons_custom' ), 10, 2 );

		// Add text editor custom control style
		add_action( 'elementor/element/text-editor/section_style/after_section_end', array( $this, 'gimont_text_editor_custom' ), 10, 2 );

		// Add accordion custom control style
		add_action( 'elementor/element/accordion/section_toggle_style_content/after_section_end', array( $this, 'gimont_accordion_custom' ), 10, 2 );

		// Add customize icon box 
		add_action( 'elementor/element/icon-box/section_style_content/after_section_end', array( $this, 'gimont_icon_box_custom' ), 10, 2 );

		// Add customize image box 
		add_action( 'elementor/element/image-box/section_style_content/after_section_end', array( $this, 'gimont_image_box_custom' ), 10, 2 );

		// Remove animations style from Elementor
		add_action( 'wp_enqueue_scripts', array( $this, 'gimont_remove_registered_styles' ) );
	}

	
	function gimont_add_category(  ) {

	    \Elementor\Plugin::instance()->elements_manager->add_category(
	        'hf',
	        [
	            'title' => __( 'Header Footer', 'gimont' ),
	            'icon' => 'fa fa-plug',
	        ]
	    );

	    \Elementor\Plugin::instance()->elements_manager->add_category(
	        'gimont',
	        [
	            'title' => __( 'Gimont', 'gimont' ),
	            'icon' => 'fa fa-plug',
	        ]
	    );

	}

	function gimont_enqueue_scripts(){
        
        $files = glob(get_theme_file_path('/assets/js/elementor/*.js'));
        
        foreach ($files as $file) {
            $file_name = wp_basename($file);
            $handle    = str_replace(".js", '', $file_name);
            $src       = get_theme_file_uri('/assets/js/elementor/' . $file_name);
            if (file_exists($file)) {
                wp_register_script( 'gimont-elementor-' . $handle, $src, ['jquery'], false, true );
            }
        }

	}

	function gimont_include_widgets( $widgets_manager ) {
        $files = glob(get_theme_file_path('elementor/widgets/*.php'));
        foreach ($files as $file) {
            $file = get_theme_file_path('elementor/widgets/' . wp_basename($file));
            if (file_exists($file)) {
                require_once $file;
            }
        }
    }

    function gimont_add_animations(){
    	$animations = array(
            'Gimont' => array(
                'ova-move-up' 		=> esc_html__( 'Move Up', 'gimont' ),
                'ova-move-down' 	=> esc_html__( 'Move Down', 'gimont' ),
                'ova-move-left'     => esc_html__( 'Move Left', 'gimont' ),
                'ova-move-right'    => esc_html__( 'Move Right', 'gimont' ),
                'ova-scale-up'      => esc_html__( 'Scale Up', 'gimont' ),
                'ova-flip'          => esc_html__( 'Flip', 'gimont' ),
                'ova-helix'         => esc_html__( 'Helix', 'gimont' ),
                'ova-popup'			=> esc_html__( 'PopUp','gimont' )
            ),
        );

        return $animations;
    }

	function gimont_enqueue_footer_scripts(){
		// Font Icon
	    wp_enqueue_style('ovaicon', GIMONT_URI.'/assets/libs/ovaicon/font/ovaicon.css', array(), null);

	    // Gimonticon
		wp_enqueue_style('gimonticon', GIMONT_URI.'/assets/libs/gimonticon/font/flaticon_gimont.css', array(), null);

		// Flaticon
		wp_enqueue_style('flaticon', GIMONT_URI.'/assets/libs/flaticon/font/flaticon_giamont.css', array(), null);

		// Flaticon new
		wp_enqueue_style('flaticon_new', GIMONT_URI.'/assets/libs/flaticon_new/font/flaticon_new.css', array(), null);

		// Flaticon new 2
		wp_enqueue_style('flaticon_new2', GIMONT_URI.'/assets/libs/flaticon_new2/font/flaticon_new2.css', array(), null);
	}

	function gimont_font_groups( $args = array() ) {

		$groups['gimont'] = esc_html__( 'Gimont', 'gimont' );
		return array_merge( $args, $groups );
	}

	function gimont_additional_fonts( $args = array() ) {

		$fonts['Reey'] 	= 'gimont';

		return array_merge( $args, $fonts );
	}

	public function gimont_icons_filters_new( $tabs = array() ) {

		$newicons = [];
		$font_data['json_url'] = GIMONT_URI.'/assets/libs/ovaicon/ovaicon.json';
		$font_data['name'] = 'ovaicon';

		$newicons[ $font_data['name'] ] = [
			'name'          => $font_data['name'],
			'label'         => esc_html__( 'Default', 'gimont' ),
			'url'           => '',
			'enqueue'       => '',
			'prefix'        => 'ovaicon-',
			'displayPrefix' => '',
			'ver'           => '1.0',
			'fetchJson'     => $font_data['json_url'],
			
		];

		// Gimonticon
		$gimonticon_data['json_url'] = GIMONT_URI.'/assets/libs/gimonticon/gimonticon.json';
		$gimonticon_data['name'] = 'gimonticon';

		$newicons[ $gimonticon_data['name'] ] = [
			'name'          => $gimonticon_data['name'],
			'label'         => esc_html__( 'Gimonticon', 'gimont' ),
			'url'           => '',
			'enqueue'       => '',
			'prefix'        => 'gimonticon-',
			'displayPrefix' => '',
			'ver'           => '1.0',
			'fetchJson'     => $gimonticon_data['json_url'],
		];

		// Flaticon
		$flaticon_data['json_url'] = GIMONT_URI.'/assets/libs/flaticon/flaticon.json';
		$flaticon_data['name'] = 'flaticon2';

		$newicons[ $flaticon_data['name'] ] = [
			'name'          => $flaticon_data['name'],
			'label'         => esc_html__( 'Flaticon', 'gimont' ),
			'url'           => '',
			'enqueue'       => '',
			'prefix'        => 'flaticon-',
			'displayPrefix' => '',
			'ver'           => '1.0',
			'fetchJson'     => $flaticon_data['json_url'],
		];

		// Flaticon New
		$flaticon_new_data['json_url'] = GIMONT_URI.'/assets/libs/flaticon_new/flaticon_new.json';
		$flaticon_new_data['name'] = 'flaticon';

		$newicons[ $flaticon_new_data['name'] ] = [
			'name'          => $flaticon_new_data['name'],
			'label'         => esc_html__( 'Flaticon New', 'gimont' ),
			'url'           => '',
			'enqueue'       => '',
			'prefix'        => 'flaticon-new-',
			'displayPrefix' => '',
			'ver'           => '1.0',
			'fetchJson'     => $flaticon_new_data['json_url'],
		];

		// Flaticon New 2
		$flaticon_new2_data['json_url'] = GIMONT_URI.'/assets/libs/flaticon_new2/flaticon_new2.json';
		$flaticon_new2_data['name'] = 'flaticon_new2';

		$newicons[ $flaticon_new2_data['name'] ] = [
			'name'          => $flaticon_new2_data['name'],
			'label'         => esc_html__( 'Flaticon New 2', 'gimont' ),
			'url'           => '',
			'enqueue'       => '',
			'prefix'        => 'flaticon-new2-',
			'displayPrefix' => '',
			'ver'           => '1.0',
			'fetchJson'     => $flaticon_new2_data['json_url'],
		];


		return array_merge( $tabs, $newicons );

	}

	function gimont_social_icons_custom ( $element, $args ) {
		/** @var \Elementor\Element_Base $element */
		$element->start_controls_section(
			'ova_social_icons',
			[
				'tab' 	=> \Elementor\Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Ova Social Icon', 'gimont' ),
			]
		);

			$element->add_responsive_control(
	            'ova_social_icons_display',
	            [
	                'label' 	=> esc_html__( 'Display', 'gimont' ),
	                'type' 		=> \Elementor\Controls_Manager::CHOOSE,
	                'options' 	=> [
	                    'inline-block' => [
	                        'title' => esc_html__( 'Block', 'gimont' ),
	                        'icon' 	=> 'eicon-h-align-left',
	                    ],
	                    'inline-flex' => [
	                        'title' => esc_html__( 'Flex', 'gimont' ),
	                        'icon' 	=> 'eicon-h-align-center',
	                    ],
	                ],
	                'selectors' => [
	                    '{{WRAPPER}} .elementor-icon.elementor-social-icon' => 'display: {{VALUE}}',
	                ],
	            ]
	        );

		$element->end_controls_section();
	}

	// Ova text-editor custom 
    function gimont_text_editor_custom( $element, $args ) {
		/** @var \Elementor\Element_Base $element */
		$element->start_controls_section(
			'ova_tabs',
			[
				'tab' 	=> \Elementor\Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Ova Text Editor', 'gimont' ),
			]
		);

			$element->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'link_typography',
					'selector' => '{{WRAPPER}} a',
				]
			);
            
            $element->add_control(
	            'link_color',
	            [
	                'label' 	=> esc_html__( 'Link Color', 'gimont' ),
	                'type' 		=> \Elementor\Controls_Manager::COLOR,
	                'selectors' => [
	                    '{{WRAPPER}} a' => 'color: {{VALUE}};',
	                ],
	            ]
	        );

	        $element->add_control(
	            'link_color_hover',
	            [
	                'label' 	=> esc_html__( 'Link Color Hover', 'gimont' ),
	                'type' 		=> \Elementor\Controls_Manager::COLOR,
	                'selectors' => [
	                    '{{WRAPPER}} a:hover' => 'color: {{VALUE}};',
	                ],
	            ]
	        );

			$element->add_responsive_control(
				'text_margin',
				[
					'label' 		=> esc_html__( 'Margin', 'gimont' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' 	=> [ 'px', '%', 'em' ],
					'selectors' 	=> [
					'{{WRAPPER}}  p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$element->add_responsive_control(
		        'text_padding',
		        [
		            'label' 		=> esc_html__( 'Padding', 'gimont' ),
		            'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
		            'size_units' 	=> [ 'px', '%', 'em' ],
		            'selectors' 	=> [
		             '{{WRAPPER}}  p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		            ],
		         ]
		    );

		$element->end_controls_section();
	} 

	// accordion custom 
	function gimont_accordion_custom( $element, $args ) {
    	/** @var \Elementor\Element_Base $element */
		$element->start_controls_section(
			'ova_accordion',
			[
				'tab' 	=> \Elementor\Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Ova Accordion', 'gimont' ),
			]
		);

			// Accordion item options
	        $element->add_control(
				'accordion_item_options',
				[
					'label' 	=> esc_html__( 'Item Options', 'gimont' ),
					'type' 		=> \Elementor\Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);

				$element->add_control(
					'accordion_item_background_color',
					[
						'label' => esc_html__( 'Background Color', 'gimont' ),
						'type' => \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .elementor-accordion .elementor-accordion-item' => 'background-color: {{VALUE}}',
						],
					]
				);

		        $element->add_responsive_control(
		            'accordion_item_margin',
		            [
		                'label' 		=> esc_html__( 'Margin', 'gimont' ),
		                'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
		                'size_units' 	=> [ 'px', '%', 'em' ],
		                'selectors' 	=> [
		                    '{{WRAPPER}} .elementor-accordion .elementor-accordion-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		                ],
		            ]
		        );

		        $element->add_control(
		            'accordion_item_border_radius',
		            [
		                'label' 		=> esc_html__( 'Border Radius', 'gimont' ),
		                'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
		                'size_units' 	=> [ 'px', '%' ],
		                'selectors' 	=> [
		                    '{{WRAPPER}} .elementor-accordion .elementor-accordion-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		                ],
		            ]
		        );

			// Title options
			$element->add_control(
				'title_options',
				[
					'label' 	=> esc_html__( 'Title Options', 'gimont' ),
					'type' 		=> \Elementor\Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);

		        $element->add_group_control(
		            \Elementor\Group_Control_Border::get_type(), [
		                'name' 		=> 'title_active_border',
		                'selector' 	=> '{{WRAPPER}} .elementor-accordion .elementor-tab-title , {{WRAPPER}} .elementor-accordion .elementor-tab-title.elementor-active',
		            ]
		        );

		        $element->add_control(
					'border_color_title_active',
					[
						'label' => esc_html__( 'Title Active Border Color', 'gimont' ),
						'type' => \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .elementor-accordion .elementor-tab-title.elementor-active' => 'border-color: {{VALUE}}',
						],
					]
				);

		    // Icon options
	        $element->add_control(
				'icon_heading',
				[
					'label' => esc_html__( 'Icon', 'gimont' ),
					'type' => \Elementor\Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);

				$element->add_responsive_control(
					'icon_size',
					[
						'label' => esc_html__( 'Size', 'gimont' ),
						'type' => \Elementor\Controls_Manager::SLIDER,
						'size_units' => [ 'px', '%', 'em', 'rem' ],
						'range' => [
							'px' => [
								'min' => 0,
								'max' => 100,
								'step' => 1,
							],
							'%' => [
								'min' => 0,
								'max' => 100,
							],
						],
						'selectors' => [
						  '{{WRAPPER}} .elementor-accordion .elementor-tab-title .elementor-accordion-icon i' => 'font-size: {{SIZE}}{{UNIT}};',
						],
					]
				);

				$element->add_responsive_control(
					'icon_margin',
					[
						'label' => esc_html__( 'Margin', 'gimont' ),
						'type' => \Elementor\Controls_Manager::DIMENSIONS,
						'size_units' => [ 'px', '%', 'em', 'rem' ],
						'selectors' => [
							'{{WRAPPER}} .elementor-accordion .elementor-tab-title .elementor-accordion-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						],
					]
				);

		$element->end_controls_section();
    
	} 

	public function gimont_icon_box_custom($element, $args){

		$element->start_controls_section(
			'ova_icon_box_customize',
			[
				'tab' 	=> \Elementor\Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Ova Icon Box', 'gimont' ),
			]
		);

			$element->add_control(
				'icon_heading',
				[
					'label' => esc_html__( 'Icon', 'gimont' ),
					'type' => \Elementor\Controls_Manager::HEADING,
				]
			);

			$element->add_group_control(
				\Elementor\Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'icon_box_shadow',
					'selector' => '{{WRAPPER}} .elementor-icon',
				]
			);

	        $element->add_control(
				'content_heading',
				[
					'label' => esc_html__( 'Content', 'gimont' ),
					'type' => \Elementor\Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);

			$element->add_control(
				'title_color_hover',
				[
					'label' => esc_html__( 'Title Color Hover', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .elementor-widget-container:hover .elementor-icon-box-title' => 'color: {{VALUE}}',
					],
				]
			);

			$element->add_control(
				'description_color_hover',
				[
					'label' => esc_html__( 'Description Color Hover', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .elementor-widget-container:hover .elementor-icon-box-description' => 'color: {{VALUE}}',
					],
				]
			);

			$element->add_responsive_control(
				'title_margin',
				[
					'label' 		=> esc_html__( 'Title Margin', 'gimont' ),
					'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' 	=> [ 'px', '%', 'em' ],
					'selectors' 	=> [
					'{{WRAPPER}}  .elementor-icon-box-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

		$element->end_controls_section();
	}

	// Image Box custom 
	public function gimont_image_box_custom($element, $args){

		$element->start_controls_section(
			'ova_image_box_customize',
			[
				'tab' 	=> \Elementor\Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Ova Image Box', 'gimont' ),
			]
		);

			$element->add_control(
				'box_background_color',
				[
					'label' => esc_html__( 'Background Color', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .elementor-image-box-wrapper' => 'background-color: {{VALUE}}',
					],
				]
			);

			$element->add_control(
	            'box_border_radius',
	            [
	                'label' 		=> esc_html__( 'Border Radius', 'gimont' ),
	                'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
	                'size_units' 	=> [ 'px', '%' ],
	                'selectors' 	=> [
	                    '{{WRAPPER}} .elementor-image-box-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; overflow: hidden;',
	                ],
	            ]
	        );

	        $element->add_control(
	            'box_content_padding',
	            [
	                'label' 		=> esc_html__( 'Content Padding', 'gimont' ),
	                'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
	                'size_units' 	=> [ 'px', '%' ],
	                'selectors' 	=> [
	                    '{{WRAPPER}} .elementor-image-box-wrapper .elementor-image-box-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; overflow: hidden;',
	                ],
	            ]
	        );

	        $element->add_control(
	            'box_title_margin',
	            [
	                'label' 		=> esc_html__( 'Title Margin', 'gimont' ),
	                'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
	                'size_units' 	=> [ 'px', '%' ],
	                'selectors' 	=> [
	                    '{{WRAPPER}} .elementor-image-box-wrapper .elementor-image-box-content .elementor-image-box-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; overflow: hidden;',
	                ],
	            ]
	        );

	        
	        $element->add_responsive_control(
				'box_image_width',
				[
					'label' => esc_html__( 'Image Width', 'gimont' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'em', 'rem' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 600,
							'step' => 1,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
					  '{{WRAPPER}} .elementor-image-box-wrapper .elementor-image-box-img img' => 'width: {{SIZE}}{{UNIT}}; min-width: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$element->add_responsive_control(
				'box_image_height',
				[
					'label' => esc_html__( 'Image Height', 'gimont' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'em', 'rem' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 600,
							'step' => 1,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
					  '{{WRAPPER}} .elementor-image-box-wrapper .elementor-image-box-img img' => 'height: {{SIZE}}{{UNIT}}; object-fit: cover;',
					],
				]
			);

		$element->end_controls_section();
	}
    
	// Remove animations style from Elementor
	public function gimont_remove_registered_styles() {
		// Deregister the stylesheet by handle
	    foreach ( $this->gimont_add_animations() as $animations ) {
	    	if ( !empty( $animations ) && is_array( $animations ) ) {
	    		foreach ( array_keys( $animations ) as $animation ) {
	    			wp_deregister_style( 'e-animation-'.$animation );
	    			wp_enqueue_style( 'e-animation-'.$animation, GIMONT_URI.'/assets/scss/none.css', array(), null);
	    		}
	    	}
	    }
	}
}

return new Gimont_Elementor();