<?php
namespace ova_sev_elementor\Widgets;

use Elementor\Widget_Base;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class ova_sev_items extends Widget_Base {

	public function get_name() {
		return 'ova_sev_items';
	}

	public function get_title() {
		return esc_html__( 'Service Items', 'ova-sev' );
	}

	public function get_icon() {
		return 'eicon-posts-grid';
	}

	public function get_categories() {
		return [ 'ovatheme_service' ];
	}

	public function get_script_depends() {
		return [ '' ];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'ova-sev-items', OVASEV_PLUGIN_URI.'/assets/css/elementor/sev-items.css', array(), null);
		return [];
	}

	protected function ova_sev_categories() {

		$cate_args = array(
			'taxonomy' => 'cat_sev',
			'orderby' => 'name',
			'order'   => 'ASC'
		);

		$categories = get_categories( $cate_args );
		$new_category = array( 'all'=> esc_html__('All', 'ova-sev') );
		if ( $categories ) {
			foreach ($categories as $key => $cate) {
				$new_category[$cate->slug] = $cate->name;
			}
		}
		return $new_category;
	}

	protected function register_controls() {

		/* Service */
		$this->start_controls_section(
				'sev_section',
				[
					'label' => esc_html__( 'Service', 'ova-sev' ),
					'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				]
			);

			$categories = $this->ova_sev_categories();

			$this->add_control(
				'cate',
				[
					'label' => esc_html__( 'Category', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'all',
					'options' => $categories,
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'columns',
				[
					'label' => esc_html__( 'Columns', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'three_columns',
					'options' => [
						'two_columns' => esc_html__( '2', 'ova-sev' ),
						'three_columns' => esc_html__( '3', 'ova-sev' ),
						'four_columns' => esc_html__( '4', 'ova-sev' ),
					],
				]
			);

			$this->add_control(
				'order',
				[
					'label' => esc_html__( 'Order', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'DESC',
					'options' => [
						'ASC' => esc_html__( 'Ascending', 'ova-sev' ),
						'DESC' => esc_html__( 'Descending', 'ova-sev' ),
					],
				]
			);

			$this->add_control(
				'order_by',
				[
					'label' => esc_html__( 'Order By', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'date',
					'options' => [
						'ID'  	=> esc_html__( 'ID', 'ova-sev' ),
						'date'  => esc_html__( 'Date', 'ova-sev' ),
						'title' => esc_html__( 'Title', 'ova-sev' ),
						'rand'  => esc_html__( 'Random', 'ova-sev' ),
						'ova_sev_met_order_sev' => esc_html__( 'Sort Order', 'ova-sev' ),
					],
				]
			);

			$this->add_control(
				'posts_per_page',
				[
					'label' => esc_html__( 'Total', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::NUMBER,
					'default' => 3,
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'show_icon',
				[
					'label' => esc_html__( 'Show Icon', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-sev' ),
					'label_off' => esc_html__( 'Hide', 'ova-sev' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_title',
				[
					'label' => esc_html__( 'Show Title', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-sev' ),
					'label_off' => esc_html__( 'Hide', 'ova-sev' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_link_of_title',
				[
					'label' => esc_html__( 'Show Link of Title', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-sev' ),
					'label_off' => esc_html__( 'Hide', 'ova-sev' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_desc',
				[
					'label' => esc_html__( 'Show Short Description', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-sev' ),
					'label_off' => esc_html__( 'Hide', 'ova-sev' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_button',
				[
					'label' => esc_html__( 'Show Button', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-sev' ),
					'label_off' => esc_html__( 'Hide', 'ova-sev' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();
		$template = apply_filters( 'el_elementor_ova_sev_items', 'elementor/ova_sev_items.php' );

		ob_start();
		ovasev_get_template( $template, $settings );
		echo ob_get_clean();
	}
}
