<?php
namespace ova_sev_elementor\Widgets;

use Elementor\Widget_Base;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class ova_sev_table_of_contents extends Widget_Base {

	public function get_name() {
		return 'ova_sev_table_of_contents';
	}

	public function get_title() {
		return esc_html__( 'Service Table of Contents', 'ova-sev' );
	}

	public function get_icon() {
		return 'eicon-table-of-contents';
	}

	public function get_categories() {
		return [ 'ovatheme_service' ];
	}

	public function get_script_depends() {
		wp_enqueue_script('ova-sev-table-of-content', OVASEV_PLUGIN_URI.'assets/js/elementor/sev-table-of-content.js', array('jquery'), false, true);
		return [ '' ];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'ova-sev-table-of-content', OVASEV_PLUGIN_URI.'/assets/css/elementor/sev-table-of-content.css', array(), null);
		return [];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Content', 'ova-sev' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

			$this->add_control(
				'wc_content_warning',
				[
					'type' 	=> \Elementor\Controls_Manager::RAW_HTML,
					'raw' 	=> esc_html__( "Don't enter Service ID if you use this element in Service Sidebar.In Elementor Preview ( When empty Service ID ) , this element display an example service TOC of the latest service", 'ova-sev' ),
					'content_classes' => 'elementor-panel-alert elementor-panel-alert-info',
				]
			);

			$this->add_control(
				'sid',
				[
					'label'  => esc_html__( 'Service ID', 'ova-sev' ),
					'type'   => \Elementor\Controls_Manager::NUMBER,
				]
			);	

			$this->add_control(
				'title',
				[
					'label'  => esc_html__( 'Title', 'ova-sev' ),
					'type'   => \Elementor\Controls_Manager::TEXT,
					'default' => esc_html__( 'On this page', 'ova-sev' ),
				]
			);	

			$this->add_control(
				'create_manually',
				[
					'label' => esc_html__( 'Create TOC Manually', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Yes', 'ova-sev' ),
					'label_off' => esc_html__( 'No', 'ova-sev' ),
					'return_value' => 'yes',
					'default' => 'no',
				]
			);

			$repeater = new \Elementor\Repeater();

			$repeater->add_control(
				'heading',
				[
					'label' 	=> esc_html__( 'Heading', 'ova-sev' ),
					'type' 		=> \Elementor\Controls_Manager::TEXT,
					'default' 	=> esc_html__('Overview', 'ova-sev' ),
				]
			);

            $repeater->add_control(
				'anchor',
				[
					'label' 	=> esc_html__( 'Anchor Link', 'ova-sev' ),
					'type' 		=> \Elementor\Controls_Manager::TEXT,
				]
			);

			$this->add_control(
				'items',
				[
					'label' 	=> esc_html__( 'Items', 'ova-sev' ),
					'type' 		=> \Elementor\Controls_Manager::REPEATER,
					'fields' 	=> $repeater->get_controls(),
					'title_field' => '{{{ heading }}}',
					'default' 	=> [
						[
							'heading'  => esc_html__( 'Overview', 'ova-sev' ),
							'anchor' => '#overview',
						],
						[
							'heading'  => esc_html__( 'Our Benefits', 'ova-sev' ),
							'anchor' => '#our_benefits',
						],
						[
							'heading'  => esc_html__( 'Guidance', 'ova-sev' ),
							'anchor' => '#guidance'
						],
						[
							'heading'  => esc_html__( 'How to', 'ova-sev' ),
							'anchor' => '#how_to'
						],
						[
							'heading'  => esc_html__( 'Options', 'ova-sev' ),
							'anchor' => '#options'
						],
					],
					'condition' => [
						'create_manually' => 'yes',
					],
				]
			);

		$this->end_controls_section();

	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		$template = apply_filters( 'el_elementor_ova_sev_table_of_contents', 'elementor/ova_sev_table_of_contents.php' );

		ob_start();
		ovasev_get_template( $template, $settings );
		echo ob_get_clean();
	}
}
