<?php

if ( ! defined('ABSPATH') ) {
	exit();
}


if ( ! class_exists( 'OVASEV_Ajax' ) ) {
	
	class OVASEV_Ajax {

		public function __construct(){

			add_action( 'wp_ajax_ova_sev_pagination_ajax', array( $this, 'ova_sev_pagination_ajax' ) );
			add_action( 'wp_ajax_nopriv_ova_sev_pagination_ajax', array( $this, 'ova_sev_pagination_ajax' ) );

			add_action( 'wp_ajax_ova_sev_filter_ajax', array( $this, 'ova_sev_filter_ajax' ) );
			add_action( 'wp_ajax_nopriv_ova_sev_filter_ajax', array( $this, 'ova_sev_filter_ajax' ) );

			add_action( 'wp_ajax_ova_service_ajax', array( $this, 'ova_service_ajax' ) );
			add_action( 'wp_ajax_nopriv_ova_service_ajax', array( $this, 'ova_service_ajax' ) );
		}

		public function ova_sev_pagination_ajax() {
			$args 			= isset($_POST['args']) ? $_POST['args'] : [];
			$offset			= isset($_POST['offset']) ? $_POST['offset'] : 0;
			$curent_page 	= isset($_POST['page']) ? $_POST['page'] : 1;
			$s_sort 		= isset($_POST['search_sort']) ? sanitize_text_field($_POST['search_sort']) : 'date-desc';
			$args_show      = isset($_POST['args_show']) ? $_POST['args_show'] : [];

			$args['offset'] = intval( $offset );
			$services 		= ova_sev_query( $args );

			$total_pages 	= $services->max_num_pages;
			$post_per_page 	= intval( $args['posts_per_page'] );

			ob_start();
			ova_get_sev_list( $services, $s_sort, $args_show);
			ova_sev_pagination_ajax($total_pages,$curent_page,$post_per_page,$args,$s_sort);
			echo ob_get_clean();
			wp_die();
		}

		public function ova_sev_filter_ajax(){

			$form_data = $_POST['form_data'];
			if( !isset($form_data) ) return;

			$cate_name 		= sanitize_text_field( $form_data['cate_name'] );
			$cate_slug 		= sanitize_text_field( urldecode($form_data['cate_slug']) );
			$s_sort 		= sanitize_text_field( $form_data['s_sort'] );

			$post_per_page 	= sanitize_text_field( $form_data['post_per_page'] );
			$order_by 		= sanitize_text_field( $form_data['order'] );
			$order 			= sanitize_text_field( $form_data['order_by'] );
			$args_show      = isset($form_data['args_show']) ? $form_data['args_show'] : [];

			if($s_sort == 'date-desc') {
				$order_by 		= 'date';
				$order 			= 'DESC';
			} elseif($s_sort == 'date-asc'){
				$order_by 		= 'date';
				$order 			= 'ASC';
			} elseif($s_sort == 'z-a'){
				$order_by 		= 'title';
				$order 			= 'DESC';
			} elseif($s_sort == 'a-z'){
				$order_by 		= 'title';
				$order 			= 'ASC';
			} elseif($s_sort == 'sort-order-desc'){
				$order_by 		= 'ova_sev_met_order_sev';
				$order 			= 'DESC';
			}  elseif($s_sort == 'sort-order-asc'){
				$order_by 		= 'ova_sev_met_order_sev';
				$order 			= 'ASC';
			} elseif($s_sort == 'rand'){
				$order_by 		= 'rand';
			}

			$args = array(
				'order_by' 			=> $order_by,
				'order' 			=> $order,
				'posts_per_page' 	=> $post_per_page,
				'cate' 				=> $cate_slug,
				'cate_name'			=> trim( $cate_name ),
			);

			$services 		= ova_sev_query( $args );
			$total_pages 	= $services->max_num_pages;
			$curent_page 	= 1;

			ob_start();
			ova_get_sev_list( $services, $s_sort, $args_show );
			ova_sev_pagination_ajax($total_pages,$curent_page,$post_per_page,$args,$s_sort);
			echo ob_get_clean();
			wp_die();
		}

		public function ova_service_ajax(){
			$cate_slug 		= isset($_POST['cate_slug']) ? sanitize_text_field( urldecode($_POST['cate_slug']) ) : '';
			$posts_per_page = isset($_POST['posts_per_page']) ? sanitize_text_field( $_POST['posts_per_page'] ) : 9;
			$order 			= isset($_POST['order']) ? sanitize_text_field( $_POST['order'] ) : 'ASC';
			$orderby 		= isset($_POST['orderby']) ? sanitize_text_field( $_POST['orderby'] ) : 'title';
			$show_desc      = isset($_POST['show_desc']) ? sanitize_text_field( $_POST['show_desc'] ) : 'yes';

			$term 	  = get_term_by('slug', $cate_slug, 'cat_sev');
			$cat_name = $term->name;

			// Services
			$args_sev = array(
				'post_type' 	=> 'ova_sev',
				'numberposts' 	=> $posts_per_page,
				'order' 		=> $order,
				'orderby' 		=> $orderby,
			);

			if($cate_slug) {
				$args_sev['tax_query'] = array(
			        array(
			            'taxonomy' => 'cat_sev',
			            'field' => 'slug',
			            'terms' => $cate_slug,
			            'include_children' => true
			        ),
			    );
			}

			$list_sevs = get_posts( $args_sev );

			ob_start();
			ova_get_service_ajax( $cat_name, $list_sevs, $show_desc );
			echo ob_get_clean();
			wp_die();
		}
	}

	new OVASEV_Ajax();
}