<?php defined( 'ABSPATH' ) || exit();

if( !class_exists( 'OVASEV_assets' ) ){
	class OVASEV_assets{

		public function __construct(){

			add_action( 'wp_enqueue_scripts', array( $this, 'ovasev_enqueue_scripts' ), 10, 0 );

		}


		public function ovasev_enqueue_scripts(){

			if ( is_tax( 'cat_sev' ) || is_post_type_archive( 'ova_sev' ) ) {
				// Select2
				wp_enqueue_script( 'select2', OVASEV_PLUGIN_URI.'assets/libs/select2/select2.min.js', array('jquery'), false, true );
				wp_enqueue_style( 'select2', OVASEV_PLUGIN_URI.'assets/libs/select2/select2.min.css', array(), null );

				wp_enqueue_style( 'ovasev_style', OVASEV_PLUGIN_URI.'assets/css/frontend/ovasev-style.css' );
				wp_enqueue_script('ova_sev_script', OVASEV_PLUGIN_URI.'assets/js/ova-sev.js', array('jquery'), false, true);
				wp_localize_script( 'ova_sev_script', 'Placeholder', array('name' => esc_html__( 'Name', 'ova-sev' )) );
				wp_localize_script( 'ova_sev_script', 'ova_sev_ajax_object', array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );
			}

			if ( is_singular( 'ova_sev' ) ) {
				wp_enqueue_style( 'ovasev_style', OVASEV_PLUGIN_URI.'assets/css/frontend/ovasev-style.css' );
			}

		}

	}
	new OVASEV_assets();
}
