<?php

if ( !defined( 'ABSPATH' ) ) {
	exit;
}

class OVASEV_templates_loader {
	
	/**
	 * The Constructor
	 */
	public function __construct() {
		add_filter( 'template_include', array( $this, 'template_loader' ) );
	}

	public function template_loader( $template ) {

		$post_type = isset($_REQUEST['post_type'] ) ? esc_html( $_REQUEST['post_type'] ) : get_post_type();

		$single_sev_template = get_theme_mod( 'ova_sev_single_template', 'template_1' );

		$single_template = get_post_meta( get_the_ID(), 'ova_sev_met_single_template', true );
	    if ( $single_template != '' ) {
	        $single_sev_template = $single_template;
	    }

		if( is_tax( 'cat_sev' ) ||  get_query_var( 'cat_sev' ) != '' ){
			ovasev_get_template( 'archive-sev.php' );
			return false;
		}


		// Is Service Post Type
		if(  $post_type == 'ova_sev' ){

			if ( is_post_type_archive( 'ova_sev' ) ) { 

				ovasev_get_template( 'archive-sev.php' );
				return false;

			} else if ( is_single() ) {

				if ( $single_sev_template == 'template_2' ) {
					ovasev_get_template( 'single-sev-2.php' );
				} else {
					ovasev_get_template( 'single-sev.php' );
				}
				return false;

			}
		}


		if ( $post_type !== 'ova_sev' ){
			return $template;
		}
	}
}

new OVASEV_templates_loader();