<?php if ( !defined( 'ABSPATH' ) ) exit();

	$all_ids = ova_sev_get_all_id();

	if( isset( $args['sid'] ) && $args['sid'] != '' ) {

	    $id  = ( in_array( $args['sid'], $all_ids ) == true ) ? $args['sid'] : get_the_id();

	} elseif( in_array( get_the_id(), $all_ids ) == false ) {

	    $id  = $all_ids[0];

	} else {
	    $id  = get_the_id();
	}

	$content_post = get_post($id);
	$content 	  = $content_post->post_content;

	preg_match_all( '@<h2.*?>(.*?)<\/h2>@', $content, $matches_h2 );

	$tags_h2 = '';

	if( isset($matches_h2[1]) ) {
		$tags_h2 = $matches_h2[1];
	}

	// create manually
	$items = isset($args['items']) ? $args['items'] : '';

?>

<?php if( $create_manually != 'yes' ) { ?>
	<?php if( $tags_h2 || $title ) { ?>
		<div class="ova-sev-table-of-contents">
			<?php if($title) { ?>
				<h3 class="toc-title"><?php echo esc_html( $title ); ?></h3>
			<?php } ?>
			<?php if($tags_h2) { ?>
			<ul class="toc-items">
				<?php foreach($tags_h2 as $tag_h2) { 
					$href = '#'.ovasev_slugify($tag_h2);;
				?>
					<li>
						<a href="<?php echo esc_url($href);?>">
							<?php echo esc_html( $tag_h2 ); ?>
						</a>
					</li>
				<?php } ?>	
			</ul>
			<?php } ?>
		</div>
	<?php } ?>
<?php } else { ?>
	<?php if( $items ) { ?>
		<div class="ova-sev-table-of-contents">
			<?php if($title) { ?>
				<h3 class="toc-title"><?php echo esc_html( $title ); ?></h3>
			<?php } ?>
			<ul class="toc-items">
				<?php foreach($items as $item) { 
					$href = $item['anchor'];
				?>
					<li>
						<a href="<?php echo esc_url($href);?>">
							<?php echo esc_html( $item['heading'] ); ?>
						</a>
					</li>
				<?php } ?>	
			</ul>
		</div>
	<?php } ?>
<?php } ?>