<?php
/**
 * Include and setup custom metaboxes and fields. (make sure you copy this file to outside the CMB2 directory)
 *
 * Be sure to replace all instances of 'yourprefix_' with your project's prefix.
 * http://nacin.com/2010/05/11/in-wordpress-prefix-everything/
 *
 * @category YourThemeOrPlugin
 * @package  Demo_CMB2
 * @license  http://www.opensource.org/licenses/gpl-license.php GPL v2.0 (or later)
 * @link     https://github.com/WebDevStudios/CMB2
 */



add_action( 'cmb2_init', 'ova_team_metaboxes' );
function ova_team_metaboxes() {

    // Start with an underscore to hide fields from custom fields list
    $prefix = 'ova_team_met_';
    
    /* Team Settings ***************************************************************************/
    /* ************************************************************************************/
    $team_settings = new_cmb2_box( array(
        'id'            => 'ovateam_settings',
        'title'         => esc_html__( 'Team settings', 'ova-team' ),
        'object_types'  => array( 'team'), // Post type
        'context'       => 'normal',
        'priority'      => 'high',
        'show_names'    => true,
        
    ) );

        $team_settings->add_field( array(
            'name'    => esc_html__( 'Job', 'ova-team' ),
            'id'      => $prefix . 'job',
            'type'    => 'text',
        ) );
        
        $team_settings->add_field( array(
            'name'    => esc_html__( 'Slogan', 'ova-team' ),
            'id'      => $prefix . 'slogan',
            'type'    => get_theme_mod('ova_team_slogan_field_type','textarea'),
        ) );

        $team_settings->add_field( array(
            'name'    => esc_html__( 'Short Description', 'ova-team' ),
            'id'      => $prefix . 'short_desc',
            'type'    => get_theme_mod('ova_team_short_desc_field_type','textarea'),
        ) );

        $team_settings->add_field( array(
            'name'    => esc_html__( 'Experience', 'ova-team' ),
            'id'      => $prefix . 'experience',
            'type'    => 'text',
        ) );

        $team_settings->add_field( array(
            'name' => esc_html__( 'Email', 'ova-team' ),
            'id'   => $prefix . 'email',
            'type' => 'text_email',
        ) );

        $team_settings->add_field( array(
            'name'   => esc_html__( 'Phone', 'ova-team' ),
            'id'     => $prefix . 'phone',
            'type'   => 'text',
        ) );

        $group_processing = $team_settings->add_field( array(
            'id'          => $prefix . 'group_processing',
            'type'        => 'group',
            'description' => esc_html__( 'List Process', 'ova-team' ),
            'options'     => array(
                'group_title'       => esc_html__( 'Processing', 'ova-team' ), 
                'add_button'        => esc_html__( 'Add Process', 'ova-team' ),
                'remove_button'     => esc_html__( 'Remove', 'ova-team' ),
                'sortable'          => true,
               
            ),
        ) );

        $team_settings->add_group_field( $group_processing, array(
            'name' => esc_html__( 'Text', 'ova-team' ),
            'id'   => $prefix . 'text_process',
            'type' => 'text',
        ) );

        $team_settings->add_group_field( $group_processing, array(
            'name' => esc_html__( 'Percent (%)', 'ova-team' ),
            'id'   => $prefix . 'percent_process',
            'type' => 'text',
        ) );

        $group_icon = $team_settings->add_field( array(
            'id'          => $prefix . 'group_icon',
            'type'        => 'group',
            'description' => esc_html__( 'List Social', 'ova-team' ),
            'options'     => array(
                'group_title'       => esc_html__( 'Social', 'ova-team' ), 
                'add_button'        => esc_html__( 'Add Social', 'ova-team' ),
                'remove_button'     => esc_html__( 'Remove', 'ova-team' ),
                'sortable'          => true,
               
            ),
        ) );

        $team_settings->add_group_field( $group_icon, array(
            'name' => esc_html__( 'Class icon social', 'ova-team' ),
            'id'   => $prefix . 'class_icon_social',
            'type' => 'text',
        ) );


         $team_settings->add_group_field( $group_icon, array(
            'name' => esc_html__( 'Link social', 'ova-team' ),
            'id'   => $prefix . 'link_social',
            'type' => 'text_url',
        ) );

        $team_settings->add_field( array(
            'name'    => esc_html__( 'Sort Order', 'ova-team' ),
            'id'      => $prefix . 'order_team',
            'desc'    => esc_html__( 'Insert Number', 'ova-team' ),
            'type'    => 'text',
            'default' =>'1',
        ) );
    }

