<?php defined( 'ABSPATH' ) || exit();

if( !class_exists( 'OVATEAM_assets' ) ){
	class OVATEAM_assets{

		public function __construct(){

			add_action( 'wp_enqueue_scripts', array( $this, 'ovateam_enqueue_scripts' ), 10, 0 );

			/* Add JS for Elementor */
			add_action( 'elementor/frontend/after_register_scripts', array( $this, 'ova_enqueue_scripts_elementor_team' ) );
		}


		public function ovateam_enqueue_scripts(){

			// Js & Css
			if( is_post_type_archive('team') || is_tax('cat_team') || is_singular('team') ) {
				wp_enqueue_script('ovateam_script', OVATEAM_PLUGIN_URI.'assets/js/ova_team.js', array('jquery'), false , true);	
				wp_localize_script( 'ovateam_script', 'ova_team_ajax_object', array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );
				wp_enqueue_style( 'ovateam_style', OVATEAM_PLUGIN_URI.'assets/css/frontend/ovateam-style.css' );
			}

			if( is_post_type_archive('team') || is_tax('cat_team') ) { 
				wp_enqueue_style( 'ovateam_general', OVATEAM_PLUGIN_URI.'assets/css/frontend/ovateam-general.css' );
				wp_enqueue_style( 'ova-team-grid-2', OVATEAM_PLUGIN_URI.'assets/css/elementor/our-team-grid-2.css' );
				wp_enqueue_style( 'ova-team-grid-3', OVATEAM_PLUGIN_URI.'assets/css/elementor/our-team-grid-3.css' );
			}

		}

		/* Add JS for Elementor */
		public function ova_enqueue_scripts_elementor_team(){
			wp_register_script( 'script-elementor-team', OVATEAM_PLUGIN_URI. 'assets/js/script-elementor.js', [ 'jquery' ], false, true );
		}

	}

	new OVATEAM_assets();
}